/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.util.Enumeration;
import java.util.Hashtable;

public class RoleChecker {
    public static int SUPERUSER = 1;
    public static int APERI_ADMIN = 2;
    public static int DISK_VIEWER = 4;
    public static int DISK_ADMIN = 8 | DISK_VIEWER;
    public static int FABRIC_VIEWER = 16;
    public static int FABRIC_ADMIN = 0x20 | FABRIC_VIEWER;
    public static int DATA_VIEWER = 64;
    public static int DATA_ADMIN = 0x80 | DATA_VIEWER;
    public static int TAPE_VIEWER = 1024;
    public static int TAPE_ADMIN = 0x800 | TAPE_VIEWER;
    public static int NO_ROLE = 0;
    public static String APERI_SUPERUSER = "Superuser";
    public static String APERI_ADMINISTRATOR = "Aperi Administrator";
    public static String DISK_ADMINISTRATOR = "Disk Administrator";
    public static String DISK_OPERATOR = "Disk Operator";
    public static String FABRIC_ADMINISTRATOR = "Fabric Administrator";
    public static String FABRIC_OPERATOR = "Fabric Operator";
    public static String DATA_ADMINISTRATOR = "Data Administrator";
    public static String DATA_OPERATOR = "Data Operator";
    public static String TAPE_ADMINISTRATOR = "Tape Administrator";
    public static String TAPE_OPERATOR = "Tape Operator";
    private static Hashtable roleMap = new Hashtable();

    static {
        roleMap.put(APERI_SUPERUSER, new Integer(SUPERUSER));
        roleMap.put(APERI_ADMINISTRATOR, new Integer(APERI_ADMIN));
        roleMap.put(DISK_ADMINISTRATOR, new Integer(DISK_ADMIN));
        roleMap.put(DISK_OPERATOR, new Integer(DISK_VIEWER));
        roleMap.put(FABRIC_ADMINISTRATOR, new Integer(FABRIC_ADMIN));
        roleMap.put(FABRIC_OPERATOR, new Integer(FABRIC_VIEWER));
        roleMap.put(DATA_ADMINISTRATOR, new Integer(DATA_ADMIN));
        roleMap.put(DATA_OPERATOR, new Integer(DATA_VIEWER));
        roleMap.put(TAPE_ADMINISTRATOR, new Integer(TAPE_ADMIN));
        roleMap.put(TAPE_OPERATOR, new Integer(TAPE_VIEWER));
    }

    public static String getRoleName(int n) {
        String string = null;
        Integer n2 = new Integer(n);
        if (roleMap.contains(n2)) {
            Enumeration enumeration = roleMap.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Integer n3 = (Integer)roleMap.get(k);
                if (n2.compareTo(n3) != 0) continue;
                string = (String)k;
                break;
            }
        }
        return string;
    }

    public static int getRoleID(String string) {
        int n = 0;
        Integer n2 = RoleChecker.getIntegerRoleID(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static Integer getIntegerRoleID(String string) {
        Integer n = null;
        if (string != null && roleMap.containsKey(string)) {
            n = (Integer)roleMap.get(string);
        }
        return n;
    }

    public static boolean isValidRole(int n) {
        boolean bl = false;
        if (n < SUPERUSER) {
            return bl;
        }
        if (n == SUPERUSER) {
            bl = true;
        } else {
            int n2 = APERI_ADMIN | DATA_ADMIN | TAPE_ADMIN | FABRIC_ADMIN | DISK_ADMIN;
            if ((n & n2) == n) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isUserInRole(int n, int n2) {
        boolean bl = false;
        if (RoleChecker.isValidRole(n2) && RoleChecker.isValidRole(n)) {
            bl = n == SUPERUSER ? true : (n == n2 ? true : ((n & n2) == 0 ? false : (n & n2) == n2));
        }
        return bl;
    }
}

