/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.topology.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.handler.LegacyViewerRequestDispatcher;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerAutoRefreshTimer;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerCache;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestDispatcher;

public class TopologyViewerDefinition
extends JPanel
implements GuiRequestor,
ActionListener {
    JTopoApp view = null;
    ViewerRequestDispatcher dispatcher = new LegacyViewerRequestDispatcher();
    ViewerAutoRefreshTimer timer;
    private ControllerApp controllerApp;

    public TopologyViewerDefinition() {
        this.init();
    }

    private void init() {
        ViewerCache.clearCache();
        this.timer = new ViewerAutoRefreshTimer(this.dispatcher);
        this.timer.setTimeout(300000);
        this.timer.startTimer();
        if (this.view != null) {
            this.buildPanel();
        } else {
            this.controllerApp = new ControllerApp();
            TopoSetting topoSetting = new TopoSetting();
            this.controllerApp.setSessionModel(this.dispatcher, topoSetting);
            this.dispatcher.requestTopoSettings(this.controllerApp);
            this.dispatcher.setTimer(this.timer);
            this.view = this.controllerApp.getTopoApp();
            this.dispatcher.addListener(this.controllerApp);
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)this.view, "Center");
        }
    }

    public void buildPanel() {
    }

    private void setButtons() {
    }

    public void handleResponse(short s, Response response) {
    }

    public String getCurrentViewType() {
        Vector vector;
        if (this.dispatcher != null && (vector = this.dispatcher.getOpenedViews()) != null && vector.size() > 0) {
            Iterator iterator = vector.iterator();
            GraphModel.ID iD = (GraphModel.ID)iterator.next();
            return iD.getFocusLevel();
        }
        return null;
    }

    public void print(Container container) {
        if (this.dispatcher != null) {
            this.dispatcher.print(container);
        }
    }

    public static boolean changesPending() {
        return false;
    }

    public void setConfigOUT() {
        if (this.timer != null) {
            this.timer.stopTimer();
        }
    }

    public void openView(GraphModel.ID iD) {
        if (this.dispatcher != null) {
            this.dispatcher.getITopoFrontend().openView(iD);
        }
        if (this.timer != null && this.timer.isStopped()) {
            this.timer.startTimer();
        }
    }

    public void goingAway() {
        if (this.timer != null) {
            this.timer.stopTimer();
        }
        if (this.dispatcher != null) {
            this.dispatcher.close();
            this.dispatcher = null;
        }
        this.view = null;
    }

    public void save() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dispatcher != null) {
            this.dispatcher.cancelAll();
        }
    }

    public void finalize() {
        this.goingAway();
    }
}

