/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.pool;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.util.pool.ResourceCreator;

public class Pool {
    Hashtable activeResources = new Hashtable();
    Hashtable idleResources = new Hashtable();
    ResourceCreator creator = null;

    public Pool(ResourceCreator resourceCreator) {
        this.creator = resourceCreator;
    }

    public static String normalize(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            stringBuffer.append(String.valueOf(k.toString()) + ":" + v.toString());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Hashtable hashtable) {
        String string = Pool.normalize(hashtable);
        Object object = null;
        Hashtable hashtable2 = this.idleResources;
        synchronized (hashtable2) {
            ArrayList arrayList = (ArrayList)this.idleResources.get(string);
            object = arrayList != null && !arrayList.isEmpty() ? arrayList.remove(0) : this.creator.createResource(hashtable);
        }
        hashtable2 = this.activeResources;
        synchronized (hashtable2) {
            this.activeResources.put(object, string);
        }
        this.creator.initializeResource(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeResource(Object object) {
        this.creator.freeResource(object);
        Object k = null;
        Hashtable hashtable = this.activeResources;
        synchronized (hashtable) {
            k = this.activeResources.remove(object);
        }
        if (k == null) {
            System.out.println("ERROR IN POOL - attempted to free resource " + object + " which isn't listed as active.");
            return false;
        }
        hashtable = this.idleResources;
        synchronized (hashtable) {
            ArrayList<Object> arrayList = (ArrayList<Object>)this.idleResources.get(k);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                this.idleResources.put(k, arrayList);
            }
            arrayList.add(object);
        }
        return true;
    }
}

