/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class IntlMessageFormat
extends Format {
    static final long serialVersionUID = 5553285815511168954L;
    protected MessageFormat format_ = null;
    private Locale locale_ = null;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_LITERAL_BRACE = 2;
    private static final int STATE_MSG_ELEMENT = 3;

    public IntlMessageFormat(String string) {
        this.format_ = new MessageFormat(string);
        this.applyPattern(string);
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
        this.format_.setLocale(this.locale_);
    }

    public Locale getLocale() {
        return this.format_.getLocale();
    }

    public void applyPattern(String string) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        char c = '{';
        char c2 = '}';
        StringBuffer stringBuffer = null;
        vector.clear();
        if (string.indexOf(39) >= 0) {
            string = IntlMessageFormat.fixPattern(string);
        }
        this.format_.applyPattern(string);
        int n = 0;
        while (n < string.length()) {
            char c3 = string.charAt(n);
            if (!bl) {
                if (c3 == c) {
                    stringBuffer = new StringBuffer();
                    bl = true;
                }
            } else if (c3 == c2) {
                bl = false;
                vector.add(stringBuffer.toString());
            } else {
                stringBuffer.append(c3);
            }
            ++n;
        }
        Format format = null;
        Locale locale = this.locale_ == null ? Locale.getDefault() : this.locale_;
        int n2 = 0;
        while (n2 < vector.size()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)vector.elementAt(n2), ",");
            if (stringTokenizer.countTokens() == 2 || stringTokenizer.countTokens() == 3) {
                String string2;
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("time")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("short")) {
                            format = DateFormat.getTimeInstance(3, locale);
                        } else if (string2.equals("medium")) {
                            format = DateFormat.getTimeInstance(2, locale);
                        } else if (string2.equals("long")) {
                            format = DateFormat.getTimeInstance(1, locale);
                        } else if (string2.equals("full")) {
                            format = DateFormat.getTimeInstance(0, locale);
                        } else {
                            format = DateFormat.getTimeInstance(2, locale);
                            ((SimpleDateFormat)format).applyPattern(string2);
                        }
                    } else {
                        format = DateFormat.getTimeInstance(2, locale);
                    }
                    this.format_.setFormat(n2, format);
                } else if (string3.equals("date")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("short")) {
                            format = DateFormat.getDateInstance(3, locale);
                        } else if (string2.equals("medium")) {
                            format = DateFormat.getDateInstance(2, locale);
                        } else if (string2.equals("long")) {
                            format = DateFormat.getDateInstance(1, locale);
                        } else if (string2.equals("full")) {
                            format = DateFormat.getDateInstance(0, locale);
                        } else {
                            format = DateFormat.getDateInstance(2, locale);
                            ((SimpleDateFormat)format).applyPattern(string2);
                        }
                    } else {
                        format = DateFormat.getDateInstance(2, locale);
                    }
                    this.format_.setFormat(n2, format);
                } else if (string3.equals("number")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("currency")) {
                            format = NumberFormat.getCurrencyInstance(locale);
                        } else if (string2.equals("percent")) {
                            format = NumberFormat.getPercentInstance(locale);
                        } else if (string2.equals("integer")) {
                            format = NumberFormat.getNumberInstance(locale);
                            ((DecimalFormat)format).setMaximumFractionDigits(0);
                            ((DecimalFormat)format).setDecimalSeparatorAlwaysShown(false);
                            ((DecimalFormat)format).setParseIntegerOnly(true);
                        } else {
                            format = NumberFormat.getInstance(locale);
                            ((DecimalFormat)format).applyPattern(string2);
                        }
                    } else {
                        format = NumberFormat.getNumberInstance(locale);
                    }
                    this.format_.setFormat(n2, format);
                }
            }
            ++n2;
        }
    }

    public String toPattern() {
        return this.format_.toPattern();
    }

    public void setFormats(Format[] formatArray) {
        this.format_.setFormats(formatArray);
    }

    public void setFormat(int n, Format format) {
        this.format_.setFormat(n, format);
    }

    public Format[] getFormats() {
        return this.format_.getFormats();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format_.format(objectArray, stringBuffer, fieldPosition);
    }

    public static String format(String string, Object[] objectArray) {
        IntlMessageFormat intlMessageFormat = new IntlMessageFormat(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = intlMessageFormat.format(objectArray, stringBuffer, (FieldPosition)null);
        return new String(stringBuffer);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format_.format(object, stringBuffer, fieldPosition);
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        return this.format_.parse(string, parsePosition);
    }

    public Object[] parse(String string) throws ParseException {
        return this.format_.parse(string);
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.format_.parseObject(string, parsePosition);
    }

    public Object clone() {
        IntlMessageFormat intlMessageFormat = (IntlMessageFormat)super.clone();
        intlMessageFormat.format_ = (MessageFormat)this.format_.clone();
        return intlMessageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof IntlMessageFormat)) {
            return false;
        }
        return this.format_.equals(((IntlMessageFormat)object).format_);
    }

    public int hashCode() {
        return this.format_.hashCode();
    }

    private static String fixPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            block0 : switch (n) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            n = 1;
                            break;
                        }
                        case '{': {
                            n = 3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            n = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            n = 2;
                            break block0;
                        }
                    }
                    stringBuffer.append('\'');
                    n = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            n = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '}': {
                            n = 0;
                        }
                    }
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        if (n == 1) {
            stringBuffer.append('\'');
        }
        return new String(stringBuffer);
    }
}

