/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.IOException;
import org.eclipse.aperi.xmsg.LoggerRegistry;
import org.eclipse.aperi.xmsg.MessageRegistry;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.WrappedLogger;

public class LocalizableException
extends IOException {
    static final long serialVersionUID = 5691777094922365144L;
    private static final int MAX_PRODUCTID_LENGTH = 5;
    protected String key;
    protected Object[] parameters;
    private transient MessageTextRenderer renderer;
    private transient String renderedMessage;

    private static String keyToProductID(String string) {
        char c;
        int n = string.length();
        if (n > 5) {
            n = 5;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n && Character.isUpperCase(c = string.charAt(n2))) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private ClassLoader getCallingLoader() {
        Throwable throwable = new Throwable();
        throwable.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Class<?> clazz = stackTraceElementArray[2].getClass();
        return clazz.getClassLoader();
    }

    public LocalizableException(String string, Object[] objectArray) {
        this.key = string;
        this.parameters = objectArray;
        ClassLoader classLoader = this.getCallingLoader();
        String string2 = LocalizableException.keyToProductID(this.key);
        this.renderer = MessageRegistry.lookUpRenderer(classLoader, string2);
    }

    public String getMessage(WrappedLogger wrappedLogger) {
        String string = null;
        if (this.renderer != null) {
            string = this.renderer.renderMessageText(this.key, this.parameters);
        }
        String string2 = string != null ? wrappedLogger.formatMessage(this.key, string) : wrappedLogger.formatUnrecognizedMessage(this.key, this.parameters);
        return string2;
    }

    public String getMessage() {
        if (this.renderedMessage != null) {
            return this.renderedMessage;
        }
        ClassLoader classLoader = this.getCallingLoader();
        WrappedLogger wrappedLogger = LoggerRegistry.getLogger(classLoader);
        return this.getMessage(wrappedLogger);
    }

    public void printStackTrace() {
        ClassLoader classLoader = this.getCallingLoader();
        WrappedLogger wrappedLogger = LoggerRegistry.getLogger(classLoader);
        this.renderedMessage = this.getMessage(wrappedLogger);
        this.printStackTrace(wrappedLogger.getPrintWriter());
        this.renderedMessage = null;
    }

    public void print() {
        ClassLoader classLoader = this.getCallingLoader();
        WrappedLogger wrappedLogger = LoggerRegistry.getLogger(classLoader);
        String string = this.getMessage(wrappedLogger);
        wrappedLogger.getPrintWriter().println(string);
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getParameters() {
        return this.parameters;
    }
}

