/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.tape.TapeActivator;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.collection.ProbeGenericTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.TapeCIMProcessor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeTapeLibraryProcess
extends ProbeGenericTapeLibraryProcess {
    public ProbeTapeLibraryProcess(String string, boolean bl) {
        Class<?> clazz;
        Class<?> clazz2;
        String[] stringArray = new String[2];
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz.getName();
        super(string, bl, new String[]{"TAPELIBRARY", "COLLTYPE"}, stringArray);
    }

    public Result process(Request request, Map map) throws ParameterException {
        Class<?> clazz;
        Result result;
        ILogger iLogger;
        block29: {
            Object object;
            String string;
            CIMObjectPath cIMObjectPath;
            CIMOMSelector.TapeLibraryConnectionData tapeLibraryConnectionData;
            HashMap hashMap;
            TapeCIMProcessor tapeCIMProcessor;
            block26: {
                Class<?> clazz2;
                Result result2;
                block27: {
                    iLogger = request.getJobLogger();
                    if (iLogger != null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        iLogger.setMessageFile(clazz3.getName());
                    }
                    tapeCIMProcessor = new TapeCIMProcessor(request.getScannerId());
                    try {
                        TapeReportingService tapeReportingService = new TapeReportingService();
                        String string2 = (String)map.get("TAPELIBRARY");
                        hashMap = tapeReportingService.getTapeLibraryAttributes(new String[]{string2}, new String[]{"TAPE_LIBRARY_ID", "CREATION_CLASS_NAME_ID", "NAME", "NAME_FORMAT"})[0];
                        tapeLibraryConnectionData = null;
                        try {
                            tapeLibraryConnectionData = CIMOMSelector.getSelector().getCimomForTapeLibrary(((Integer)hashMap.get("TAPE_LIBRARY_ID")).intValue());
                        }
                        catch (CIMOMSelector.NoCimomAvailableException noCimomAvailableException) {
                            Class<?> clazz4;
                            iLogger.message(IRecordType.TYPE_ERROR, (Object)this.getClass().getName(), "process", "HWNTM1517E", (Object)((Integer)hashMap.get("TAPE_LIBRARY_ID")).toString());
                            Result result3 = new Result(1);
                            Object var18_12 = null;
                            if (tapeCIMProcessor != null) {
                                tapeCIMProcessor.end(request.getId());
                                tapeCIMProcessor.shutdown();
                                tapeCIMProcessor = null;
                            }
                            try {
                                clazz4 = Class.forName("org.eclipse.aperi.discovery.resources.JobLoggingTMS");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            iLogger.setMessageFile(clazz4.getName());
                            return result3;
                        }
                    }
                    catch (Throwable throwable) {
                        Class<?> clazz5;
                        Object var18_15 = null;
                        if (tapeCIMProcessor != null) {
                            tapeCIMProcessor.end(request.getId());
                            tapeCIMProcessor.shutdown();
                            tapeCIMProcessor = null;
                        }
                        try {
                            clazz5 = Class.forName("org.eclipse.aperi.discovery.resources.JobLoggingTMS");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        iLogger.setMessageFile(clazz5.getName());
                        throw throwable;
                    }
                    cIMObjectPath = tapeLibraryConnectionData.getTapeLibraryCop();
                    string = cIMObjectPath.getKey("CreationClassName").getValue().toString();
                    string = string.indexOf("3584") > 0 ? "3584" : (string.indexOf("3494") > 0 ? "3494" : (string.indexOf("3583") > 0 ? "3583" : (string.indexOf("3582") > 0 ? "3582" : (string.indexOf("3581") > 0 ? "3581" : "GENERIC_TAPE_LIBRARY"))));
                    if (!string.equalsIgnoreCase("3494") && !string.equalsIgnoreCase("3581") && !string.equalsIgnoreCase("3582") && !string.equalsIgnoreCase("3583")) break block26;
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Library is of type 3494, 3581, 3582 or 3583. nothing to probe for (" + string + ")");
                    }
                    result2 = new Result(0);
                    Object var18_13 = null;
                    if (tapeCIMProcessor == null) break block27;
                    tapeCIMProcessor.end(request.getId());
                    tapeCIMProcessor.shutdown();
                    tapeCIMProcessor = null;
                }
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.discovery.resources.JobLoggingTMS");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                iLogger.setMessageFile(clazz2.getName());
                return result2;
            }
            tapeCIMProcessor.initializeForTapeLibraryType(tapeLibraryConnectionData.getCapability().getSmisVersion(), string, tapeLibraryConnectionData.getCimom().getSoftwareLevel());
            String[] stringArray = new String[]{tapeLibraryConnectionData.getCimom().getServiceUrl(), tapeLibraryConnectionData.getCimom().getInteropSchemaNamespace(), tapeLibraryConnectionData.getCimom().getUserId(), tapeLibraryConnectionData.getCimom().getPassword()};
            map.put("CIMOM", stringArray);
            map = this.setTimeout(request, map);
            CIMInstance cIMInstance = new CIMInstance(cIMObjectPath);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("ref_toplevelsystem_id", hashMap.get("TAPE_LIBRARY_ID").toString());
            hashtable.put("ref_tape_library_id", hashMap.get("TAPE_LIBRARY_ID").toString());
            hashtable.put("ref_toplevelsystem_name", hashMap.get("NAME").toString());
            hashtable.put("ref_toplevelsystem_nameformat", hashMap.get("NAME_FORMAT").toString());
            hashtable.put("ref_toplevelsystem_cimom2namespaceid", new Integer(tapeLibraryConnectionData.getCimNamespaceID()).toString());
            tapeCIMProcessor.setDBReferences(hashtable);
            map.put("IN_SYSTEM_" + COMPUTERSYSTEM, cIMInstance);
            int n = (Integer)map.get("COLLTYPE");
            ArrayList<DiscoverStep> arrayList = new ArrayList<DiscoverStep>();
            if (n == 2) {
                arrayList.add(new DiscoverStep("collectChassisFromComputerSystem", null, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2100I", "HWNTM2001I", "HWNTM2200I", "HWNTM2002E")));
            }
            if (n == 3) {
                object = new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2101I", "HWNTM2001I", "HWNTM2201I", "HWNTM2002E");
                DiscoverStep discoverStep = string.equalsIgnoreCase("3584") ? this.getStepCollectStorageMediaLocationsFrom3584ComputerSystem(tapeCIMProcessor, (ProgressLogger)object) : this.getStepCollectStorageMediaLocationsFromComputerSystem(tapeCIMProcessor, (ProgressLogger)object);
                arrayList.add(discoverStep);
            }
            arrayList.add(this.getStepCollectCartridgesFromComputerSystem(tapeCIMProcessor, new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2102I", "HWNTM2001I", "HWNTM2202I", "HWNTM2002E")));
            arrayList.add(this.getStepCollectDrivesFromComputerSystem(tapeCIMProcessor, new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2103I", "HWNTM2001I", "HWNTM2203I", "HWNTM2002E")));
            arrayList.add(this.getStepCollectChangerDeviceFromComputerSystem(tapeCIMProcessor, new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2104I", "HWNTM2001I", "HWNTM2204I", "HWNTM2002E")));
            arrayList.add(this.getStepCollectLimitedAccessPortFromComputerSystem(tapeCIMProcessor, new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2105I", "HWNTM2001I", "HWNTM2205I", "HWNTM2002E")));
            arrayList.add(new DiscoverStep("collectSoftwareIdentityFromComputerSystem", null, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger(iLogger, (String)hashMap.get("NAME"), "HWNTM2106I", "HWNTM2001I", "HWNTM2206I", "HWNTM2002E")));
            if (n == 3) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Starting detailed probe of lib id " + tapeLibraryConnectionData.getTapeLibraryId() + ", CreationClassName " + string);
                }
                if (Configuration.debug) {
                    System.out.println("ProbeTapeLibraryProcess: starting detailed probe of lib id " + tapeLibraryConnectionData.getTapeLibraryId());
                }
            } else {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Starting basic probe of lib id " + tapeLibraryConnectionData.getTapeLibraryId() + ", CreationClassName " + string);
                }
                if (Configuration.debug) {
                    System.out.println("ProbeTapeLibraryProcess: starting basic probe of lib id " + tapeLibraryConnectionData.getTapeLibraryId());
                }
            }
            object = Integer.toString(request.getId());
            tapeCIMProcessor.start(request.getId());
            boolean bl = this.processSteps(arrayList, map, (String)object, iLogger);
            map.remove("CIMOM");
            map.remove("IN_SYSTEM_" + COMPUTERSYSTEM);
            result = new Result(bl ? 0 : 1);
            Object var18_14 = null;
            if (tapeCIMProcessor == null) break block29;
            tapeCIMProcessor.end(request.getId());
            tapeCIMProcessor.shutdown();
            tapeCIMProcessor = null;
        }
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.resources.JobLoggingTMS");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iLogger.setMessageFile(clazz.getName());
        return result;
    }

    private Map setTimeout(Request request, Map map) {
        String string;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)request, (Object)this, (String)"ProbeTapeLibraryProcess.setTimeout", (Object[])new Object[]{map});
        long l = 0L;
        IConfigService iConfigService = (IConfigService)TapeActivator._serviceHelper.bindLocal("ConfigService");
        if (iConfigService != null && (string = iConfigService.getProperty("http.timeout", "CIM")) != null) {
            l = Long.parseLong(string);
        }
        map = DiscoverUtils.setProbeTimeout((Map)map, (long)l, (LogTraceHelper)logTraceHelper);
        logTraceHelper.exit(null);
        string = request.getJobLogger();
        if (string != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            string.setMessageFile(clazz.getName());
        }
        return map;
    }

    private DiscoverStep getStepCollectStorageMediaLocationsFrom3584ComputerSystem(TapeCIMProcessor tapeCIMProcessor, ProgressLogger progressLogger) {
        progressLogger.enableHierarchicalMode();
        DiscoverStep discoverStep = new DiscoverStep("collectChassisFromComputerSystem", "IN_SYSTEM_" + CHASSIS, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)progressLogger);
        DiscoverStep discoverStep2 = new DiscoverStep("collectStorageMediaLocationFromChassis", "IN_SYSTEM_" + STORAGEMEDIALOCATION, (CIMProcessor)tapeCIMProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(progressLogger));
        discoverStep.addNextStep((IStep)discoverStep2);
        return discoverStep;
    }
}

