/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AutomaticMirrorSelection
extends Task {
    public static final String ATTR_MIRROR = "mirror";
    public static final String ATTR_URL = "url";
    public static final String ATTR_LABEL = "label";
    private String mirrorUrl = null;
    private String property = null;

    public void execute() throws BuildException {
        try {
            Project project = this.getProject();
            project.log("Retrieving the mirror list: " + this.mirrorUrl, 4);
            URL uRL = new URL(this.mirrorUrl);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            project.log("Parsing the mirror list.", 4);
            DOMParser dOMParser = new DOMParser();
            InputSource inputSource = new InputSource(inputStream);
            dOMParser.parse(inputSource);
            Document document = dOMParser.getDocument();
            NodeList nodeList = document.getElementsByTagName(ATTR_MIRROR);
            project.log("Selecting a mirror.", 4);
            int n = 0;
            while (n < nodeList.getLength()) {
                block5: {
                    String string = "";
                    try {
                        string = nodeList.item(n).getAttributes().getNamedItem(ATTR_URL).getNodeValue();
                        URL uRL2 = new URL(string);
                        URLConnection uRLConnection2 = uRL2.openConnection();
                        if (uRLConnection2 == null) break block5;
                        StringBuffer stringBuffer = new StringBuffer("text");
                        String string2 = uRLConnection2.getContentType();
                        if (string2 == null || string2.contains(stringBuffer)) break block5;
                        project.setProperty(this.property, string);
                        break;
                    }
                    catch (IOException iOException) {
                        project.log("Skipping mirror " + string, (Throwable)iOException, 4);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public void setMirrorUrl(String string) {
        this.mirrorUrl = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }
}

