/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;

public class RunAndRenderTask
extends EngineTask
implements IRunAndRenderTask {
    protected String emitterID;
    protected IReportLayoutEngine layoutEngine;

    public RunAndRenderTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable);
    }

    private IContentEmitter createContentEmitter() throws EngineException {
        String format = this.executionContext.getOutputFormat();
        ExtensionManager extManager = ExtensionManager.getInstance();
        boolean supported = false;
        Collection supportedFormats = extManager.getSupportedFormat();
        Iterator iter = supportedFormats.iterator();
        while (iter.hasNext()) {
            String supportedFormat = (String)iter.next();
            if (supportedFormat == null || !supportedFormat.equalsIgnoreCase(format)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            log.log(Level.SEVERE, "Error.OutputFormatNotSupported", format);
            throw new UnsupportedFormatException("Error.OutputFormatNotSupported", format);
        }
        IContentEmitter emitter = null;
        try {
            emitter = extManager.createEmitter(format, this.emitterID);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance", t);
        }
        if (emitter == null) {
            log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance");
        }
        return emitter;
    }

    private void initializeContentEmitter(IContentEmitter emitter, ReportExecutor executor) {
        EngineEmitterServices services = new EngineEmitterServices(this);
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            services.setEmitterConfig(config.getEmitterConfigs());
        }
        services.setRenderOption(this.renderOptions);
        services.setExecutor(executor);
        services.setRenderContext(this.appContext);
        services.setReportRunnable(this.runnable);
        emitter.initialize(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws EngineException {
        try {
            this.runningStatus = 1;
            this.doRun();
        }
        finally {
            this.runningStatus = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws EngineException {
        if (!this.validateParameters()) {
            throw new EngineException("Error.InvalidParameter");
        }
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.startRender();
        try {
            Object htmlOption;
            IContentEmitter emitter = this.createContentEmitter();
            Report reportDesign = this.executionContext.getReport();
            ReportExecutor executor = new ReportExecutor(this.executionContext, reportDesign, null);
            LocalizedReportExecutor lExecutor = new LocalizedReportExecutor(this.executionContext, executor);
            this.executionContext.setExecutor(executor);
            this.initializeContentEmitter(emitter, executor);
            String format = this.executionContext.getOutputFormat();
            boolean paginate = true;
            if ("html".equalsIgnoreCase(format) && this.renderOptions instanceof HTMLRenderOption) {
                htmlOption = (HTMLRenderOption)this.renderOptions;
                paginate = ((HTMLRenderOption)htmlOption).getHtmlPagination();
            }
            htmlOption = this;
            synchronized (htmlOption) {
                if (!this.executionContext.isCanceled()) {
                    this.layoutEngine = this.createReportLayoutEngine(emitter.getOutputFormat(), this.renderOptions);
                }
            }
            if (this.layoutEngine != null) {
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                this.layoutEngine.setPageHandler(handle);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                this.layoutEngine.layout(lExecutor, outputEmitters, paginate);
            }
            this.closeRender();
            this.closeFactory();
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error happened while running the report", ex);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error happened while running the report.", t);
            new EngineException("Error happened while running the report", t);
        }
    }

    public void setEmitterID(String id) {
        this.emitterID = id;
    }

    public void cancel() {
        super.cancel();
        if (this.layoutEngine != null) {
            this.layoutEngine.cancel();
        }
    }
}

