/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.AbstractElement;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class AbstractContent
extends AbstractElement
implements IContent {
    protected transient IReportContent report;
    protected transient CSSEngine cssEngine;
    protected String name;
    protected DimensionType x;
    protected DimensionType y;
    protected DimensionType width;
    protected DimensionType height;
    protected IHyperlinkAction hyperlink;
    protected String bookmark;
    protected String helpText;
    protected transient String styleClass;
    protected IStyle inlineStyle;
    protected transient IStyle style;
    protected transient IStyle computedStyle;
    protected transient Object generateBy;
    protected InstanceID instanceId;
    protected Object toc;
    protected transient long offset = -1L;
    protected transient IContent lastChild = null;
    protected transient int version = -1;
    protected static final int LAST_EXTENSION = 2;
    protected Object[] extensions;
    protected static final int VERSION_0 = 0;
    protected static final int VERSION_1 = 1;
    static final short FIELD_NONE = -1;
    static final short FIELD_NAME = 0;
    static final short FIELD_X = 1;
    static final short FIELD_Y = 2;
    static final short FIELD_WIDTH = 3;
    static final short FIELD_HEIGHT = 4;
    static final short FIELD_HYPERLINK = 5;
    static final short FIELD_BOOKMARK = 6;
    static final short FIELD_HELPTEXT = 7;
    static final short FIELD_INLINESTYLE = 8;
    static final short FIELD_INSTANCE_ID = 9;
    static final short FIELD_TOC = 10;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractContent(IReportContent report) {
        this.report = report;
        this.parent = report.getRoot();
        this.cssEngine = report.getCSSEngine();
    }

    public void setReportContent(IReportContent report) {
        this.report = report;
        this.cssEngine = report.getCSSEngine();
    }

    public AbstractContent(IContent content) {
        this(content.getReportContent());
        this.name = content.getName();
        this.x = content.getX();
        this.y = content.getY();
        this.width = content.getWidth();
        this.height = content.getHeight();
        this.hyperlink = content.getHyperlinkAction();
        this.bookmark = content.getBookmark();
        this.helpText = content.getHelpText();
        this.inlineStyle = content.getInlineStyle();
        this.generateBy = content.getGenerateBy();
        this.styleClass = content.getStyleClass();
        this.instanceId = content.getInstanceID();
        this.toc = content.getTOC();
        Object ext = content.getExtension(0);
        if (ext != null) {
            this.setExtension(0, ext);
        }
    }

    public IReportContent getReportContent() {
        return this.report;
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public String getName() {
        return this.name;
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitContent(this, value);
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public IHyperlinkAction getHyperlinkAction() {
        return this.hyperlink;
    }

    public DimensionType getHeight() {
        if (this.height != null) {
            return this.height;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getHeight();
        }
        return null;
    }

    public DimensionType getWidth() {
        if (this.width != null) {
            return this.width;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getWidth();
        }
        return null;
    }

    public DimensionType getX() {
        if (this.x != null) {
            return this.x;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getX();
        }
        return null;
    }

    public DimensionType getY() {
        if (this.y != null) {
            return this.y;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getY();
        }
        return null;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public IStyle getComputedStyle() {
        if (this.computedStyle == null) {
            CSSEngine cssEngine = null;
            if (this.report != null) {
                cssEngine = this.report.getCSSEngine();
            }
            if (cssEngine == null) {
                cssEngine = new BIRTCSSEngine();
            }
            this.computedStyle = new ComputedStyle(this);
        }
        return this.computedStyle;
    }

    public IStyle getStyle() {
        if (this.style == null) {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.report.createStyle();
            }
            String styleClass = this.getStyleClass();
            IStyle classStyle = this.report.findStyle(styleClass);
            this.style = new CompositeStyle(classStyle, this.inlineStyle);
        }
        return this.style;
    }

    public Object getGenerateBy() {
        return this.generateBy;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public void setGenerateBy(Object generateBy) {
        this.generateBy = generateBy;
    }

    public void setHeight(DimensionType height) {
        this.height = height;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setHyperlinkAction(IHyperlinkAction hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStyleClass(String name) {
        this.styleClass = name;
        this.style = null;
        this.computedStyle = null;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        if (this.generateBy instanceof ReportItemDesign) {
            return ((ReportItemDesign)this.generateBy).getStyleName();
        }
        return null;
    }

    public void setInlineStyle(IStyle style) {
        this.inlineStyle = style;
        this.style = null;
        this.computedStyle = null;
    }

    public IStyle getInlineStyle() {
        return this.inlineStyle;
    }

    public void setWidth(DimensionType width) {
        this.width = width;
    }

    public void setX(DimensionType x) {
        this.x = x;
    }

    public void setY(DimensionType y) {
        this.y = y;
    }

    public InstanceID getInstanceID() {
        return this.instanceId;
    }

    public void setInstanceID(InstanceID id) {
        this.instanceId = id;
    }

    public void setTOC(Object toc) {
        this.toc = toc;
    }

    public Object getTOC() {
        return this.toc;
    }

    public Object getExtension(int extension) {
        if (this.extensions != null) {
            if (!$assertionsDisabled && extension >= 2) {
                throw new AssertionError();
            }
            return this.extensions[extension];
        }
        return null;
    }

    public void setExtension(int extension, Object value) {
        if (!$assertionsDisabled && extension >= 2) {
            throw new AssertionError();
        }
        if (this.extensions == null) {
            this.extensions = new Object[2];
        }
        this.extensions[extension] = value;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        String cssText;
        if (this.name != null) {
            IOUtil.writeShort((OutputStream)out, (short)0);
            IOUtil.writeString((DataOutputStream)out, (String)this.name);
        }
        if (this.x != null) {
            IOUtil.writeShort((OutputStream)out, (short)1);
            this.x.writeObject(out);
        }
        if (this.y != null) {
            IOUtil.writeShort((OutputStream)out, (short)2);
            this.y.writeObject(out);
        }
        if (this.width != null) {
            IOUtil.writeShort((OutputStream)out, (short)3);
            this.width.writeObject(out);
        }
        if (this.height != null) {
            IOUtil.writeShort((OutputStream)out, (short)4);
            this.height.writeObject(out);
        }
        if (this.hyperlink != null) {
            IOUtil.writeShort((OutputStream)out, (short)5);
            ((ActionContent)this.hyperlink).writeObject(out);
        }
        if (this.bookmark != null) {
            IOUtil.writeShort((OutputStream)out, (short)6);
            IOUtil.writeString((DataOutputStream)out, (String)this.bookmark);
        }
        if (this.helpText != null) {
            IOUtil.writeShort((OutputStream)out, (short)7);
            IOUtil.writeString((DataOutputStream)out, (String)this.helpText);
        }
        if (this.inlineStyle != null && (cssText = this.inlineStyle.getCssText()) != null && cssText.length() != 0) {
            IOUtil.writeShort((OutputStream)out, (short)8);
            IOUtil.writeString((DataOutputStream)out, (String)cssText);
        }
        if (this.instanceId != null) {
            IOUtil.writeShort((OutputStream)out, (short)9);
            IOUtil.writeString((DataOutputStream)out, (String)this.instanceId.toString());
        }
        if (this.toc != null) {
            IOUtil.writeShort((OutputStream)out, (short)10);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.toc);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 0: {
                this.name = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 1: {
                this.x = new DimensionType();
                this.x.readObject(in);
                break;
            }
            case 2: {
                this.y = new DimensionType();
                this.y.readObject(in);
                break;
            }
            case 3: {
                this.width = new DimensionType();
                this.width.readObject(in);
                break;
            }
            case 4: {
                this.height = new DimensionType();
                this.height.readObject(in);
                break;
            }
            case 5: {
                ActionContent action = new ActionContent();
                action.readObject(in);
                this.hyperlink = action;
                break;
            }
            case 6: {
                this.bookmark = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 7: {
                this.helpText = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 8: {
                String style = IOUtil.readString((DataInputStream)in);
                if (style == null || style.length() == 0) break;
                this.inlineStyle = new StyleDeclaration(this.cssEngine);
                this.inlineStyle.setCssText(style);
                break;
            }
            case 9: {
                String value = IOUtil.readString((DataInputStream)in);
                this.instanceId = InstanceID.parse(value);
                break;
            }
            case 10: {
                this.toc = IOUtil.readObject((DataInputStream)in);
            }
        }
    }

    public void readContent(DataInputStream in) throws IOException {
        if (this.version == 1) {
            this.readContentV1(in);
        } else if (this.version == 0) {
            this.readContentV0(in);
        } else {
            throw new IOException("Unknown content version " + this.version);
        }
    }

    protected void readContentV0(DataInputStream in) throws IOException {
        int version = IOUtil.readInt((InputStream)in);
        int filedId = IOUtil.readInt((InputStream)in);
        while (filedId != -1) {
            this.readField(0, filedId, in);
            filedId = IOUtil.readInt((InputStream)in);
        }
    }

    protected void readContentV1(DataInputStream in) throws IOException {
        while (in.available() > 0) {
            short filedId = IOUtil.readShort((InputStream)in);
            this.readField(1, filedId, in);
        }
    }

    public void writeContent(DataOutputStream out) throws IOException {
        this.writeFields(out);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static {
        $assertionsDisabled = !AbstractContent.class.desiredAssertionStatus();
    }
}

