/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataInteractiveEngine
extends AbstractDataEngine {
    private IDocArchiveReader reader;
    private IDocArchiveWriter writer;
    private DataOutputStream dos;
    protected HashMap rsetRelations = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DataInteractiveEngine(ExecutionContext context, IDocArchiveReader reader, IDocArchiveWriter writer) {
        super(context);
        try {
            DataEngineContext dteContext = writer == null ? DataEngineContext.newInstance((int)2, (Scriptable)context.getSharedScope(), (IDocArchiveReader)reader, null) : DataEngineContext.newInstance((int)4, (Scriptable)context.getSharedScope(), (IDocArchiveReader)reader, (IDocArchiveWriter)writer);
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteContext.setTmpdir(tempDir);
            }
            dteContext.setLocale(context.getLocale());
            this.dteEngine = DataEngine.newDataEngine((DataEngineContext)dteContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
            ex.printStackTrace();
        }
        this.reader = reader;
        this.writer = writer;
    }

    private void storeDteMetaInfo(String pRsetId, long rowId, String queryId, String rsetId) {
        if (this.writer == null) {
            return;
        }
        try {
            if (this.dos == null) {
                this.dos = new DataOutputStream((OutputStream)this.writer.createRandomAccessStream("/Data/snap_hierarchy"));
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
        }
        if (null != this.dos) {
            try {
                IOUtil.writeString((DataOutputStream)this.dos, (String)pRsetId);
                IOUtil.writeLong((DataOutputStream)this.dos, (long)rowId);
                IOUtil.writeString((DataOutputStream)this.dos, (String)queryId);
                IOUtil.writeString((DataOutputStream)this.dos, (String)rsetId);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void loadDteMetaInfo() {
        this.loadDteMetaInfo("/Data/hierarchy");
        if (this.reader.exists("/Data/snap_hierarchy")) {
            this.loadDteMetaInfo("/Data/snap_hierarchy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDteMetaInfo(String metaDataStream) {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream((InputStream)this.reader.getStream(metaDataStream));
                StringBuffer buffer = new StringBuffer();
                while (true) {
                    String pRsetId = IOUtil.readString((DataInputStream)dis);
                    long rowId = IOUtil.readLong((DataInputStream)dis);
                    String queryId = IOUtil.readString((DataInputStream)dis);
                    String rsetId = IOUtil.readString((DataInputStream)dis);
                    buffer.setLength(0);
                    buffer.append(pRsetId);
                    buffer.append(".");
                    buffer.append(rowId);
                    buffer.append(".");
                    buffer.append(queryId);
                    this.rsetRelations.put(buffer.toString(), rsetId);
                }
            }
            catch (EOFException eofe) {
                Object var10_10 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (IOException ioe) {
                this.context.addException(new EngineException("Can't load the data in report document", ioe));
                logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                Object var10_11 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    protected String getResultID(String pRsetId, long rowId, String queryId) {
        int charAt;
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        if (rsetId == null && pRsetId != null && (charAt = pRsetId.indexOf("_")) != -1) {
            String rootId = pRsetId.substring(0, charAt);
            this.keyBuffer.setLength(0);
            this.keyBuffer.append(rootId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(rowId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(queryId);
            rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        }
        return rsetId;
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        this.loadDteMetaInfo();
    }

    protected IResultSet doExecuteQuery(DteResultSet parentResult, IQueryDefinition query) {
        String queryID = (String)this.queryIDMap.get(query);
        try {
            IQueryResults dteResults;
            IQueryResults parentQueryResults = null;
            if (parentResult != null) {
                parentQueryResults = parentResult.getQueryResults();
            }
            String resultSetID = null;
            if (parentQueryResults == null) {
                resultSetID = this.getResultID(null, -1L, queryID);
            } else {
                String pRsetId = parentResult.getBaseRSetID();
                long rowid = parentResult.getRawID();
                resultSetID = this.getResultID(pRsetId, rowid, queryID);
            }
            if (resultSetID == null) {
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            ((QueryDefinition)query).setQueryResultsID(resultSetID);
            IPreparedQuery pQuery = this.dteEngine.prepare(query);
            Scriptable scope = this.context.getSharedScope();
            String pRsetId = null;
            long rowId = -1L;
            DteResultSet resultSet = null;
            if (parentQueryResults == null) {
                dteResults = pQuery.execute(scope);
                resultSet = new DteResultSet(this, this.context, query, dteResults);
            } else {
                pRsetId = parentResult.getQueryResults().getID();
                rowId = parentResult.getRawID();
                dteResults = pQuery.execute(parentQueryResults, scope);
                resultSet = new DteResultSet(parentResult, query, dteResults);
            }
            resultSet.setBaseRSetID(resultSetID);
            this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    public void shutdown() {
        if (null != this.dos) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dos = null;
        }
        this.dteEngine.shutdown();
    }
}

