/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLWriter {
    protected static Logger log;
    protected PrintWriter printWriter;
    protected String encoding = "UTF-8";
    protected int indentCount;
    protected boolean bPairedFlag = true;
    protected boolean bText = false;
    protected boolean bIndent = true;
    protected boolean bImplicitCloseTag = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void open(OutputStream outputStream, String encoding) {
        if (!$assertionsDisabled && encoding == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        this.encoding = encoding;
        try {
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, encoding), false);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "the character encoding {0} unsupported !", encoding);
        }
    }

    public void open(OutputStream outputStream) {
        this.open(outputStream, "UTF-8");
    }

    public void close() {
        this.printWriter.close();
    }

    public void startWriter() {
        this.printWriter.print("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
    }

    public void endWriter() {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            if (this.bIndent) {
                this.printWriter.println();
            }
        }
        this.printWriter.flush();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void openTag(String tagName) {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
        }
        if (this.bIndent) {
            this.printWriter.println();
            this.printWriter.print(this.indent());
        }
        this.bPairedFlag = false;
        this.printWriter.print('<' + tagName);
        ++this.indentCount;
        this.bText = false;
    }

    public void closeTag(String tagName) {
        --this.indentCount;
        if (!this.bPairedFlag) {
            if (this.bImplicitCloseTag) {
                this.printWriter.print("/>");
            } else {
                this.printWriter.print("></" + tagName + '>');
            }
        } else {
            if (this.bIndent && !this.bText) {
                this.printWriter.println();
                this.printWriter.print(this.indent());
            }
            this.printWriter.print("</" + tagName + '>');
        }
        this.bPairedFlag = true;
        this.bText = false;
    }

    public void attribute(String attrName, String attrValue) {
        if (attrValue != null && attrValue.length() > 0) {
            this.printWriter.print(' ');
            this.printWriter.print(attrName);
            this.printWriter.print("=\"");
            this.printWriter.print(this.escapeAttrValue(attrValue));
            this.printWriter.print('\"');
        }
    }

    public void attributeAllowEmpty(String attrName, String attrValue) {
        if (attrValue != null) {
            this.printWriter.print(' ');
            this.printWriter.print(attrName);
            this.printWriter.print("=\"");
            this.printWriter.print(this.escapeAttrValue(attrValue));
            this.printWriter.print('\"');
        }
    }

    public void attribute(String attrName, Object attrValue) {
        if (attrValue != null && attrValue.toString().length() > 0) {
            this.printWriter.print(' ');
            this.printWriter.print(attrName);
            this.printWriter.print("=\"");
            this.printWriter.print(this.escapeAttrValue(attrValue.toString()));
            this.printWriter.print('\"');
        }
    }

    public void attribute(String attrName, float attrValue) {
        this.printWriter.print(' ' + attrName + "=\"" + Float.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, double attrValue) {
        this.printWriter.print(' ' + attrName + "=\"" + Double.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, int attrValue) {
        this.printWriter.print(' ' + attrName + "=\"" + Integer.toString(attrValue) + '\"');
    }

    public void text(String value) {
        this.text(value, true);
    }

    public void text(String value, boolean whitespace) {
        this.text(value, whitespace, true);
    }

    public void text(String value, boolean whitespace, boolean escapeString) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = escapeString ? this.getEscapedStr(value, whitespace) : value;
        this.printWriter.print(stringToPrint);
        this.bText = true;
    }

    public void literal(String value) {
        this.printWriter.print(value);
    }

    protected String indent() {
        if (!this.bIndent) {
            return "";
        }
        StringBuffer indentContent = new StringBuffer(64);
        for (int i = 0; i < this.indentCount; ++i) {
            indentContent.append('\t');
        }
        return indentContent.toString();
    }

    protected String getEscapedStr(String s, boolean whitespace) {
        StringBuffer result = null;
        int spacePos = 1;
        char[] s2char = s.toCharArray();
        int max = s2char.length;
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s2char[i];
            String replacement = null;
            if (whitespace && c == ' ') {
                if (spacePos % 2 == 1 || i == max - 1) {
                    replacement = "&#160;";
                }
                ++spacePos;
            } else {
                spacePos = 0;
            }
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
                log.log(Level.WARNING, "Ignore the illegal XML character: 0x{0};", Integer.toHexString(c));
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\t') {
                replacement = " ";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    protected String escapeAttrValue(String s) {
        StringBuffer result = null;
        char[] s2char = s.toCharArray();
        int max = s2char.length;
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s2char[i];
            String replacement = null;
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
                log.log(Level.WARNING, "Ignore the illegal XML character: 0x{0};", Integer.toHexString(c));
            }
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public boolean isIndent() {
        return this.bIndent;
    }

    public void setIndent(boolean indent) {
        this.bIndent = indent;
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
        log = Logger.getLogger(XMLWriter.class.getName());
    }
}

