/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;

public class AutoTextItemExecutor
extends StyledItemExecutor {
    public AutoTextItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        AutoTextItemDesign textDesign = (AutoTextItemDesign)this.getDesign();
        IAutoTextContent textContent = this.report.createAutoTextContent();
        this.setContent(textContent);
        this.restoreResultSet();
        this.initializeContent(textDesign, textContent);
        this.processStyle(this.design, this.content);
        this.processVisibility(this.design, this.content);
        String type = ((AutoTextItemDesign)this.design).getType();
        if ("page-number".equalsIgnoreCase(type)) {
            textContent.setType(1);
            textContent.setText(String.valueOf(this.context.getPageNumber()));
        } else if ("total-page".equalsIgnoreCase(type)) {
            textContent.setType(0);
            long totalPage = this.context.getTotalPage();
            if (totalPage <= 0L) {
                textContent.setText("---");
            } else {
                textContent.setText(String.valueOf(this.context.getTotalPage()));
            }
        }
        if (this.emitter != null) {
            this.emitter.startAutoText(textContent);
        }
        return textContent;
    }

    public void close() {
        this.manager.releaseExecutor(10, this);
    }
}

