/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.executor.TableItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.w3c.dom.css.CSSValue;

public class TableBandExecutor
extends StyledItemExecutor {
    int currentRow;
    TableItemExecutor tableExecutor;

    protected TableBandExecutor(ExecutorManager manager) {
        super(manager);
    }

    protected DataID getDataID() {
        IResultSet curRset = this.getResultSet();
        if (curRset == null) {
            curRset = this.getParentResultSet();
        }
        if (curRset != null) {
            DataSetID dataSetID = curRset.getID();
            long position = curRset.getCurrentPosition();
            return new DataID(dataSetID, position);
        }
        return null;
    }

    public IContent execute() {
        CSSValue pageBreak;
        IStyle style;
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        ITableBandContent bandContent = this.report.createTableBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.initializeContent(bandDesign, bandContent);
        int type = bandDesign.getBandType();
        if ((type == 0 || type == 3) && this.tableExecutor.needSoftBreakBefore() && (style = this.content.getStyle()) != null && ((pageBreak = style.getProperty(46)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
            style.setProperty(46, IStyle.SOFT_VALUE);
            this.tableExecutor.clearSoftBreak();
        }
        this.startTOCEntry(bandContent);
        if (this.emitter != null) {
            this.emitter.startTableBand(bandContent);
        }
        this.currentRow = 0;
        return this.content;
    }

    public void close() {
        ITableBandContent bandContent = (ITableBandContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endTableBand(bandContent);
        }
        this.finishTOCEntry();
        this.manager.releaseExecutor(12, this);
    }

    public boolean hasNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        return this.currentRow < bandDesign.getRowCount();
    }

    public IReportItemExecutor getNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        if (this.currentRow < bandDesign.getRowCount()) {
            RowDesign rowDesign = bandDesign.getRow(this.currentRow++);
            RowExecutor rowExecutor = (RowExecutor)this.manager.createExecutor(this, rowDesign);
            rowExecutor.setRowId(this.tableExecutor.rowId++);
            return rowExecutor;
        }
        return null;
    }

    void setTableExecutor(TableItemExecutor tableExecutor) {
        this.tableExecutor = tableExecutor;
    }
}

