/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.buffermgr;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;

public class TableContentLayout {
    Row[] rows;
    int rowCount;
    int colCount;
    int realColCount;
    int rowBufferSize;
    int colBufferSize;
    int startRowID = 0;
    int currentRowID = 0;
    int hiddenRowCount = 0;
    Object currentRow;
    String format;
    ArrayList hiddenList = new ArrayList();
    protected Row unresolvedRow = null;
    boolean isRowHidden;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableContentLayout(ITableContent tableContent, String format) {
        this.format = format;
        this.colCount = tableContent.getColumnCount();
        for (int i = 0; i < this.colCount; ++i) {
            IColumn column = tableContent.getColumn(i);
            if (!this.isColumnHidden(column)) continue;
            this.hiddenList.add(new Integer(i));
        }
        this.realColCount = this.colCount - this.hiddenList.size();
    }

    public void reset() {
        this.fillEmptyCells(0, 0, this.rowBufferSize, this.colBufferSize);
        this.rowCount = 0;
        this.hiddenRowCount = 0;
        this.currentRowID = 0;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.realColCount;
    }

    public void createRow(Object rowContent) {
        if (!this.isSameWithLast(rowContent)) {
            ++this.currentRowID;
            this.currentRow = rowContent;
        }
        if (!this.isRowHidden(rowContent)) {
            this.isRowHidden = false;
            this.ensureSize(this.rowCount + 1, this.realColCount);
            Row row = this.rows[this.rowCount];
            row.rowId = this.currentRowID;
            row.content = rowContent;
            if (this.rowCount > 0) {
                Cell[] cells = row.cells;
                Cell[] lastCells = this.rows[this.rowCount - 1].cells;
                for (int cellId = 0; cellId < this.realColCount; ++cellId) {
                    Cell cell = lastCells[cellId];
                    if (cell.status == 2) {
                        cell = cell.getCell();
                    }
                    if (cell.status != 1) continue;
                    if (cell.rowSpan < 0 || cell.rowId + cell.rowSpan > this.currentRowID) {
                        cells[cellId] = Cell.createSpanCell(this.currentRowID, cellId, cell);
                        continue;
                    }
                    if (cell.rowId + cell.rowSpan != this.currentRowID) continue;
                    cell.rowSpan -= this.hiddenRowCount;
                }
            } else if (this.unresolvedRow != null && this.rowCount == 0) {
                Cell[] cells = row.cells;
                Cell[] lastCells = this.unresolvedRow.cells;
                for (int cellId = 0; cellId < this.realColCount; ++cellId) {
                    Cell cell = lastCells[cellId];
                    if (cell.status == 2) {
                        cell = cell.getCell();
                    }
                    if (cell.status != 1 || cell.rowId >= this.currentRowID || cell.rowSpan >= 0 && cell.rowId + cell.rowSpan <= this.currentRowID) continue;
                    ((Cell.Content)cell.getContent()).reset();
                    cells[cellId] = Cell.createCell(this.currentRowID, cell.getColId(), cell.getRowSpan(), cell.getColSpan(), (Cell.Content)cell.getContent());
                }
            }
            ++this.rowCount;
        } else {
            ++this.hiddenRowCount;
            this.isRowHidden = true;
        }
    }

    protected boolean isSameWithLast(Object rowContent) {
        return this.currentRow == rowContent;
    }

    public void createCell(int cellId, int rowSpan, int colSpan, Cell.Content content) {
        if (this.isRowHidden) {
            return;
        }
        int columnNumber = cellId;
        int columnSpan = colSpan;
        if (this.hiddenList.size() > 0) {
            for (int i = 0; i < this.hiddenList.size(); ++i) {
                int hCol = (Integer)this.hiddenList.get(i);
                if (hCol < cellId) {
                    --columnNumber;
                    continue;
                }
                if (hCol < cellId || hCol >= colSpan + cellId) continue;
                --columnSpan;
            }
        }
        if (columnSpan < 1) {
            return;
        }
        if (!$assertionsDisabled && columnNumber < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && columnNumber + columnSpan > this.realColCount) {
            throw new AssertionError();
        }
        this.ensureSize(this.rowCount, columnNumber + columnSpan);
        Cell cell = this.rows[this.rowCount - 1].cells[columnNumber];
        int status = cell.getStatus();
        if (status == 0) {
            Cell newCell = Cell.createCell(this.rows[this.rowCount - 1].rowId, columnNumber, rowSpan, columnSpan, content);
            Cell[] cells = this.rows[this.rowCount - 1].cells;
            this.rows[this.rowCount - 1].cells[columnNumber] = newCell;
            for (int i = columnNumber + 1; i < columnNumber + columnSpan; ++i) {
                cells[i] = Cell.createSpanCell(this.rows[this.rowCount - 1].rowId, i, newCell);
            }
        }
    }

    public void resolveDropCells() {
        if (this.rowCount <= 0) {
            return;
        }
        this.keepUnresolvedCells();
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        for (int cellId = 0; cellId < this.realColCount; ++cellId) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status != 1) continue;
            cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId - this.hiddenRowCount + 1;
        }
    }

    public void resolveDropCells(int bandId) {
        if (this.rowCount <= 0) {
            return;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        for (int cellId = 0; cellId < this.realColCount; ++cellId) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status != 1 || cell.rowSpan != bandId) continue;
            cell.rowSpan = this.rows[this.rowCount - 1].rowId - cell.rowId - this.hiddenRowCount + 1;
        }
    }

    public boolean hasDropCell() {
        if (this.rowCount <= 0) {
            return false;
        }
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        for (int cellId = 0; cellId < this.realColCount; ++cellId) {
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status != 1 || cell.rowSpan >= 0 && cell.rowSpan + cell.rowId <= this.rows[this.rowCount - 1].rowId + 1) continue;
            return true;
        }
        return false;
    }

    protected void ensureSize(int newRowBufferSize, int newColBufferSize) {
        if (newRowBufferSize > this.rowBufferSize) {
            Row[] newRows = new Row[newRowBufferSize];
            if (this.rows != null) {
                System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
            }
            for (int rowId = this.rowBufferSize; rowId < newRowBufferSize; ++rowId) {
                Row row = new Row(rowId);
                Cell[] cells = new Cell[this.colBufferSize];
                for (int colId = 0; colId < this.colBufferSize; ++colId) {
                    cells[colId] = Cell.EMPTY_CELL;
                }
                row.cells = cells;
                newRows[rowId] = row;
            }
            this.rows = newRows;
            this.rowBufferSize = newRowBufferSize;
        }
        if (newColBufferSize > this.colBufferSize) {
            for (int rowId = 0; rowId < this.rowBufferSize; ++rowId) {
                Row row = this.rows[rowId];
                Cell[] newCells = new Cell[newColBufferSize];
                if (row.cells != null) {
                    System.arraycopy(row.cells, 0, newCells, 0, this.colBufferSize);
                }
                for (int colId = this.colBufferSize; colId < newColBufferSize; ++colId) {
                    newCells[colId] = Cell.EMPTY_CELL;
                }
                row.cells = newCells;
            }
            this.colBufferSize = newColBufferSize;
        }
    }

    protected void fillEmptyCells(int rowId, int colId, int rowSize, int colSize) {
        int lastRowId = rowId + rowSize;
        int lastColId = colId + colSize;
        if (lastRowId > this.rowCount) {
            lastRowId = this.rowCount;
        }
        if (lastColId > this.colCount) {
            lastColId = this.colCount;
        }
        for (int i = rowId; i < lastRowId; ++i) {
            Cell[] cells = this.rows[i].cells;
            for (int j = colId; j < lastColId; ++j) {
                cells[j] = Cell.EMPTY_CELL;
            }
        }
    }

    protected void resizeCell(Cell cell, int newRowSpan, int newColSpan) {
        if (!$assertionsDisabled && cell.status != 1) {
            throw new AssertionError();
        }
        int rowId = cell.rowId;
        int colId = cell.colId;
        int rowSpan = cell.rowSpan;
        if (rowSpan <= 0) {
            rowSpan = this.rowCount - rowId;
        }
        int colSpan = cell.colSpan;
        if (!($assertionsDisabled || rowSpan >= newRowSpan && colSpan >= newColSpan)) {
            throw new AssertionError();
        }
        this.fillEmptyCells(rowId, colId + newColSpan, rowSpan, colSpan - newColSpan);
        this.fillEmptyCells(rowId + newRowSpan, colId, rowSpan - newRowSpan, newColSpan);
        cell.colSpan = newColSpan;
        cell.rowSpan = newRowSpan;
    }

    public Cell getCell(int rowIndex, int colIndex) {
        return this.rows[rowIndex].cells[colIndex];
    }

    public Row getRow(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.rowCount)) {
            throw new AssertionError();
        }
        return this.rows[index];
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf(this.format) >= 0 || formats.indexOf("all") >= 0);
    }

    public boolean isRowHidden(Object rowContent) {
        IStyle style;
        String formats;
        return rowContent != null && rowContent instanceof IRowContent && (formats = (style = ((IRowContent)rowContent).getStyle()).getVisibleFormat()) != null && (formats.indexOf(this.format) >= 0 || formats.indexOf("all") >= 0);
    }

    protected void keepUnresolvedCells() {
        if (this.rowCount <= 0) {
            return;
        }
        this.unresolvedRow = new Row(this.rows[this.rowCount - 1].rowId);
        Cell[] newcells = new Cell[this.realColCount];
        for (int colId = 0; colId < this.realColCount; ++colId) {
            newcells[colId] = Cell.EMPTY_CELL;
        }
        this.unresolvedRow.cells = newcells;
        Cell[] cells = this.rows[this.rowCount - 1].cells;
        for (int cellId = 0; cellId < this.realColCount; ++cellId) {
            Cell newCell;
            Cell cell = cells[cellId];
            if (cell.status == 2) {
                cell = cell.getCell();
            }
            if (cell.status != 1) continue;
            int colSpan = cell.getColSpan();
            this.unresolvedRow.cells[cellId] = newCell = Cell.createCell(cell.rowId, cellId, cell.getRowSpan(), colSpan, (Cell.Content)cell.getContent());
            int maxCol = cellId + colSpan;
            for (int i = cellId + 1; i < maxCol; ++i) {
                this.unresolvedRow.cells[i] = Cell.createSpanCell(cell.rowId, i, newCell);
            }
        }
    }

    public int getCurrentRowID() {
        return this.currentRowID - 1;
    }

    public boolean isVisible(ICellContent cell) {
        IElement parent = cell.getParent();
        if (parent instanceof IRowContent && this.isRowHidden((IRowContent)parent)) {
            return false;
        }
        IColumn column = cell.getColumnInstance();
        if (column == null) {
            return false;
        }
        return !this.isColumnHidden(column);
    }

    static {
        $assertionsDisabled = !TableContentLayout.class.desiredAssertionStatus();
    }
}

