/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFCellLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    protected IPDFTableLayoutManager tableLM;
    protected int columnWidth = 0;
    private ICellContent cellContent;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFCellLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        this.tableLM = this.getTableLayoutManager();
        this.cellContent = (ICellContent)content;
        this.tableLM.startCell(this.cellContent);
        int startColumn = this.cellContent.getColumn();
        int endColumn = startColumn + this.cellContent.getColSpan();
        this.columnWidth = this.tableLM.getCellWidth(startColumn, endColumn);
    }

    protected void createRoot() {
        if (!this.isFirst) {
            int startColumn = this.cellContent.getColumn();
            int endColumn = startColumn + this.cellContent.getColSpan();
            this.columnWidth = this.tableLM.getCellWidth(startColumn, endColumn);
        }
        this.root = AreaFactory.createCellArea(this.cellContent);
        this.root.setWidth(this.columnWidth);
        if (!this.isFirst) {
            IStyle areaStyle = this.root.getStyle();
            areaStyle.setProperty(15, IStyle.NUMBER_0);
            areaStyle.setProperty(53, IStyle.NUMBER_0);
        }
    }

    protected void newContext() {
        this.createRoot();
        IStyle areaStyle = this.root.getStyle();
        this.removeMargin(areaStyle);
        this.tableLM.resolveBorderConflict((CellArea)this.root);
        this.validateBoxProperty(this.root.getStyle(), this.columnWidth, this.context.getMaxHeight());
        this.setOffsetX(this.root.getContentX());
        this.setOffsetY(this.root.getContentY());
        this.setMaxAvaWidth(this.root.getContentWidth());
        this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        this.setMaxAvaHeight(this.root.getContentHeight());
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void closeLayout() {
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(this.root.getStyle().getProperty(55)));
    }

    protected boolean isHidden() {
        if (this.columnWidth == 0 || !this.tableLM.isCellVisible(this.cellContent)) {
            return true;
        }
        return super.isHidden();
    }

    protected boolean submitRoot(boolean childBreak) {
        if (this.parent != null) {
            this.parent.addArea(this.root);
        }
        return true;
    }

    protected boolean isRootEmpty() {
        return false;
    }

    public boolean isPageEmpty() {
        if (this.root != null && this.root.getChildrenCount() > 0) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isPageEmpty();
        }
        return true;
    }

    static {
        $assertionsDisabled = !PDFCellLM.class.desiredAssertionStatus();
    }
}

