/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableRegionLM;

public class PDFTableGroupLM
extends PDFGroupLM
implements IBlockStackingLayoutManager {
    protected PDFTableLM tableLM = null;
    protected boolean firstRow = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFTableGroupLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        IPDFTableLayoutManager lm = this.getTableLayoutManager();
        if (!$assertionsDisabled && !(lm instanceof PDFTableLM)) {
            throw new AssertionError();
        }
        this.tableLM = (PDFTableLM)lm;
        this.tableLM.startGroup((IGroupContent)content);
    }

    protected boolean traverseChildren() {
        boolean childBreak = super.traverseChildren();
        if (!childBreak) {
            this.tableLM.endGroup((IGroupContent)this.content);
        }
        return childBreak;
    }

    protected boolean checkAvailableSpace() {
        boolean availableSpace = super.checkAvailableSpace();
        if (availableSpace && this.tableLM != null) {
            this.tableLM.setTableCloseStateAsForced();
        }
        return availableSpace;
    }

    public boolean layout() {
        IPDFTableLayoutManager itsTableLM;
        boolean childBreak = super.layout();
        if (childBreak && (itsTableLM = this.getTableLayoutManager()) != null) {
            if (!this.isFinished() && this.needPageBreakBefore()) {
                itsTableLM.setTableCloseStateAsForced();
            } else if (this.isFinished() && this.needPageBreakAfter()) {
                itsTableLM.setTableCloseStateAsForced();
            }
        }
        return childBreak;
    }

    protected void repeatHeader() {
        IContent content;
        if (this.isFirst) {
            this.isFirst = false;
            return;
        }
        ITableBandContent header = (ITableBandContent)this.groupContent.getHeader();
        if (!this.isRepeatHeader() || header == null) {
            return;
        }
        if (header.getChildren().isEmpty()) {
            return;
        }
        if (this.child != null && (content = this.child.getContent()) instanceof ITableBandContent && ((ITableBandContent)content).getBandType() == 3) {
            return;
        }
        PDFReportLayoutEngine engine = this.context.getLayoutEngine();
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(engine);
        con.setFactory(new PDFLayoutManagerFactory(con));
        con.setFormat(this.context.getFormat());
        con.setReport(this.context.getReport());
        con.setMaxHeight(this.context.getMaxHeight());
        con.setAllowPageBreak(false);
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(header);
        headerExecutor.execute();
        PDFTableRegionLM regionLM = new PDFTableRegionLM(con, this.tableLM.getContent(), this.tableLM.getLayoutInfo());
        regionLM.initialize(header, this.tableLM.lastRowArea);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.tableLM.getContent().getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getMaxAvaHeight() - this.currentBP) {
            Iterator iter = tableRegion.getChildren();
            RowArea row = null;
            int count = 0;
            while (iter.hasNext()) {
                row = (RowArea)iter.next();
                this.addArea(row);
                ++count;
            }
            if (row != null) {
                this.removeBottomBorder(row);
            }
            this.tableLM.setRepeatCount(this.tableLM.getRepeatCount() + count);
        }
        this.tableLM.getContent().setExtension(1, null);
    }

    public int getCurrentBP() {
        return this.parent.getCurrentBP();
    }

    protected boolean submitRoot(boolean childBreak) {
        return true;
    }

    public int getCurrentIP() {
        return this.parent.getCurrentIP();
    }

    public int getMaxAvaHeight() {
        return this.parent.getMaxAvaHeight();
    }

    public int getMaxAvaWidth() {
        return this.parent.getMaxAvaWidth();
    }

    public int getOffsetX() {
        return this.parent.getOffsetX();
    }

    public int getOffsetY() {
        return this.parent.getOffsetY();
    }

    public void setCurrentBP(int bp) {
        this.parent.setCurrentBP(bp);
    }

    public void setCurrentIP(int ip) {
        this.parent.setCurrentIP(ip);
    }

    public void setMaxAvaHeight(int height) {
        this.parent.setMaxAvaHeight(height);
    }

    public void setMaxAvaWidth(int width) {
        this.parent.setMaxAvaWidth(width);
    }

    public void setOffsetX(int x) {
        this.parent.setOffsetX(x);
    }

    public void setOffsetY(int y) {
        this.parent.setOffsetY(y);
    }

    public boolean addArea(IArea area) {
        if (this.firstRow) {
            this.firstRow = false;
            IArea tocAnchor = AreaFactory.createTableGroupArea((IGroupContent)this.content);
            this.tableLM.addArea(tocAnchor);
            this.tableLM.setRepeatCount(this.tableLM.getRepeatCount() + 1);
        }
        return this.parent.addArea(area);
    }

    protected void createRoot() {
    }

    protected void newContext() {
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    static {
        $assertionsDisabled = !PDFTableGroupLM.class.desiredAssertionStatus();
    }
}

