/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLStyleProcessor;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTML2Content {
    protected static final HashMap tag2Style = new HashMap();
    protected static final HashSet htmlDisplayMode = new HashSet();
    protected static final HashSet supportedHTMLElementTags = new HashSet();
    protected static final HashMap textTypeMapping = new HashMap();
    protected ActionContent action = null;
    protected Stack inlineContainerStack = new Stack();
    protected ReportDesignHandle report;

    public HTML2Content(ReportDesignHandle report) {
        this.report = report;
    }

    public void html2Content(IForeignContent foreign) {
        this.processForeignData(foreign);
    }

    protected void processForeignData(IForeignContent foreign) {
        Node node;
        if (foreign.getChildren() != null && foreign.getChildren().size() > 0) {
            return;
        }
        HashMap styleMap = new HashMap();
        HTMLStyleProcessor htmlProcessor = new HTMLStyleProcessor(this.report);
        Object rawValue = foreign.getRawValue();
        Node doc = null;
        if (null != rawValue) {
            doc = new TextParser().parse(foreign.getRawValue().toString(), (String)textTypeMapping.get(foreign.getRawType()));
        }
        Element body = null;
        if (doc != null && (node = doc.getFirstChild()) instanceof Element) {
            body = (Element)node;
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            this.processNodes(body, this.checkEscapeSpace(doc), styleMap, foreign);
        }
    }

    private void processNodes(Element ele, boolean needEscape, HashMap cssStyles, IContent content) {
        int level = 0;
        for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeName().equals("value-of")) {
                if (!(node.getFirstChild() instanceof Element)) continue;
                this.processNodes((Element)node.getFirstChild(), this.checkEscapeSpace(node), cssStyles, content);
                continue;
            }
            if (node.getNodeName().equals("image")) {
                if (!(node.getFirstChild() instanceof Element)) continue;
                this.processNodes((Element)node.getFirstChild(), needEscape, cssStyles, content);
                continue;
            }
            if (node.getNodeType() == 3) {
                LabelContent label = new LabelContent((ReportContent)content.getReportContent());
                this.addChild(content, label);
                label.setText(node.getNodeValue());
                StyleDeclaration inlineStyle = new StyleDeclaration(content.getCSSEngine());
                inlineStyle.setProperty(33, CSSValueConstants.INLINE_VALUE);
                Node pNode = node.getParentNode();
                if (pNode != null) {
                    if ("u".equalsIgnoreCase(pNode.getNodeName()) || "ins".equalsIgnoreCase(pNode.getNodeName())) {
                        inlineStyle.setProperty(8, IStyle.UNDERLINE_VALUE);
                    } else if ("del".equalsIgnoreCase(pNode.getNodeName())) {
                        inlineStyle.setProperty(16, IStyle.LINE_THROUGH_VALUE);
                    } else if ("sub".equalsIgnoreCase(pNode.getNodeName())) {
                        inlineStyle.setProperty(30, IStyle.BOTTOM_VALUE);
                    } else if ("sup".equalsIgnoreCase(pNode.getNodeName())) {
                        inlineStyle.setProperty(30, IStyle.TOP_VALUE);
                    }
                }
                label.setInlineStyle(inlineStyle);
                if (this.action == null) continue;
                label.setHyperlinkAction(this.action);
                continue;
            }
            if (!supportedHTMLElementTags.contains(node.getNodeName().toUpperCase()) || node.getNodeType() != 1) continue;
            this.handleElement((Element)node, needEscape, cssStyles, content, ++level);
        }
    }

    private void handleElement(Element ele, boolean needEscape, HashMap cssStyles, IContent content, int index) {
        IStyle cssStyle = (IStyle)cssStyles.get(ele);
        if (cssStyle != null && "none".equals(cssStyle.getDisplay())) {
            return;
        }
        String tagName = ele.getTagName();
        if (tagName.toLowerCase().equals("a")) {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            container.setParent(content);
            this.handleStyle(ele, cssStyles, container);
            ActionContent oldAction = this.action;
            this.handleAnchor(ele, container);
            this.processNodes(ele, needEscape, cssStyles, container);
            this.action = oldAction;
        } else if (tagName.toLowerCase().equals("img")) {
            this.outputImg(ele, cssStyles, content);
        } else if (tagName.toLowerCase().equals("br")) {
            LabelContent label = new LabelContent((ReportContent)content.getReportContent());
            this.addChild(content, label);
            label.setText("\n");
            StyleDeclaration inlineStyle = new StyleDeclaration(content.getCSSEngine());
            inlineStyle.setProperty(33, CSSValueConstants.INLINE_VALUE);
            label.setInlineStyle(inlineStyle);
        } else if (tagName.toLowerCase().equals("li") && ele.getParentNode().getNodeType() == 1) {
            StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
            style.setProperty(33, CSSValueConstants.BLOCK_VALUE);
            style.setProperty(30, CSSValueConstants.MIDDLE_VALUE);
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            container.setInlineStyle(style);
            this.addChild(content, container);
            this.handleStyle(ele, cssStyles, container);
            TextContent text = new TextContent((ReportContent)content.getReportContent());
            this.addChild(container, text);
            if (ele.getParentNode().getNodeName().equals("ol")) {
                text.setText(new Integer(index).toString() + ".  ");
            } else if (ele.getParentNode().getNodeName().equals("ul")) {
                text.setText("  \u2022  ");
            }
            style = new StyleDeclaration(content.getCSSEngine());
            style.setProperty(33, CSSValueConstants.INLINE_VALUE);
            style.setProperty(30, CSSValueConstants.TOP_VALUE);
            text.setInlineStyle(style);
            ContainerContent childContainer = new ContainerContent((ReportContent)content.getReportContent());
            this.addChild(container, childContainer);
            childContainer.setInlineStyle(style);
            this.processNodes(ele, needEscape, cssStyles, childContainer);
        } else if (tagName.toLowerCase().equals("dd") || tagName.toLowerCase().equals("dt")) {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            this.addChild(content, container);
            this.handleStyle(ele, cssStyles, container);
            if (tagName.toLowerCase().equals("dd")) {
                StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
                style.setProperty(33, CSSValueConstants.INLINE_VALUE);
                style.setProperty(30, CSSValueConstants.TOP_VALUE);
                TextContent text = new TextContent((ReportContent)content.getReportContent());
                this.addChild(content, text);
                if (ele.getParentNode().getNodeName().equals("dl")) {
                    text.setText("");
                }
                style.setTextIndent("3em");
                text.setInlineStyle(style);
                ContainerContent childContainer = new ContainerContent((ReportContent)content.getReportContent());
                childContainer.setInlineStyle(style);
                this.addChild(container, childContainer);
                this.processNodes(ele, needEscape, cssStyles, container);
            } else {
                this.processNodes(ele, needEscape, cssStyles, container);
            }
        } else {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            this.handleStyle(ele, cssStyles, container);
            if (htmlDisplayMode.contains(ele.getTagName())) {
                this.addChild(content, container);
                this.processNodes(ele, needEscape, cssStyles, container);
            } else {
                if (this.inlineContainerStack.isEmpty()) {
                    container.setParent(content);
                } else {
                    container.setParent((IContent)this.inlineContainerStack.peek());
                }
                this.inlineContainerStack.push(container);
                this.processNodes(ele, needEscape, cssStyles, content);
                this.inlineContainerStack.pop();
            }
        }
    }

    private boolean checkEscapeSpace(Node doc) {
        String textType = null;
        if (doc != null && doc.getFirstChild() != null && doc.getFirstChild() instanceof Element) {
            textType = ((Element)doc.getFirstChild()).getAttribute("text-type");
            return !TextParser.TEXT_TYPE_HTML.equalsIgnoreCase(textType);
        }
        return true;
    }

    protected void handleAnchor(Element ele, IContent content) {
        String href;
        if (ele.getAttribute("id").trim().length() != 0) {
            content.setBookmark(ele.getAttribute("id"));
        } else {
            content.setBookmark(ele.getAttribute("name"));
        }
        if (ele.getAttribute("href").length() > 0 && null != (href = ele.getAttribute("href")) && !"".equals(href)) {
            ActionContent action = new ActionContent();
            if (href.startsWith("#")) {
                action.setBookmark(href.substring(1));
            } else {
                action.setHyperlink(href, ele.getAttribute("target"));
            }
            content.setHyperlinkAction(action);
            this.action = action;
        }
    }

    private void handleStyle(Element ele, HashMap cssStyles, IContent content) {
        StyleDeclaration tagStyle;
        String tagName = ele.getTagName();
        StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
        if ("font".equals(tagName)) {
            String attr = ele.getAttribute("size");
            if (null != attr && !"".equals(attr)) {
                style.setFontSize(attr);
            }
            if (null != (attr = ele.getAttribute("color")) && !"".equals(attr)) {
                style.setColor(attr);
            }
            if (null != (attr = ele.getAttribute("face")) && !"".equals(attr)) {
                style.setFontFamily(attr);
            }
        }
        if (htmlDisplayMode.contains(tagName)) {
            style.setDisplay("block");
        } else {
            style.setDisplay("inline");
        }
        IStyle inlineStyle = (IStyle)cssStyles.get(ele);
        if (inlineStyle != null) {
            style.setProperties(inlineStyle);
        }
        if (tag2Style.containsKey(ele.getTagName()) && (tagStyle = (StyleDeclaration)content.getCSSEngine().parseStyleDeclaration((String)tag2Style.get(ele.getTagName()))) != null) {
            style.setProperties(tagStyle);
        }
        content.setInlineStyle(style);
    }

    protected void outputImg(Element ele, HashMap cssStyles, IContent content) {
        String src = ele.getAttribute("src");
        if (src != null) {
            ImageContent image = new ImageContent(content);
            this.addChild(content, image);
            this.handleStyle(ele, cssStyles, image);
            if (!FileUtil.isLocalResource(src)) {
                image.setImageSource(3);
                image.setURI(src);
            } else {
                ReportDesignHandle handle = content.getReportContent().getDesign().getReportDesign();
                URL url = handle.findResource(src, 1);
                if (url != null) {
                    src = url.getFile();
                }
                image.setImageSource(0);
                image.setURI(src);
            }
            if (null != ele.getAttribute("width") && !"".equals(ele.getAttribute("width"))) {
                image.setWidth(DimensionType.parserUnit(ele.getAttribute("width")));
            }
            if (ele.getAttribute("height") != null && !"".equals(ele.getAttribute("height"))) {
                image.setWidth(DimensionType.parserUnit(ele.getAttribute("height")));
            }
            if (ele.getAttribute("alt") != null && !"".equals(ele.getAttribute("alt"))) {
                image.setAltText(ele.getAttribute("alt"));
            }
        }
    }

    protected void addChild(IContent parent, IContent child) {
        Collection children;
        if (parent != null && child != null && !(children = parent.getChildren()).contains(child)) {
            children.add(child);
            if (this.inlineContainerStack.isEmpty()) {
                child.setParent(parent);
            } else {
                child.setParent((IContent)this.inlineContainerStack.peek());
            }
        }
    }

    static {
        tag2Style.put("code", "font-family: monospace");
        tag2Style.put("em", "font-style: italic");
        tag2Style.put("h1", "font-size: 2em; margin-top: 0.67em; margin-bottom:0.67em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("h2", "font-size: 1.5em; margin-top: 0.75em; margin-bottom:0.75em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("h3", "font-size: 1.17em; margin-top: 0.83em; margin-bottom:0.83em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("h4", "font-size: 1.12em; margin-top: 1.12em; margin-bottom:1.12em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("h5", "font-size: 0.83em; margin-top: 1.5em; margin-bottom:1.5em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("h6", "font-size: 0.75em; margin-top: 1.67em; margin-bottom:1.67em; font-weight: bold; page-break-after: avoid");
        tag2Style.put("pre", "font-family: monospace; white-space: no-wrap; ");
        tag2Style.put("strong", "font-weight: bold");
        tag2Style.put("sub", "vertical-align: bottom; font-size: 75%");
        tag2Style.put("sup", "vertical-align: top; font-size: 75%");
        tag2Style.put("tt", "font-family: monospace;");
        tag2Style.put("center", "text-align: center;");
        tag2Style.put("i", "font-style: italic;");
        tag2Style.put("b", "font-weight: bold;");
        tag2Style.put("p", "margin-top: 1.33em; margin-bottom: 1.33em");
        tag2Style.put("u", "text-decoration: underline;");
        tag2Style.put("del", "text-decoration: line-through;");
        supportedHTMLElementTags.add("H1");
        supportedHTMLElementTags.add("H2");
        supportedHTMLElementTags.add("H3");
        supportedHTMLElementTags.add("H4");
        supportedHTMLElementTags.add("H5");
        supportedHTMLElementTags.add("H6");
        supportedHTMLElementTags.add("A");
        supportedHTMLElementTags.add("B");
        supportedHTMLElementTags.add("BODY");
        supportedHTMLElementTags.add("BR");
        supportedHTMLElementTags.add("CENTER");
        supportedHTMLElementTags.add("CODE");
        supportedHTMLElementTags.add("DD");
        supportedHTMLElementTags.add("DEL");
        supportedHTMLElementTags.add("DIV");
        supportedHTMLElementTags.add("DL");
        supportedHTMLElementTags.add("DT");
        supportedHTMLElementTags.add("FONT");
        supportedHTMLElementTags.add("EM");
        supportedHTMLElementTags.add("HEAD");
        supportedHTMLElementTags.add("HTML");
        supportedHTMLElementTags.add("I");
        supportedHTMLElementTags.add("IMAGE");
        supportedHTMLElementTags.add("IMG");
        supportedHTMLElementTags.add("INS");
        supportedHTMLElementTags.add("LI");
        supportedHTMLElementTags.add("OL");
        supportedHTMLElementTags.add("PRE");
        supportedHTMLElementTags.add("P");
        supportedHTMLElementTags.add("SPAN");
        supportedHTMLElementTags.add("STRONG");
        supportedHTMLElementTags.add("SUB");
        supportedHTMLElementTags.add("SUP");
        supportedHTMLElementTags.add("TITLE");
        supportedHTMLElementTags.add("UL");
        supportedHTMLElementTags.add("TT");
        supportedHTMLElementTags.add("U");
        htmlDisplayMode.add("dd");
        htmlDisplayMode.add("div");
        htmlDisplayMode.add("dl");
        htmlDisplayMode.add("dt");
        htmlDisplayMode.add("h1");
        htmlDisplayMode.add("h2");
        htmlDisplayMode.add("h3");
        htmlDisplayMode.add("h4");
        htmlDisplayMode.add("h5");
        htmlDisplayMode.add("h6");
        htmlDisplayMode.add("hr");
        htmlDisplayMode.add("ol");
        htmlDisplayMode.add("p");
        htmlDisplayMode.add("pre");
        htmlDisplayMode.add("ul");
        htmlDisplayMode.add("li");
        htmlDisplayMode.add("body");
        htmlDisplayMode.add("center");
        textTypeMapping.put("text/html", TextParser.TEXT_TYPE_HTML);
        textTypeMapping.put("text/plaintext", TextParser.TEXT_TYPE_PLAIN);
        textTypeMapping.put("binary/unknown", TextParser.TEXT_TYPE_AUTO);
    }
}

