/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IHideRule;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;

public class HideRuleImpl
implements IHideRule {
    private HideRuleHandle rule;
    private ReportItemHandle handle;

    public HideRuleImpl(HideRuleHandle rule, ReportItemHandle handle) {
        this.handle = handle;
        this.rule = rule;
    }

    public String getFormat() {
        return this.rule.getFormat();
    }

    public String getValueExpr() {
        return this.rule.getExpression();
    }

    public void setFormat(String format) throws ScriptException {
        this.checkHandle();
        try {
            this.rule.setFormat(format);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setValueExpr(String valueExpr) throws ScriptException {
        this.checkHandle();
        this.rule.setExpression(valueExpr);
    }

    private void checkHandle() throws ScriptException {
        if (this.rule != null) {
            return;
        }
        HideRule r = new HideRule();
        PropertyHandle propHandle = this.handle.getPropertyHandle("visibility");
        try {
            this.rule = (HideRuleHandle)propHandle.addItem((IStructure)r);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

