/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataBinding;
import org.eclipse.birt.report.engine.api.script.element.IHighLightRule;
import org.eclipse.birt.report.engine.api.script.element.IReportItem;
import org.eclipse.birt.report.engine.script.internal.element.DataBindingImpl;
import org.eclipse.birt.report.engine.script.internal.element.HighLightRuleImpl;
import org.eclipse.birt.report.engine.script.internal.element.ReportElement;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class ReportItem
extends ReportElement
implements IReportItem {
    public ReportItem(ReportItemHandle handle) {
        super((ReportElementHandle)handle);
    }

    public DataSetHandle getDataSet() {
        return ((ReportItemHandle)this.handle).getDataSet();
    }

    public void setDataSet(DataSetHandle dataSet) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setDataSet(dataSet);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getX() {
        DimensionHandle x = ((ReportItemHandle)this.handle).getX();
        return x == null ? null : x.getStringValue();
    }

    public String getY() {
        DimensionHandle y = ((ReportItemHandle)this.handle).getY();
        return y == null ? null : y.getStringValue();
    }

    public void setX(String dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setX(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setX(double dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setX(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setY(String dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setY(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setY(double dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setY(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setHeight(String dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setHeight(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setHeight(double dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setHeight(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setWidth(String dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setWidth(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setWidth(double dimension) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setWidth(dimension);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getWidth() {
        return ((ReportItemHandle)this.handle).getWidth().getDisplayValue();
    }

    public String getHeight() {
        return ((ReportItemHandle)this.handle).getHeight().getDisplayValue();
    }

    public String getBookmark() {
        return ((ReportItemHandle)this.handle).getBookmark();
    }

    public void setBookmark(String value) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setBookmark(value);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setTocExpression(String expression) throws ScriptException {
        try {
            ((ReportItemHandle)this.handle).setTocExpression(expression);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getTocExpression() {
        return ((ReportItemHandle)this.handle).getTocExpression();
    }

    public String getColumnBinding(String bindingName) {
        if (bindingName == null || bindingName.length() == 0) {
            return null;
        }
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!columnHandle.getName().equals(bindingName)) continue;
            return columnHandle.getExpression();
        }
        return null;
    }

    public IDataBinding[] getColumnBindings() {
        Iterator iterator = ((ReportItemHandle)this.handle).columnBindingsIterator();
        ArrayList<DataBindingImpl> rList = new ArrayList<DataBindingImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            DataBindingImpl d = new DataBindingImpl(columnHandle, (ReportItemHandle)this.handle);
            rList.add(d);
            ++count;
        }
        return rList.toArray(new IDataBinding[count]);
    }

    public IHighLightRule[] getHighLightRule() {
        PropertyHandle propHandle = ((ReportItemHandle)this.handle).getPropertyHandle("highlightRules");
        Iterator iterator = propHandle.iterator();
        ArrayList<HighLightRuleImpl> rList = new ArrayList<HighLightRuleImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            HighlightRuleHandle ruleHandle = (HighlightRuleHandle)iterator.next();
            HighLightRuleImpl h = new HighLightRuleImpl(ruleHandle, (ReportItemHandle)this.handle);
            rList.add(h);
            ++count;
        }
        return rList.toArray(new IHighLightRule[count]);
    }

    public void removeColumnBinding(String bindingName) throws ScriptException {
        if (bindingName == null || bindingName.length() == 0) {
            return;
        }
        PropertyHandle propHandle = ((ReportItemHandle)this.handle).getPropertyHandle("boundDataColumns");
        ArrayList<ComputedColumnHandle> structureList = new ArrayList<ComputedColumnHandle>();
        Iterator iterator = propHandle.iterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnHandle = (ComputedColumnHandle)iterator.next();
            if (!bindingName.equals(columnHandle.getName())) continue;
            structureList.add(columnHandle);
        }
        try {
            propHandle.removeItems(structureList);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String[] getHideRuleExpression(String formatType) {
        PropertyHandle propHandle = this.handle.getPropertyHandle("visibility");
        Iterator iterator = propHandle.iterator();
        ArrayList<String> rList = new ArrayList<String>();
        int count = 0;
        while (iterator.hasNext()) {
            HideRuleHandle ruleHandle = (HideRuleHandle)iterator.next();
            rList.add(ruleHandle.getFormat());
            ++count;
        }
        return rList.toArray(new String[count]);
    }

    public void removeHideRule(String formatType) throws ScriptException {
        if (formatType == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle("visibility");
        ArrayList<HideRuleHandle> structureList = new ArrayList<HideRuleHandle>();
        Iterator iterator = propHandle.iterator();
        while (iterator.hasNext()) {
            HideRuleHandle ruleHandle = (HideRuleHandle)iterator.next();
            if (!formatType.equals(ruleHandle.getFormat())) continue;
            structureList.add(ruleHandle);
        }
        try {
            propHandle.removeItems(structureList);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

