/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.toc.TOCTreeNode;

public class TOCTree
implements ITOCTree {
    private String format;
    private ULocale locale;
    TOCTreeNode root;
    private HashMap tocMapByID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TOCTree() {
    }

    public TOCTree(TOCTreeNode root, String format, ULocale locale) {
        this.root = root;
        this.format = format;
        if ("html".equalsIgnoreCase(this.format)) {
            this.format = "viewer";
        }
        this.locale = locale;
    }

    public TOCNode findTOC(String tocNodeId) {
        this.initialize();
        this.initializeLocale();
        if (this.root == null) {
            return null;
        }
        if (this.tocMapByID == null) {
            this.generateIndex();
        }
        TOCTreeNode treeNode = (TOCTreeNode)this.tocMapByID.get(tocNodeId);
        return this.refactNode(treeNode, this.format, this.locale);
    }

    public List findTOCByValue(Object tocValue) {
        if (tocValue == null) {
            return null;
        }
        this.initialize();
        this.initializeLocale();
        if (this.root == null) {
            return null;
        }
        List nodes = this.search(tocValue, this.locale);
        ArrayList<TOCNode> result = new ArrayList<TOCNode>();
        for (int i = 0; i < nodes.size(); ++i) {
            TOCTreeNode treeNode = (TOCTreeNode)nodes.get(i);
            TOCNode node = this.refactNode(treeNode, this.format, this.locale);
            if (node == null) continue;
            result.add(node);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public TOCTreeNode getTOCRoot() {
        this.initialize();
        return this.root;
    }

    public TOCNode getRoot() {
        return this.extractTOCNode(this.root, this.format, this.locale);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        if ("html".equalsIgnoreCase(this.format)) {
            this.format = "viewer";
        }
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void setLocale(ULocale locale) {
        this.locale = locale;
    }

    void setRoot(TOCTreeNode root) {
        this.root = root;
    }

    protected void initialize() {
        if (this.root == null) {
            this.root = new TOCTreeNode();
        }
    }

    private List search(Object tocValue, ULocale locale) {
        HashSet nodes = new HashSet();
        List keys = this.parse(tocValue, locale);
        this.search(nodes, keys, this.root);
        return Collections.list(Collections.enumeration(nodes));
    }

    private void search(Set result, List keys, TOCTreeNode rootNode) {
        for (int i = 0; i < keys.size(); ++i) {
            if (!this.equals(keys.get(i), rootNode.getTOCValue())) continue;
            result.add(rootNode);
        }
        List children = rootNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.search(result, keys, (TOCTreeNode)children.get(i));
        }
    }

    private boolean equals(Object searchKey, Object key) {
        if (!$assertionsDisabled && searchKey == null) {
            throw new AssertionError();
        }
        if (key == null) {
            return false;
        }
        if (searchKey instanceof String) {
            return searchKey.equals(key.toString());
        }
        if (searchKey instanceof Number && key instanceof Number) {
            BigDecimal decima2;
            BigDecimal searchDecimal = this.toBigDecimal((Number)searchKey);
            return searchDecimal.compareTo(decima2 = this.toBigDecimal((Number)key)) == 0;
        }
        return searchKey.equals(key);
    }

    private BigDecimal toBigDecimal(Number value) {
        BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        decimal = decimal.setScale(20);
        return decimal;
    }

    private TOCNode refactNode(TOCTreeNode node, String format, ULocale locale) {
        if (node == null || node.isHidden(format)) {
            return null;
        }
        if (this.isFirstChildOfDummyGroup(node, format)) {
            TOCTreeNode parent = (TOCTreeNode)node.getParent();
            return this.extractTOCNode(parent, format, locale);
        }
        return this.extractTOCNode(node, format, locale);
    }

    private boolean isFirstChildOfDummyGroup(TOCTreeNode node, String format) {
        TOCTreeNode parent = (TOCTreeNode)node.getParent();
        if (parent != null && this.shouldRemove(parent)) {
            List children = parent.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TOCTreeNode tmpNode = (TOCTreeNode)children.get(i);
                if (tmpNode == node) {
                    return true;
                }
                if (tmpNode.isHidden(format)) continue;
                return false;
            }
        }
        return false;
    }

    private void generateIndex() {
        this.tocMapByID = new HashMap();
        this.generateRootTOCIndex();
    }

    private TOCNode extractTOCNode(TOCTreeNode root, String format, ULocale locale) {
        if (root == null) {
            return null;
        }
        if (root.isHidden(format)) {
            return null;
        }
        TOCNode result = TOCTreeNode.copyLocalizedNode(root, locale);
        List children = root.getChildren();
        boolean start = true;
        for (int i = 0; i < children.size(); ++i) {
            TOCTreeNode child = (TOCTreeNode)children.get(i);
            TOCNode childResult = this.extractTOCNode(child, format, locale);
            if (childResult == null) continue;
            if (this.shouldRemove(root) && start) {
                childResult.setParent(result.getParent());
                result = childResult;
                start = false;
                continue;
            }
            childResult.setParent(result);
            result.getChildren().add(childResult);
        }
        if (this.shouldRemove(root) && start) {
            return null;
        }
        return result;
    }

    private void generateRootTOCIndex() {
        this.tocMapByID.put("/", this.root);
        this.generateTOCIndex(this.root);
    }

    private void generateTOCIndex(TOCTreeNode node) {
        this.tocMapByID.put(node.getNodeID(), node);
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            TOCTreeNode child = (TOCTreeNode)iter.next();
            this.generateTOCIndex(child);
        }
    }

    private boolean shouldRemove(TOCTreeNode node) {
        return node.isGroupRoot() && node.isBlank();
    }

    private void initializeLocale() {
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
    }

    private List parse(Object value, ULocale locale) {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(value);
        if (value instanceof String) {
            String stringValue = (String)value;
            Comparable<BigDecimal> parseValue = null;
            try {
                parseValue = new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (parseValue != null) {
                result.add(parseValue);
                parseValue = null;
            }
            DateFormatter formatter = new DateFormatter(locale);
            try {
                parseValue = formatter.parse(stringValue);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (parseValue != null) {
                result.add(parseValue);
            }
        } else {
            result.add(value.toString());
        }
        return result;
    }

    static {
        $assertionsDisabled = !TOCTree.class.desiredAssertionStatus();
    }
}

