/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.io.InvalidClassException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.disk.api.IDiskMonitorService;
import org.eclipse.aperi.disk.api.impl.DiskCliDispatcher;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.AffectedHostAnalyzer;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.disk.monitor.DiskExpiringEventQueue;
import org.eclipse.aperi.disk.monitor.DiskFilterThread;
import org.eclipse.aperi.disk.monitor.DiskIndicationHandlerFactory;
import org.eclipse.aperi.disk.monitor.DiskWorkerThread;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSTopicConnectionFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;

public class DiskMonitorService
implements IDiskMonitorService,
MessageListener,
ICliDispatcher {
    private static final long BUFFERQUEUEEXPIRATION = 60000L;
    private static final int BUFFERQUEUEDEPTH = 200;
    private DiskFilterThread cFilterThread = null;
    private DiskWorkerThread cWorkerThread = null;
    private DiskEventQueue cEntryQueue = null;
    private DiskExpiringEventQueue cCreationBufferQueue = null;
    private DiskExpiringEventQueue cDeletionBufferQueue = null;
    private DiskEventQueue cWorkerQueue = null;
    private Status cStatus = new Status(5, 6);
    private static Factory cFactory = null;
    private static TopicSubscriber cIndicationSubscriber = null;
    private MSTopicConnectionFactory cTopicConnector = null;

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "DiskMonitorService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("DiskMonitorService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("DiskMonitorService_Description");
    }

    public boolean startup() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"startup", null);
        boolean bl = true;
        try {
            logTraceHelper.traceInfo("setting install status to INSTALLED");
            this.cStatus.setInstallStatus(5);
            logTraceHelper.traceInfo("setting status to STARTING and RUNNING");
            this.cStatus.setRunStatus(9);
            this.cStatus.setRunStatus(8);
            logTraceHelper.traceInfo("creating entry, buffer and work queue");
            this.cEntryQueue = new DiskEventQueue();
            this.cCreationBufferQueue = new DiskExpiringEventQueue(200, 60000L);
            this.cDeletionBufferQueue = new DiskExpiringEventQueue(200, 60000L);
            this.cWorkerQueue = new DiskEventQueue();
            logTraceHelper.traceInfo("creating buffer thread");
            this.cFilterThread = new DiskFilterThread(this.cEntryQueue, this.cWorkerQueue, this.cCreationBufferQueue, this.cDeletionBufferQueue);
            logTraceHelper.traceInfo("creating worker thread");
            this.cWorkerThread = new DiskWorkerThread(this.cWorkerQueue);
            try {
                Class<?> clazz;
                Class<?> clazz2;
                Class<?> clazz3;
                Class<?> clazz4;
                Class<?> clazz5;
                Class<?> clazz6;
                Class<?> clazz7;
                Class<?> clazz8;
                Class<?> clazz9;
                Class<?> clazz10;
                Class<?> clazz11;
                Class<?> clazz12;
                Class<?> clazz13;
                Class<?> clazz14;
                Class<?> clazz15;
                Class<?> clazz16;
                Class<?> clazz17;
                Class<?> clazz18;
                Class<?> clazz19;
                Class<?> clazz20;
                Class<?> clazz21;
                Class<?> clazz22;
                try {
                    clazz22 = Class.forName("org.eclipse.aperi.disk.monitor.VolumeCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz22);
                try {
                    clazz21 = Class.forName("org.eclipse.aperi.disk.monitor.VolumeModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz21);
                try {
                    clazz20 = Class.forName("org.eclipse.aperi.disk.monitor.VolumeDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz20);
                try {
                    clazz19 = Class.forName("org.eclipse.aperi.disk.monitor.SubsystemCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz19);
                try {
                    clazz18 = Class.forName("org.eclipse.aperi.disk.monitor.SubsystemModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz18);
                try {
                    clazz17 = Class.forName("org.eclipse.aperi.disk.monitor.SubsystemDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz17);
                try {
                    clazz16 = Class.forName("org.eclipse.aperi.disk.monitor.ProtocolControllerForUnitIndicationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz16);
                try {
                    clazz15 = Class.forName("org.eclipse.aperi.disk.monitor.PoolCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz15);
                try {
                    clazz14 = Class.forName("org.eclipse.aperi.disk.monitor.PoolModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz14);
                try {
                    clazz13 = Class.forName("org.eclipse.aperi.disk.monitor.PoolDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz13);
                try {
                    clazz12 = Class.forName("org.eclipse.aperi.disk.monitor.FCPortCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz12);
                try {
                    clazz11 = Class.forName("org.eclipse.aperi.disk.monitor.FCPortModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz11);
                try {
                    clazz10 = Class.forName("org.eclipse.aperi.disk.monitor.FCPortDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz10);
                try {
                    clazz9 = Class.forName("org.eclipse.aperi.disk.monitor.ExtentCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz9);
                try {
                    clazz8 = Class.forName("org.eclipse.aperi.disk.monitor.ExtentModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz8);
                try {
                    clazz7 = Class.forName("org.eclipse.aperi.disk.monitor.ExtentDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz7);
                try {
                    clazz6 = Class.forName("org.eclipse.aperi.disk.monitor.ESSPhysicalPackageCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz6);
                try {
                    clazz5 = Class.forName("org.eclipse.aperi.disk.monitor.ESSPhysicalPackageModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz5);
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.disk.monitor.ESSPhysicalPackageDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz4);
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.disk.monitor.DiskDriveCreationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz3);
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.disk.monitor.DiskDriveModificationHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz2);
                try {
                    clazz = Class.forName("org.eclipse.aperi.disk.monitor.DiskDriveDeletionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                DiskIndicationHandlerFactory.getInstance().registerHandler(clazz);
            }
            catch (InvalidClassException invalidClassException) {
                logTraceHelper.traceError("registration for CIMIndicationHandler failed because of " + invalidClassException.getMessage(), (Throwable)invalidClassException);
                bl = false;
            }
            try {
                Class<?> clazz;
                logTraceHelper.traceInfo("creating factory");
                cFactory = FactoryFactory.createFactory((int)2, null);
                logTraceHelper.traceInfo("subscribing for CIMIndicationEvents on pub/sub using listener");
                try {
                    clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                cIndicationSubscriber = cFactory.createSubscriber(clazz.getName(), null, null, (MessageListener)this);
            }
            catch (Exception exception) {
                logTraceHelper.traceError("subscription for CIMIndicationEvents on pub/sub failed because of " + exception.getMessage(), (Throwable)exception);
                bl = false;
            }
        }
        catch (Throwable throwable) {}
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shutdown() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        boolean bl = true;
        try {
            logTraceHelper.traceInfo("setting status to STOPPING");
            this.cStatus.setRunStatus(11);
            logTraceHelper.traceInfo("shutting down filter and worker thread");
            if (this.cFilterThread.isAlive()) {
                this.cFilterThread.shutdown();
            }
            if (this.cWorkerThread.isAlive()) {
                this.cWorkerThread.shutdown();
            }
            if (!this.cEntryQueue.isEmpty()) {
                logTraceHelper.traceInfo("shutting down entry queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cEntryQueue.shutdown();
            }
            if (!this.cCreationBufferQueue.isEmpty()) {
                logTraceHelper.traceInfo("shutting down InstCreation buffer queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cCreationBufferQueue.shutdown();
            }
            if (!this.cDeletionBufferQueue.isEmpty()) {
                logTraceHelper.traceInfo("shutting down InstDeletion buffer queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cDeletionBufferQueue.shutdown();
            }
            if (!this.cWorkerQueue.isEmpty()) {
                logTraceHelper.traceInfo("shutting down worker queue will delete unhandled indications, restarting DeviceServer will refresh inventory collection");
                this.cWorkerQueue.shutdown();
            }
            try {
                try {
                    logTraceHelper.traceInfo("unsubscring: closing subscriber and factory");
                    cIndicationSubscriber.close();
                    cFactory.close();
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("HWN099993E", (Throwable)exception);
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                logTraceHelper.traceInfo("setting status to STOPPED");
                this.cStatus.setRunStatus(10);
                throw throwable;
            }
            {
                Object var4_6 = null;
                logTraceHelper.traceInfo("setting status to STOPPED");
                this.cStatus.setRunStatus(10);
            }
        }
        catch (Throwable throwable) {}
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }

    public String getDescription() {
        return "Disk Monitor: This service handles disk related events.";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("getAffectedHostTest", new Integer(RoleChecker.DISK_VIEWER));
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"onMessage", (Object[])new Object[]{message});
        try {
            block6: {
                try {
                    ObjectMessage objectMessage = (ObjectMessage)message;
                    SRMEvent sRMEvent = (SRMEvent)objectMessage.getObject();
                    if (sRMEvent instanceof CIMIndicationEvent) {
                        logTraceHelper.traceInfo("adding indication to entry queue");
                        this.cEntryQueue.add((CIMIndicationEvent)sRMEvent);
                        break block6;
                    }
                    logTraceHelper.traceInfo("ignoring non-indication event");
                }
                catch (JMSException jMSException) {
                    logTraceHelper.traceError("HWN099993E", (Throwable)jMSException);
                }
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    public String dispatch(String string, String[] stringArray) {
        return DiskCliDispatcher.dispatch(this, string, stringArray);
    }

    public static void getAffectedHostTest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        HashMap hashMap;
        String string9 = null;
        List list = null;
        if (string != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForStorageSystem((String)string);
            System.out.println("StorageSystem with ID " + string + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForStorageSystem((String)string);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForStorageSystem((String)"0");
            System.out.println("StorageSystem with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForStorageSystem(string9);
            System.out.println("StorageSystem with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string2 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForVolume((String)string2);
            System.out.println("Volume with ID " + string2 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForVolume((String)string2);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForVolume((String)"0");
            System.out.println("Volume with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForVolume(string9);
            System.out.println("Volume with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string3 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForPort((String)string3);
            System.out.println("Port with ID " + string3 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForPort((String)string3);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForPort((String)"0");
            System.out.println("Port with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForPort(string9);
            System.out.println("Port with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string4 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForPool((String)string4);
            System.out.println("Pool with ID " + string4 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForPool((String)string4);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForPool((String)"0");
            System.out.println("Pool with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForPool(string9);
            System.out.println("Pool with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string5 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForNode((String)string5);
            System.out.println("Node with ID " + string5 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForNode((String)string5);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForNode((String)"0");
            System.out.println("Node with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForNode(string9);
            System.out.println("Node with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string6 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForExtent((String)string6);
            System.out.println("Extent with ID " + string6 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForExtent((String)string6);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForExtent((String)"0");
            System.out.println("Extent with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForExtent(string9);
            System.out.println("Extent with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string7 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForDiskGroup((String)string7);
            System.out.println("DiskGroup with ID " + string7 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForDiskGroup((String)string7);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForDiskGroup((String)"0");
            System.out.println("DiskGroup with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForDiskGroup(string9);
            System.out.println("DiskGroup with ID " + string9 + " affecting Hosts " + list.toString());
        }
        if (string8 != null) {
            list = AffectedHostAnalyzer.getAffectedHostsForDiskDrive((String)string8);
            System.out.println("DiskDrive with ID " + string8 + " affecting Hosts " + list.toString());
            if (list.size() == 0) {
                hashMap = AffectedHostAnalyzer.analyzeAffectedHostsForDiskDrive((String)string8);
                DiskMonitorService.analyzeResult(hashMap);
            }
            list = AffectedHostAnalyzer.getAffectedHostsForDiskDrive((String)"0");
            System.out.println("DiskDrive with ID 0 affecting Hosts " + list.toString());
            list = AffectedHostAnalyzer.getAffectedHostsForDiskDrive(string9);
            System.out.println("DiskDrive with ID " + string9 + " affecting Hosts " + list.toString());
        }
    }

    private static void analyzeResult(HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)hashMap.get(string);
            System.out.println("Found related " + string + " with these IDs " + list.toString());
        }
    }
}

