/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class StorageExtentCacheStep
extends COPCacheStep
implements IStep {
    protected IStep cCollectVolumesStep = null;

    public StorageExtentCacheStep(String string, DiskCIMProcessor diskCIMProcessor, boolean bl) {
        super(string, diskCIMProcessor, bl);
    }

    public StorageExtentCacheStep(COPCacheStep cOPCacheStep) {
        super(cOPCacheStep);
    }

    public StorageExtentCacheStep(COPCacheStep cOPCacheStep, boolean bl) {
        super(cOPCacheStep, bl);
    }

    protected boolean handleCacheHit(String string, CIMInstance cIMInstance, Hashtable hashtable, Map map, LogTraceHelper logTraceHelper) throws Exception {
        boolean bl = true;
        Result result = new Result(1);
        CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
        logTraceHelper.traceInfo("Cache hit for " + this.cInstanceName + " with COP " + cIMObjectPath.toString());
        CIMInstance cIMInstance2 = (CIMInstance)map.get("CIM_StoragePool");
        if (cIMInstance2 != null) {
            boolean bl2 = this.checkPrimoridalPool(cIMInstance2);
            if (!bl2) {
                // empty if block
            }
            logTraceHelper.traceInfo("persist " + this.cInstanceName + " with COP " + cIMObjectPath.toString());
            result = this.persistInstance(cIMInstance, this.cInstanceName, map, logTraceHelper);
            bl = result.getRc() == 0 ? this.cCollectVolumesStep.process(string, map) : false;
        }
        this.cDiskCIMProcessor.getDBReferences().put(this.cInstanceName, hashtable);
        return bl;
    }

    protected boolean checkPrimoridalPool(CIMInstance cIMInstance) {
        Hashtable hashtable = DiskCIMProcessor.convertPropertiesToHashtable((Vector)cIMInstance.getAllProperties(), new Hashtable());
        String string = (String)hashtable.get("primordial");
        boolean bl = string != null && string.equalsIgnoreCase("true");
        return bl;
    }

    public void addCollectVolumesStep(IStep iStep) {
        this.cCollectVolumesStep = iStep;
    }

    protected boolean processNext(String string, Map map) throws Exception {
        CIMInstance cIMInstance;
        boolean bl = super.processNext(string, map);
        if (bl && (cIMInstance = (CIMInstance)map.get("CIM_StoragePool")) != null && !this.checkPrimoridalPool(cIMInstance)) {
            bl = this.cCollectVolumesStep.process(string, map);
        }
        return bl;
    }
}

