/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.MappingManagementMultiplePortSMIS11;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;

public class MappingManagementFAStT11
extends MappingManagementMultiplePortSMIS11 {
    private static String cLUNUsed = "the logical unit number (LUN) is already in use by the Access Volume";
    private static String cInvalidParam = "INVALID PARAMETER";

    public MappingManagementFAStT11(StorageConfigurationPlugin storageConfigurationPlugin, CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, CapabilityData capabilityData, String string, Token token) {
        super(storageConfigurationPlugin, cIMClientWrapper, cIMObjectPath, capabilityData, string, token);
    }

    public CIMObjectPath validateProtocolController(CIMObjectPath cIMObjectPath) {
        if (this.cPlugin.getParams().getAPIMethodName().equalsIgnoreCase("unassignStorageVolumesFromWWPNs")) {
            return cIMObjectPath;
        }
        String string = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPath, (String)"DeviceID");
        if (!string.matches("0*")) {
            return cIMObjectPath;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList attachDevices(ProtocolControllerToPrivileges protocolControllerToPrivileges, CIMObjectPath[] cIMObjectPathArray, String[] stringArray, String[] stringArray2, AssignStorageVolumesParameter assignStorageVolumesParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"attachDevices", (Object[])new Object[]{protocolControllerToPrivileges, cIMObjectPathArray, stringArray, stringArray2});
        ArrayList arrayList = new ArrayList();
        try {
            if (cIMObjectPathArray.length > 0) {
                String[] stringArray3 = this.getFCPortWWPNs(protocolControllerToPrivileges.getProtocolController());
                String[] stringArray4 = stringArray2;
                int n = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignRetries", (int)2);
                int n2 = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignDeviceNumberOffset", (int)0);
                boolean bl = false;
                while (!bl) {
                    try {
                        CIMObjectPath[] cIMObjectPathArray2 = this.exposePaths(assignStorageVolumesParameter.getCapability(), protocolControllerToPrivileges.getProtocolController(), assignStorageVolumesParameter.getVolumeNamesForCOPs(cIMObjectPathArray), null, null, stringArray4);
                        bl = true;
                        this.checkModifiedProtocolControllers(protocolControllerToPrivileges, cIMObjectPathArray2);
                        String[] stringArray5 = this.getDeviceNumbers(protocolControllerToPrivileges.getProtocolController(), assignStorageVolumesParameter.getVolumeCOPs());
                        arrayList.addAll(ConfigurationResultHelper.createMappingResults(protocolControllerToPrivileges.getPrivilegeToWWPNs(), stringArray, stringArray5, stringArray3, protocolControllerToPrivileges.getProtocolController(), this.cToken));
                        assignStorageVolumesParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignStorageVolumesParameter.getAsyncResult(), arrayList, (String)assignStorageVolumesParameter.getAPIMethodName()));
                    }
                    catch (ServerException serverException) {
                        if (n <= 0) {
                            throw serverException;
                        }
                        stringArray4 = this.setDeviceNumbers(protocolControllerToPrivileges, stringArray, n2, serverException);
                        --n;
                        ++n2;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForStorageHardwareIDs(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForStorageHardwareIDs", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList arrayList3 = null;
        try {
            PrivilegeManagement privilegeManagement = this.cPlugin.getPrivilegeManagement();
            ArrayList arrayList4 = privilegeManagement.retrievePrivilegesForInitiators(arrayList, arrayList2);
            ArrayList arrayList5 = new ArrayList();
            boolean bl = false;
            if (arrayList2 == null) {
                bl = true;
            }
            arrayList3 = this.retrieveProtocolControllersForPrivileges(arrayList4, arrayList5);
            ArrayList<String> arrayList6 = new ArrayList<String>();
            int n = 0;
            while (n < arrayList3.size()) {
                ProtocolControllerToPrivileges protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList3.get(n);
                arrayList6.addAll(protocolControllerToPrivileges.getWWPNs());
                ++n;
            }
            n = 0;
            while (n < arrayList.size()) {
                if (!arrayList6.contains(((StorageHardwareID)arrayList.get(n)).getWWPN())) {
                    if (bl) {
                        ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021614E", (Object)((StorageHardwareID)arrayList.get(n)).getWWPN(), (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                        throw serverException;
                    }
                    arrayList2.add(((StorageHardwareID)arrayList.get(n)).getWWPN());
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createMappingExposePathsWithoutProtocolController(AssignStorageVolumesParameter assignStorageVolumesParameter, ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createMappingExposePathsWithoutProtocolController", (Object[])new Object[]{assignStorageVolumesParameter, arrayList, arrayList2});
        try {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n = 0;
            while (n < assignStorageVolumesParameter.getInitiatorWWPNsArray().length) {
                if (!ParameterHelper.listContainsStringIgnoreCase((List)arrayList2, (String)assignStorageVolumesParameter.getInitiatorWWPNsArray()[n])) {
                    arrayList3.add(assignStorageVolumesParameter.getInitiatorWWPNsArray()[n]);
                }
                ++n;
            }
            if (arrayList3.size() != 0) {
                n = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignRetries", (int)2);
                int n2 = DiskManagerConfigSvc.getIntConfigValue((String)"Configuration.FAStTAssignDeviceNumberOffset", (int)0);
                String[] stringArray = assignStorageVolumesParameter.getDeviceNumbers();
                boolean bl = false;
                while (!bl) {
                    try {
                        Object object;
                        Object object2;
                        CIMObjectPath[] cIMObjectPathArray = this.exposePaths(assignStorageVolumesParameter.getCapability(), null, assignStorageVolumesParameter.getVolumeNames(), assignStorageVolumesParameter.getInitiatorWWPNsArray(), assignStorageVolumesParameter.getTargetPortWWPNs(), stringArray);
                        bl = true;
                        boolean bl2 = false;
                        int n3 = 0;
                        while (n3 < cIMObjectPathArray.length) {
                            object2 = (String)CIMInstanceHelper.getCIMKeyValue((CIMObjectPath)cIMObjectPathArray[n3], (String)"DeviceId");
                            if ("0000000000000000000000000000000000000000".equals(object2)) {
                                bl2 = true;
                            }
                            ++n3;
                        }
                        if (bl2) {
                            CIMObjectPath[] cIMObjectPathArray2 = assignStorageVolumesParameter.getVolumeCOPs();
                            object2 = new ArrayList();
                            int n4 = 0;
                            while (n4 < cIMObjectPathArray2.length) {
                                object = this.cCimClient.associatorNames(cIMObjectPathArray2[n4], "CIM_ProtocolControllerForUnit", null, null, null, logTraceHelper);
                                while (object.hasMoreElements()) {
                                    CIMObjectPath cIMObjectPath = (CIMObjectPath)object.nextElement();
                                    if (object2.contains(cIMObjectPath)) continue;
                                    object2.add(cIMObjectPath);
                                }
                                ++n4;
                            }
                            cIMObjectPathArray = object2.toArray(new CIMObjectPath[object2.size()]);
                        }
                        n3 = 0;
                        while (n3 < cIMObjectPathArray.length) {
                            object2 = this.getDeviceNumbers(cIMObjectPathArray[n3], assignStorageVolumesParameter.getVolumeCOPs());
                            String[] stringArray2 = this.getFCPortWWPNs(cIMObjectPathArray[n3]);
                            object = this.cPlugin.getHardwareIDManagement().retrieveStorageHardwareIDs(arrayList3, true);
                            arrayList.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(stringArray2, (ArrayList)object, assignStorageVolumesParameter.getVolumeIDs(), object2, assignStorageVolumesParameter, this.cPlugin.getHardwareIDManagement(), cIMObjectPathArray[n3], this.cToken));
                            assignStorageVolumesParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignStorageVolumesParameter.getAsyncResult(), (ArrayList)arrayList, (String)assignStorageVolumesParameter.getAPIMethodName()));
                            ++n3;
                        }
                    }
                    catch (CIMException cIMException) {
                        logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                        throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                        logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                        throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (ServerException serverException) {
                        if (n <= 0) {
                            throw serverException;
                        }
                        stringArray = this.setDeviceNumbers(null, assignStorageVolumesParameter.getVolumeNames(), n2, serverException);
                        ++n2;
                        --n;
                    }
                }
            }
            Object var17_25 = null;
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    private String[] setDeviceNumbers(ProtocolControllerToPrivileges protocolControllerToPrivileges, String[] stringArray, int n, ServerException serverException) {
        String[] stringArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"setDeviceNumbers", (Object[])new Object[]{protocolControllerToPrivileges, stringArray, new Integer(n), serverException});
        String[] stringArray3 = new String[stringArray.length];
        try {
            if (serverException.getSRMMessage().getMsgId() == "HWN021515E" && (serverException.getCause().toString().toUpperCase().indexOf(cInvalidParam) != -1 || serverException.getCause().toString().toUpperCase().indexOf(cLUNUsed.toUpperCase()) != -1)) {
                ArrayList arrayList = new ArrayList();
                if (protocolControllerToPrivileges != null) {
                    arrayList = this.getDeviceNumbersOfProtocolController(protocolControllerToPrivileges.getProtocolController());
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray3.length) {
                    int n4 = 0;
                    while (n4 < 256) {
                        if (!arrayList.contains(Integer.toString(n2)) && !arrayList.contains(Integer.toString(n2 + n))) {
                            stringArray3[n3] = Integer.toString(n2 + n);
                            break;
                        }
                        ++n2;
                        ++n4;
                    }
                    if (stringArray3[n3] == null) {
                        ServerException serverException2 = DiskMessageHelper.getServerException((String)"HWN021503E", null, (LogTraceHelper)logTraceHelper);
                        logTraceHelper.traceError("All possible 255 DeviceNumbers are already used", (Throwable)serverException2);
                        throw serverException2;
                    }
                    ++n3;
                }
            } else {
                throw serverException;
            }
            stringArray2 = stringArray3;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            logTraceHelper.exit((Object)stringArray3);
            throw throwable;
        }
        logTraceHelper.exit((Object)stringArray3);
        return stringArray2;
    }
}

