/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control;

import java.util.regex.PatternSyntaxException;
import org.eclipse.aperi.disk.control.IStorageConfigurationManagementPlugin;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public class StorageConfigurationPluginExtensionMgr
extends AbstractExtensionMgr {
    private static StorageConfigurationPluginExtensionMgr singleton = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.disk.storageConfiguration";
    private static final String CONFIGURATION_ELEMENT = "StorageConfigurationPlugin";
    private static final String ATTR_PROFILE = "profile";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VENDOR = "vendor";
    private static final String ATTR_SMIS = "SMIS";
    private static final String ATTR_NAME = "name";

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    public StorageConfigurationPluginExtensionMgr() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public static synchronized StorageConfigurationPluginExtensionMgr getExtensionMgr() {
        if (singleton == null) {
            singleton = new StorageConfigurationPluginExtensionMgr();
        }
        return singleton;
    }

    public void dispose() {
        super.dispose();
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        iExtensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public IStorageConfigurationPlugin getPlugin(ConfigurationParameter configurationParameter) {
        IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals(CONFIGURATION_ELEMENT)) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    iConfigurationElement.getAttribute(ATTR_NAME);
                    String string = iConfigurationElement.getAttribute(ATTR_SMIS);
                    String string2 = iConfigurationElement.getAttribute(ATTR_TYPE);
                    iConfigurationElement.getAttribute(ATTR_VENDOR);
                    iConfigurationElement.getAttribute(ATTR_PROFILE);
                    if (StorageConfigurationPluginExtensionMgr.matchesStringPattern(configurationParameter.getCapability().getSmisVersion(), string) && StorageConfigurationPluginExtensionMgr.matchesStringPattern(configurationParameter.getStorageSubsystem().getType(), string2)) {
                        IStorageConfigurationManagementPlugin iStorageConfigurationManagementPlugin = null;
                        try {
                            iStorageConfigurationManagementPlugin = (IStorageConfigurationManagementPlugin)this.getExtensionImpl(iExtensionArray[n].getUniqueIdentifier(), false);
                            if (iStorageConfigurationManagementPlugin != null) {
                                iStorageConfigurationManagementPlugin.setParams(configurationParameter);
                            }
                            return iStorageConfigurationManagementPlugin;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return iStorageConfigurationManagementPlugin;
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    protected static boolean matchesStringPattern(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        try {
            return string.trim().toUpperCase().matches(string2.trim().toUpperCase());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
            return false;
        }
    }
}

