/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.objects.Volume2extent;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;

public class DiskMonitorHelper {
    public static int[] getManagedSubsystems(DBConnection dBConnection, String string, String string2) throws SQLException {
        int[] nArray;
        block4: {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimom2namespaceTable.getColumnInfo((String)"CIMOM_ID"), string);
            hashtable.put(TResCimom2namespaceTable.getColumnInfo((String)"NAMESPACE"), string2);
            String string3 = "SELECT SUBSYSTEM_ID FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE " + "CIM_NAMESPACE_ID" + " = (SELECT " + "CIM_NAMESPACE_ID" + " FROM " + TResCimom2namespaceTable.getTablename() + " WHERE " + "CIMOM_ID" + " = (?) AND " + "NAMESPACE" + " = (?))";
            DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string3, hashtable);
            try {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (dBResultSet.next()) {
                    arrayList.add(new Integer(dBResultSet.getInt(1)));
                }
                int[] nArray2 = new int[arrayList.size()];
                int n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = (Integer)arrayList.get(n);
                    ++n;
                }
                nArray = nArray2;
                Object var9_10 = null;
                if (dBResultSet == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var9_11 = null;
                    if (dBResultSet == null) break block5;
                    dBResultSet.closeAll();
                }
                throw throwable;
            }
            dBResultSet.closeAll();
        }
        return nArray;
    }

    public static int getVolumeId(DBConnection dBConnection, CIMIndicationEvent cIMIndicationEvent, CIMObjectPath cIMObjectPath) throws SQLException {
        int n;
        block4: {
            String string = (String)cIMObjectPath.getKey("CreationClassName").getValue().getValue();
            String string2 = (String)cIMObjectPath.getKey("SystemCreationClassName").getValue().getValue();
            String string3 = (String)cIMObjectPath.getKey("SystemName").getValue().getValue();
            String string4 = (String)cIMObjectPath.getKey("DeviceID").getValue().getValue();
            Cimom2namespace cimom2namespace = new Cimom2namespace();
            cimom2namespace.setCimomId(Integer.parseInt(cIMIndicationEvent.getCIMOM().getServiceId()));
            String string5 = DiskMonitorHelper.removeLeadingSlash(cIMIndicationEvent.getCIMNameSpace());
            cimom2namespace.setNamespace(string5);
            cimom2namespace.retrieve(dBConnection);
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID((DBConnection)dBConnection, (String)string)));
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID((DBConnection)dBConnection, (String)string2)));
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID((DBConnection)dBConnection, (String)string3)));
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"DEVICE_ID"), string4);
            hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), String.valueOf(cimom2namespace.getCimNamespaceId()));
            String string6 = "SELECT VOLUME_ID FROM " + TResCimkeyVolumeTable.getTablename() + " WHERE " + "CIM_NAMESPACE_ID" + " = (?) AND " + "CREATION_CLASS_NAME_ID" + " = (?) AND " + "DEVICE_ID" + " = (?) AND " + "SYSTEM_CREATION_CLASS_NAME_ID" + " = (?) AND " + "SYSTEM_NAMES_ID" + " = (?) FOR READ ONLY";
            System.out.println(dBConnection.isClosed());
            DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string6, hashtable);
            try {
                if (!dBResultSet.next()) {
                    throw new NotFoundException("Volume " + cIMObjectPath.toString() + " not in db.");
                }
                int n2 = dBResultSet.getInt(1);
                if (dBResultSet.next()) {
                    throw new DbConstraintException("Multiple matches on single row query.");
                }
                n = n2;
                Object var13_14 = null;
                if (dBResultSet == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var13_15 = null;
                    if (dBResultSet == null) break block5;
                    dBResultSet.closeAll();
                }
                throw throwable;
            }
            dBResultSet.closeAll();
        }
        return n;
    }

    public static String removeLeadingSlash(String string) {
        String string2 = string;
        try {
            int n = string.indexOf(47);
            if (n == 0) {
                string2 = string.substring(1);
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    public static void deleteVolumes(DBConnection dBConnection, int[] nArray) throws SQLException {
        int n = 0;
        while (n < nArray.length) {
            DiskMonitorHelper.deleteVolume(dBConnection, nArray[n]);
            ++n;
        }
    }

    public static void deleteVolume(DBConnection dBConnection, int n) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(CimkeyVolume.getColumnInfo((String)"VOLUME_ID"), String.valueOf(n));
        CimkeyVolume.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(StorageVolume.getColumnInfo((String)"SVID"), String.valueOf(n));
        StorageVolume.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(Volume2extent.getColumnInfo((String)"VOLUME_ID"), String.valueOf(n));
        Volume2extent.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(DataPath.getColumnInfo((String)"VOLUME_ID"), String.valueOf(n));
        DataPath.deletes((DBConnection)dBConnection, hashtable);
    }

    public static void detachExtents(DBConnection dBConnection, String string, Integer n) throws SQLException {
        Hashtable<ColumnInfo, Integer> hashtable = new Hashtable<ColumnInfo, Integer>();
        hashtable.put(TResStorageExtentTable.getColumnInfo((String)string), n);
        String string2 = "UPDATE " + TResStorageExtentTable.getTablename() + " SET " + string + " = CAST(NULL AS INTEGER) WHERE " + string + " = (?)";
        ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string2, hashtable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap getKeyMapFromCOP(DBConnection dBConnection, CIMObjectPath cIMObjectPath) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)"DiskMonitorHelper", (String)"getKeyMapFromCOP", (Object[])new Object[]{dBConnection, cIMObjectPath});
        HashMap<String, String> hashMap = null;
        try {
            hashMap = new HashMap<String, String>();
            Vector vector = cIMObjectPath.getKeys();
            int n = 0;
            while (n < vector.size()) {
                String string;
                CIMProperty cIMProperty = (CIMProperty)vector.get(n);
                if (cIMProperty.getName().equalsIgnoreCase("SystemCreationClassName")) {
                    string = (String)cIMProperty.getValue().getValue();
                    hashMap.put("SystemCreationClassName", Short.toString(Normalizer.SystemCreationClassNameGetID((DBConnection)dBConnection, (String)string)));
                }
                if (cIMProperty.getName().equalsIgnoreCase("CreationClassName")) {
                    string = (String)cIMProperty.getValue().getValue();
                    hashMap.put("CreationClassName", Short.toString(Normalizer.CreationClassNameGetID((DBConnection)dBConnection, (String)string)));
                }
                if (cIMProperty.getName().equalsIgnoreCase("SystemName")) {
                    string = (String)cIMProperty.getValue().getValue();
                    hashMap.put("SystemName", Short.toString(Normalizer.SystemNamesGetID((DBConnection)dBConnection, (String)string)));
                }
                if (cIMProperty.getName().equalsIgnoreCase("DeviceID")) {
                    hashMap.put("DeviceID", (String)cIMProperty.getValue().getValue());
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            logTraceHelper.exit(hashMap);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        logTraceHelper.exit(hashMap);
        return hashMap;
    }

    public static void addEntriesToInternalList(Map map, Map map2) {
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LinkedList linkedList = (LinkedList)map.get(entry.getKey());
            if (linkedList == null) {
                linkedList = new LinkedList();
                map.put(entry.getKey(), linkedList);
            }
            linkedList.add(entry.getValue());
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 2430267413862151992L;

        public NotFoundException(String string) {
            super(string);
        }
    }

    public static class DbConstraintException
    extends RuntimeException {
        private static final long serialVersionUID = -8730467849991399192L;

        public DbConstraintException(String string) {
            super(string);
        }
    }
}

