/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ThemeEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ThemeRecord
extends SimpleRecord {
    private ElementRefValue newTheme;
    private ElementRefValue oldTheme;
    protected Module module;
    static final /* synthetic */ boolean $assertionsDisabled;

    ThemeRecord(Module module, ElementRefValue newTheme) {
        this.module = module;
        this.newTheme = newTheme;
        this.oldTheme = (ElementRefValue)module.getLocalProperty(module, "theme");
        this.label = ModelMessages.getMessage("Message.SetTheme");
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.module.setProperty("theme", (Object)this.oldTheme);
            this.updateStyles(this.newTheme);
        } else {
            this.module.setProperty("theme", (Object)this.newTheme);
            this.updateStyles(this.oldTheme);
        }
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public NotificationEvent getEvent() {
        return new ThemeEvent(this.module);
    }

    private void updateStyles(ElementRefValue theme) {
        if (theme == null) {
            return;
        }
        if (!theme.isResolved()) {
            return;
        }
        Iterator iter = ((Theme)theme.getElement()).getSlot(0).iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            if (!$assertionsDisabled && !(element instanceof StyleElement)) {
                throw new AssertionError();
            }
            ReferenceableElement referenceableElement = (ReferenceableElement)element;
            referenceableElement.updateClientReferences();
        }
    }

    static {
        $assertionsDisabled = !ThemeRecord.class.desiredAssertionStatus();
    }
}

