/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.hostquery;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.hostquery.HostQuery;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class HostInfo {
    private ILogger trace_logger;
    private ILogger message_logger;
    String osName;
    String jvmVersion;
    String hostName;
    int hostPort;
    String hostIP;

    public HostInfo() {
        block6: {
            this.trace_logger = HostQuery.trace_logger;
            this.message_logger = HostQuery.message_logger;
            if (this.trace_logger.isLogging()) {
                this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "HostInfo_Constructor");
            }
            this.osName = System.getProperty("os.name");
            this.jvmVersion = System.getProperty("java.version");
            this.hostPort = this.getAgentPort();
            if (this.jvmVersion == null) {
                this.jvmVersion = "null jvm";
            }
            if (this.trace_logger.isLogging()) {
                this.trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "HostInfo", "System.is " + System.getProperty("java.vm.version"));
            }
            try {
                this.hostName = this.determineHost();
                this.hostIP = this.chooseIP();
            }
            catch (Exception exception) {
                if (!this.trace_logger.isLogging()) break block6;
                this.trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "HostInfo", (Throwable)exception);
            }
        }
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "HostInfo_Constructor", (Object)("hostName= " + this.hostName));
        }
    }

    private String chooseIP() throws UnknownHostException {
        InetAddress inetAddress;
        String string = null;
        if (this.trace_logger.isLogging()) {
            this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "chooseIP");
        }
        string = this.isExternal(inetAddress = InetAddress.getLocalHost()) ? inetAddress.getHostAddress() : this.getIPAddress(this.hostName);
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "chooseIP", (Object)("IP= " + string));
        }
        return string;
    }

    private String determineHost() {
        String string;
        block5: {
            if (this.trace_logger.isLogging()) {
                this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "determineHost");
            }
            string = null;
            Process process = null;
            try {
                String string2 = Variables.getExecutableDirectory();
                process = InterpResolver.isWindows() ? Runtime.getRuntime().exec("\"" + string2 + File.separator + "gethostname" + "\"") : Runtime.getRuntime().exec(String.valueOf(string2) + File.separator + "gethostname");
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {
                if (this.message_logger.isLogging()) {
                    this.message_logger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, "determineHost", "BTShostNameFail");
                }
                if (!this.trace_logger.isLogging()) break block5;
                this.trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "determineHost", (Throwable)exception);
            }
        }
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "determineHost", (Object)("hostName= " + string));
        }
        return string;
    }

    private String getIPAddress(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < inetAddressArray.length) {
            int n6 = this.getIntAddress(inetAddressArray[n5]);
            if (this.isExternal(inetAddressArray[n5])) {
                return inetAddressArray[n5].getHostAddress();
            }
            if (this.isSiteLocalAddress(n6)) {
                if (n == -1) {
                    n = n5;
                }
            } else if (this.isLinkLocalAddress(n6)) {
                if (n2 == -1) {
                    n2 = n5;
                }
            } else if (this.isLoopbackAddress(inetAddressArray[n5])) {
                if (n3 == -1) {
                    n3 = n5;
                }
            } else if (this.isMulticastAddress(n6) && n4 == -1) {
                n4 = n5;
            }
            ++n5;
        }
        if (n2 >= 0) {
            return inetAddressArray[n2].getHostAddress();
        }
        if (n >= 0) {
            return inetAddressArray[n].getHostAddress();
        }
        if (n3 >= 0) {
            return inetAddressArray[n3].getHostAddress();
        }
        if (n4 >= 0) {
            return inetAddressArray[n4].getHostAddress();
        }
        if (inetAddressArray.length > 0) {
            return inetAddressArray[0].getHostAddress();
        }
        return null;
    }

    private int getIntAddress(InetAddress inetAddress) {
        int n = 0;
        byte[] byArray = inetAddress.getAddress();
        if (byArray != null && byArray.length == 4) {
            n = byArray[3] & 0xFF;
            n |= byArray[2] << 8 & 0xFF00;
            n |= byArray[1] << 16 & 0xFF0000;
            n |= byArray[0] << 24 & 0xFF000000;
        }
        return n;
    }

    private boolean isExternal(InetAddress inetAddress) {
        int n = this.getIntAddress(inetAddress);
        return !this.isSiteLocalAddress(n) && !this.isLinkLocalAddress(n) && !this.isMulticastAddress(n) && !this.isLoopbackAddress(inetAddress);
    }

    private boolean isSiteLocalAddress(int n) {
        return (n >>> 24 & 0xFF) == 10 || (n >>> 24 & 0xFF) == 172 && (n >>> 16 & 0xF0) == 16 || (n >>> 24 & 0xFF) == 192 && (n >>> 16 & 0xFF) == 168;
    }

    private boolean isLinkLocalAddress(int n) {
        return (n >>> 24 & 0xFF) == 169 && (n >>> 16 & 0xFF) == 254;
    }

    private boolean isLoopbackAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        return byArray[0] == 127;
    }

    private boolean isMulticastAddress(int n) {
        return (n & 0xF0000000) == -536870912;
    }

    private int getAgentPort() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IConfigService iConfigService = (IConfigService)Activator.getService(clazz);
        String string = iConfigService.getProperty("agent.port", "setup");
        return Integer.parseInt(string);
    }
}

