<!-- ****************************************** {COPYRIGHT-TOP} **
* Aperi Storage Manager
* (C) Copyright Eclipse contributors and others. 2007
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
******************************************* {COPYRIGHT-END} * -->
<%@ page import="org.mortbay.jaas.JAASUserPrincipal" %>
<%@ page import="org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker" %>

<%
    JAASUserPrincipal userPrincipal = (JAASUserPrincipal)request.getUserPrincipal();
	boolean isSuperuser = userPrincipal==null ? true : userPrincipal.isUserInRole(RoleChecker.APERI_SUPERUSER);
%>

<script type="text/javascript">
	dojo.require("dojo.widget.TreeV3");
	dojo.require("dojo.widget.TreeNodeV3");
	dojo.require("dojo.widget.TreeSelectorV3");
	dojo.require("dojo.widget.TreeBasicControllerV3");
	dojo.require("dojo.widget.TreeContextMenuV3");
</script>
<div style="position=relative;">
	<div dojoType="TreeLoadingControllerV3" widgetId="treeController" RpcUrl="/aperi-reports/TreeControl"></div>
	<div dojoType="TreeSelectorV3" widgetId="selector"></div>	
	<div dojoType="TreeDocIconExtension" widgetId="docIcons"></div>
	<div dojoType="TreeV3" widgetId="navTree" listeners="treeController;selector;docIcons">
	<div dojoType="TreeNodeV3" isFolder="true" title="Report Repository" id='Root Node'></div>
</div>
	
<script type="text/javascript">
dojo.require("dojo.widget.Menu2");

var baseRpcUrl="/aperi-reports/TreeControl";
var curRpcUrl=baseRpcUrl;
var isSuperuser = <%=isSuperuser%>;

function infoMenu(object) {
	launchDialog('info.jsp', {path: object.path, file: object.filename},'Report Info',800,650);
}
function uploadMenu(object) {
	launchDialog('upload.jsp',{path: object},'Deploy Report',800,600);
}
function editMenu(object) {
	launchDialog('edit.jsp', {path: object.path, file: object.filename},'Edit Report',800,600);
}
function deleteReportMenu(object) {
	launchDialog('deleteReport.jsp',{path: object.path, file: object.filename},'Delete Report',800,400);
}
function deleteDirectoryMenu(path) {
	launchDialog('deleteDirectory.jsp', {path: path},'Delete Directory',800,125);
}

var treeLoader = function() {
	w = dojo.widget.byId('treeController');
	w.RpcUrl = curRpcUrl;
	w.loadRemote(dojo.widget.byId('Root Node')).
		addCallbacks(
			function() { dojo.widget.byId('treeController').expandToLevel(dojo.widget.byId('Root Node'),2); }, 
			function(err) { dojo.debugShallow("error!");}); // TODO better error handling
};
	
function argify (args) {
	var r="";
	if (args.length != 0) {
		r += "?";
		var t = 0;
		for (p in args) {
			r += ((t++?"&":"")+p+"="+args[p]);
		}
	}
	return r;
}

function launchDialog(/*string*/dialogName, /*string*/dialogArgs, /*string*/dialogTitle, /*int*/width, /*int*/height) {
	dialogArgs.cancelEnabled = true; // turn on cancel button
	var w = null;
	try {
		// for reasons not at all clear the title needs to be static string for this to work, otherwise IE throws an invalid param
		// Window title gets set via HTML
		w = window.open(dialogName+argify(dialogArgs), '', 'width='+width+',height='+(height+(djConfig.isDebug?100:0)));
	} catch(exc) { } // just swallow the exception
	if (!w) {
		// Grrr, can't open a new window fall back to the report viewer pane
		dialogArgs.cancelEnabled = false; // turn off or modify cancel button
		parent.report_view.location=dialogName+argify(dialogArgs);
		parent.report_view.title=dialogTitle;
	}
}

function addTooltip(/*domNode*/node, /*string*/description) {
	dojo.widget.createWidget(
		"Tooltip", 
		{caption: description, 
		connectId: node,
		showDelay: 500,
		hideDelay: 10});
}

function addReportMenu(/*TreeNodeV3*/node) {
	var menu = dojo.widget.createWidget("PopupMenu2", {targetNodeIds: [node.domNode.id]});
	menu.addChild(dojo.widget.createWidget("MenuItem2", {caption: "Info", iconSrc: "/aperi-reports/images/info_16x16.gif", _reportObject: node.object, onClick: function(){infoMenu(this._reportObject);}}));
	if (isSuperuser) {
		menu.addChild(dojo.widget.createWidget("MenuItem2", {caption: "Edit", iconSrc: "/aperi-reports/images/edit_16x16.gif", _reportObject: node.object, onClick: function(){editMenu(this._reportObject);}}));
		menu.addChild(dojo.widget.createWidget("MenuItem2", {caption: "Delete", iconSrc: "/aperi-reports/images/delete_16x16.gif", _reportObject: node.object, onClick: function(){deleteReportMenu(this._reportObject);}}));
	}
}

function emptyNode(/*TreeNodeV3*/node) {
	return ((node.children == null) || (node.children.length == 0));
}

function addDirectoryMenu(/*TreeNodeV3*/node) {
	var menu = dojo.widget.createWidget("PopupMenu2", {targetNodeIds: [node.domNode.id]});
	if (isSuperuser) {
		if ( emptyNode(node) && node.domNode.id != 'Root Node') { // only allow delete of empty nodes and non-root nodes
			menu.addChild(dojo.widget.createWidget("MenuItem2", {caption: "Delete", iconSrc: "/aperi-reports/images/delete_16x16.gif", _reportObject: node.objectId, onClick: function(){deleteDirectoryMenu(this._reportObject);}}));
		}
		menu.addChild(dojo.widget.createWidget("MenuItem2", {caption: "Upload", iconSrc: "/aperi-reports/images/add_16x16.gif", _reportObject: node.objectId, onClick: function(){uploadMenu(this._reportObject);}}));
	}
}
	
function menuizeTreeNode(node) {
	if (!node.__visited) { // don't duplicate tooltips and menus
		node.__visited = true;
		// the pop-up menus need DOM node IDs assigned to work
		if (!node.domNode.id) node.domNode.id = node.widgetId;
		if (!node.isFolder) {
			// tool tips are broken on Microsoft
			if (navigator.appName.indexOf("Microsoft") == -1) {
				addTooltip(node.domNode, node.object.description);
			}
			addReportMenu(node);
		} else { // a directory
			// disable seletion for directory node
			dojo.html.disableSelection(node.domNode); // TODO this doesn't work, fix me!
			addDirectoryMenu(node);
		}
	}
}

dojo.addOnLoad(function (){

	// Arrange to load tooltips and menus into nodes when the parent node is expanded
 	dojo.event.topic.subscribe(
 		'navTree/afterExpand', 
 		{handleIt: function(obj) { 
 			menuizeTreeNode(obj.source);
 			for (var child in obj.source.children) {
 				menuizeTreeNode(obj.source.children[child]);
 			}
 		}},
 		'handleIt');
 		
 	// Launch the report when a report node is selected
    dojo.event.topic.subscribe(
    'selector/select',
    {handleIt: function(args){
    	// for (prop in args.node) { dojo.debug(prop+": "+args.node[prop]); }
     	if (!args.node.isFolder) {
     		// var URL=location.protocol+"//"+location.host+"/birt-viewer/"+(paginateReports?"frameset":"run")+"?__report="+args.node.objectId;
     		// dojo.debug("URL: "+URL);
     		parent.report_view.location=location.protocol+"//"+location.host+"/birt-viewer/"+(paginateReports?"frameset":"run")+"?__report="+args.node.objectId;
     	}
    }},
    'handleIt');
                  
	// Arrange for the tree to be (fully) loaded from the repository and expanded two directories deep
	// TODO get rid of this and incrementally auto load the contents via expansion
	try {
		dojo.widget.byId('treeController').
			loadRemote(dojo.widget.byId('Root Node')).
				addCallbacks(
					function() { dojo.widget.byId('treeController').expandToLevel(dojo.widget.byId('Root Node'),2); }, 
					function(err) { dojo.debugShallow(err); }); // TODO better error handling
	} catch(ex) {
		dojo.debugShallow(ex); // TODO better error handling
	}
	
});
	
</script>
</div>	<%-- tree section --%>
