/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.cimom.SLPScanner;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.SLPObjectParser;
import org.eclipse.aperi.interfaces.ParameterException;

class SLPDiscoveryProcess
extends DiscoverProcess {
    public SLPDiscoveryProcess() {
        super("SLP Discovery", false, new String[]{"SCOPE", "DA"}, new String[]{String[].class.getName(), String[].class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] scope = (String[])SLPDiscoveryProcess.getParameter(parameters, "SCOPE", String[].class.getName());
        String[] da = (String[])SLPDiscoveryProcess.getParameter(parameters, "DA", String[].class.getName());
        Vector<String[]> params = new Vector<String[]>();
        params.add(scope);
        params.add(da);
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
        job.setResourceQueue(SLPScanner.queueName);
        job.setResourceId("SLP");
        job.setRequestId("SLP");
        job.setRequest((Response)new ObjectResponse(params, job));
        JobInfo processJob = (JobInfo)job.clone();
        processJob.setResourceQueue(SLPObjectParser.queueName);
        job.setNextJob(processJob);
        JobEngine.getInstance().addJob(job);
        return new Result(0);
    }

    public String getProcessInfoForJobLog(Map parameters) {
        try {
            String[] scope = (String[])SLPDiscoveryProcess.getParameter(parameters, "SCOPE", String[].class.getName());
            String[] da = (String[])SLPDiscoveryProcess.getParameter(parameters, "DA", String[].class.getName());
            StringBuffer info = new StringBuffer();
            info.append("SLP");
            for (int i = 0; i < da.length; ++i) {
                info.append("+" + da[i]);
            }
            return info.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

