/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.Download;
import org.eclipse.aperi.download.DownloadTarget;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IFileDownload;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDownload
extends Download
implements IFileDownload {
    public static final String ATTR_TARGET = "target";
    Vector<IDownloadTarget> _downloadTargets = new Vector();

    public FileDownload(Node node) throws ConfigurationException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(ATTR_TARGET)) continue;
            this._downloadTargets.add(new DownloadTarget(child));
        }
    }

    @Override
    public Vector<IDownloadTarget> getDownloadTargets() {
        return this._downloadTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String tempDir, String baseDir) throws IOException {
        URL url = new URL(this.getFileUrl());
        URLConnection urlConn = url.openConnection();
        long lastModified_server = urlConn.getLastModified();
        if (this.prepTargets(lastModified_server, this._downloadTargets, baseDir)) {
            return;
        }
        boolean downloadOK = false;
        File tempFile = null;
        try {
            this.createPlaceholders(this._downloadTargets, baseDir);
            File remoteFile = new File(this.getFileUrl());
            String fileName = remoteFile.getName();
            File tempDirFile = new File(tempDir);
            tempFile = File.createTempFile(fileName, null, tempDirFile);
            InputStream in = urlConn.getInputStream();
            FileOutputStream fos = new FileOutputStream(tempFile);
            this.streamCopy(in, fos);
            in.close();
            fos.close();
            downloadOK = true;
        }
        finally {
            if (!downloadOK && tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
        if (downloadOK) {
            this.copyToTargets(tempFile, this._downloadTargets, baseDir, lastModified_server);
        }
    }
}

