/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.install;

import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.repository.table.TSavedReport;

public class StorageAlertOSRepoInstall {
    private DBConnection dbc;
    private static final String[] tpcUsers = new String[]{" ", "Default", "FabricDefault", "DiskDefault"};
    private static final int[][] REPORT_TYPES = new int[][]{{202, 4, 12, 0, 1, 1}, {203, 8, 12, 0, 1, 1}, {204, 10, 15, 0, 1, 1}, {200, 1, 23, 0, 1, 1}, {230, 8, 15, 0, 1, 1}, {233, 83, 101, 0, 1, 2}, {234, 84, 102, 0, 1, 2}, {235, 85, 103, 0, 1, 2}, {236, 86, 104, 0, 1, 2}};

    StorageAlertOSRepoInstall(DBConnection dbc) {
        this.dbc = dbc;
    }

    boolean process() {
        boolean status = true;
        try {
            TSavedReport accessor = new TSavedReport(this.dbc.getConnection());
            for (int i = 0; i < REPORT_TYPES.length; ++i) {
                GuiSavedReportReq savedReport = new GuiSavedReportReq();
                savedReport.creator = tpcUsers[REPORT_TYPES[i][5]];
                savedReport.lastModUser = tpcUsers[REPORT_TYPES[i][5]];
                savedReport.setName(Constants.REPORT_NAMES[i][1]);
                savedReport.setDescription(Constants.REPORT_DESC[i][1]);
                savedReport.ID = REPORT_TYPES[i][0];
                GuiReportReq grr = new GuiReportReq();
                grr.reportType = REPORT_TYPES[i][1];
                grr.reportSubtype = REPORT_TYPES[i][2];
                grr.profile = REPORT_TYPES[i][3];
                savedReport.productCode = (byte)REPORT_TYPES[i][4];
                savedReport.grr = grr;
                accessor.insert(savedReport, true);
                accessor.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Need: driverName URL user password");
            return;
        }
        try {
            DBConstants.useLogging = false;
            DBConnPoolDataSource.initialize((String)args[0], (String)args[1], (String)args[2], (String)args[2], (String)args[3], (int)10);
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            DBConnection dbc = (DBConnection)ds.getPooledConnection();
            StorageAlertOSRepoInstall rip = new StorageAlertOSRepoInstall(dbc);
            rip.process();
            dbc.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

