/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.ExistenceChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class NameListSaver {
    private Connection dbc;
    private Response response;
    private NameList toDelete;
    private NameList bad;
    private boolean resourceReassigned;

    public NameListSaver(Connection dbc, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"NameListSaver", (String)"dbc, response");
        }
        this.dbc = dbc;
        this.response = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"NameListSaver");
        }
    }

    public void save(CreateHeader createHeader, String objectTypeLabel, short objectType, int objectID, NameList[] newDef, NameList[] oldDef, Map existenceCheckTables, boolean rowExists) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"save", (String)"createHeader, objectTypeLabel, objectType, objectID, newDef, oldDef, existenceCheckTables, rowExists");
        }
        this.save(createHeader, objectTypeLabel, objectType, objectID, newDef, oldDef, existenceCheckTables, rowExists, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CreateHeader createHeader, String objectTypeLabel, short objectType, int objectID, NameList[] newDef, NameList[] oldDef, Map existenceCheckTables, boolean rowExists, boolean enforceSingleMembership) throws GeneralException {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"save", (String)"createHeader, objectTypeLabel, objectType, objectID, newDef, oldDef, existenceCheckTables, rowExists, enforceSingleMembership");
        }
        this.resourceReassigned = false;
        HashMap map = new HashMap();
        for (i = 0; i < newDef.length; ++i) {
            this.shoveIntoMap(map, newDef[i]);
        }
        this.toDelete = null;
        for (i = 0; i < oldDef.length; ++i) {
            this.pullFromMap(map, oldDef[i]);
        }
        boolean insertsRequired = map.size() > 0;
        try {
            if (insertsRequired) {
                LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)1, (boolean)true);
                MutableInteger key = new MutableInteger();
                boolean anyBad = false;
                ExistenceChecker checker = new ExistenceChecker(this.dbc);
                for (NameList element : map.values()) {
                    key.value = element.nlInfo;
                    String[] tableInfo = (String[])existenceCheckTables.get(key);
                    if (tableInfo != null && checker.check(tableInfo[0], tableInfo[1], element.nlID)) continue;
                    anyBad = true;
                    element.nlState = (byte)(element.nlState | 2);
                }
                if (anyBad) {
                    Serializable[] responseData;
                    this.bad = null;
                    for (int i2 = 0; i2 < newDef.length; ++i2) {
                        this.purgeBad(newDef[i2]);
                    }
                    this.response.status = (short)76;
                    this.response.responseData = responseData = new Serializable[]{createHeader, this.bad};
                    Object[] args = new Object[]{objectTypeLabel, createHeader.creator, createHeader.getName()};
                    String s = MessageLog.getMessage((String)"SRV0097E", (Object[])args);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)NameListSaver.class.getName(), (String)"save");
                    }
                    throw new GeneralException(s);
                }
            }
            TResAttr accessor = null;
            if (insertsRequired) {
                accessor = new TResAttr(this.dbc);
                accessor.prepInsert(objectID, objectType);
                if (enforceSingleMembership) {
                    accessor.prepUpdate();
                }
                for (NameList element : map.values()) {
                    boolean exclude = (element.nlState & 1) != 0;
                    int rowsUpdated = 0;
                    if (enforceSingleMembership) {
                        rowsUpdated = accessor.update(element.nlID, objectID, objectType, exclude);
                    }
                    if (rowsUpdated == 0) {
                        accessor.insert(element.nlID, element.nlInfo, exclude);
                        continue;
                    }
                    this.resourceReassigned = true;
                }
                accessor.closeInsert();
                if (enforceSingleMembership) {
                    accessor.closeUpdate();
                }
            }
            if (this.toDelete != null) {
                if (accessor == null) {
                    accessor = new TResAttr(this.dbc);
                }
                accessor.prepDeleteByResAttr();
                while (this.toDelete != null) {
                    accessor.delete(objectID, this.toDelete.nlID);
                    this.toDelete = this.toDelete.nlNext;
                }
                accessor.closeDelete();
            }
            if (accessor == null) {
                accessor = new TResAttr(this.dbc);
            }
            accessor.commit();
        }
        finally {
            if (insertsRequired) {
                LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"save");
        }
    }

    public boolean wasResourceReassigned() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"wasResourceReassigned", (String)"");
        }
        boolean traceResult = this.resourceReassigned;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"wasResourceReassigned", (boolean)traceResult);
        }
        return traceResult;
    }

    private void shoveIntoMap(Map map, NameList head) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"shoveIntoMap", (String)"map, head");
        }
        while (head != null) {
            head.nlState = (byte)(head.nlState & 0xFFFFFFFD);
            IDTypeAndExclude key = new IDTypeAndExclude(head.nlID, head.nlInfo, (head.nlState & 1) != 0);
            map.put(key, head);
            head = head.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"shoveIntoMap");
        }
    }

    private void pullFromMap(Map map, NameList head) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"pullFromMap", (String)"map, head");
        }
        IDTypeAndExclude key = new IDTypeAndExclude(0, 0, false);
        while (head != null) {
            NameList next = head.nlNext;
            key.id = head.nlID;
            key.type = head.nlInfo;
            key.exclude = (head.nlState & 1) != 0;
            Object value = map.remove(key);
            if (value == null) {
                head.nlNext = this.toDelete;
                this.toDelete = head;
            }
            head = next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"pullFromMap");
        }
    }

    private NameList purgeBad(NameList element) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"purgeBad", (String)"element");
        }
        NameList result = null;
        NameList prev = null;
        while (element != null) {
            NameList next = element.nlNext;
            if ((element.nlState & 2) != 0) {
                element.nlState = (byte)(element.nlState & 0xFFFFFFFD);
                element.nlNext = this.bad;
                this.bad = element;
            } else {
                if (prev == null) {
                    result = element;
                } else {
                    prev.nlNext = element;
                }
                prev = element;
                element.nlNext = null;
            }
            element = next;
        }
        NameList traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"purgeBad", traceResult);
        }
        return traceResult;
    }

    public static boolean allObjectsSelected(TResAttr accessor, int ID, short attributeType, short resourceType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"allObjectsSelected", (String)"accessor, ID, attributeType, resourceType");
        }
        ResourceAttribute attr = new ResourceAttribute();
        attr.raAttributeID = ID;
        attr.raAttributeType = attributeType;
        attr.raResourceType = resourceType;
        accessor.prepQueryByAttr();
        accessor.setQueryByAttr(attr);
        boolean result = accessor.fetch(attr);
        accessor.closeSelect();
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"allObjectsSelected", (boolean)traceResult);
        }
        return traceResult;
    }

    public static boolean allObjectsSelected(TResAttr accessor, int ID, short attributeType) throws GeneralException {
        return NameListSaver.allObjectsSelected(accessor, ID, attributeType, (short)13);
    }

    public void saveAllObjectsSelected(boolean selected, int ID, short attributeType, short resourceType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"saveAllObjectsSelected", (String)"selected, ID, attributeType, resourceType");
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append(" WHERE attribute_id = ");
        buf.append(Integer.toString(ID));
        buf.append(" AND resource_type = ");
        buf.append(Short.toString(resourceType));
        StorageRepositoryAccessor deleter = new StorageRepositoryAccessor(this.dbc);
        deleter.delete("t_res_attribute", buf.toString(), false);
        deleter = null;
        buf = null;
        if (selected) {
            TResAttr accessor = new TResAttr(this.dbc);
            accessor.prepInsert(ID, attributeType);
            accessor.insert(-1, resourceType, false);
            accessor.closeInsert();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"saveAllObjectsSelected");
        }
    }

    public void saveAllObjectsSelected(boolean selected, int ID, short attributeType) throws GeneralException {
        this.saveAllObjectsSelected(selected, ID, attributeType, (short)13);
    }

    public void deleteObject(int attributeID, short attributeType, short resourceType, int resourceID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"deleteObject", (String)"selected, ID, attributeType, resourceType, resourceID");
        }
        try {
            StringBuffer buf = new StringBuffer(100);
            buf.append(" WHERE attribute_id = ");
            buf.append(Integer.toString(attributeID));
            buf.append(" AND resource_type = ");
            buf.append(Short.toString(resourceType));
            buf.append(" AND resource_id = ");
            buf.append(Integer.toString(resourceID));
            StorageRepositoryAccessor deleter = new StorageRepositoryAccessor(this.dbc);
            deleter.delete("t_res_attribute", buf.toString(), false);
            deleter = null;
            buf = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"deleteObject");
        }
    }

    public void saveAllObjectsSelected(boolean selected, int alertID, short attributeType, short resourceType, boolean keepIndividualEntries) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NameListSaver.class.getName(), (String)"saveAllObjectsSelected", (String)"selected, alertID, attributeType, resourceType, keepIndividualEntries");
        }
        if (!keepIndividualEntries) {
            this.saveAllObjectsSelected(selected, alertID, attributeType, resourceType);
            return;
        }
        if (selected) {
            TResAttr accessor = new TResAttr(this.dbc);
            accessor.prepInsert(alertID, attributeType);
            accessor.insert(-1, resourceType, false);
            accessor.closeInsert();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NameListSaver.class.getName(), (String)"saveAllObjectsSelected");
        }
    }

    private static class IDTypeAndExclude {
        public int id;
        public short type;
        public boolean exclude;

        public IDTypeAndExclude(int pID, short pType, boolean pExclude) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)IDTypeAndExclude.class.getName(), (String)"IDTypeAndExclude", (String)"pID, pType, pExclude");
            }
            this.id = pID;
            this.type = pType;
            this.exclude = pExclude;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)IDTypeAndExclude.class.getName(), (String)"IDTypeAndExclude");
            }
        }

        public int hashCode() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)IDTypeAndExclude.class.getName(), (String)"hashCode", (String)"");
            }
            int x = this.type;
            x &= 0xFFFF;
            x ^= this.id;
            if (this.exclude) {
                x ^= 0x10000;
            }
            int traceResult = x;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)IDTypeAndExclude.class.getName(), (String)"hashCode", (int)traceResult);
            }
            return traceResult;
        }

        public boolean equals(Object pOther) {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)IDTypeAndExclude.class.getName(), (String)"equals", (String)"pOther");
            }
            IDTypeAndExclude other = (IDTypeAndExclude)pOther;
            boolean bl = traceResult = this.id == other.id && this.type == other.type && this.exclude == other.exclude;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)IDTypeAndExclude.class.getName(), (String)"equals", (boolean)traceResult);
            }
            return traceResult;
        }
    }
}

