/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.ResourceFilter;

public class QueryBySchedule {
    RepositoryAccessor accessor;
    ResourceFilter filter;

    public QueryBySchedule(RepositoryAccessor accessor) {
        this(accessor, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)QueryBySchedule.class.getName(), (String)"QueryBySchedule", (String)"accessor");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)QueryBySchedule.class.getName(), (String)"QueryBySchedule");
        }
    }

    public QueryBySchedule(RepositoryAccessor accessor, ResourceFilter filter) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)QueryBySchedule.class.getName(), (String)"QueryBySchedule", (String)"accessor, filter");
        }
        this.accessor = accessor;
        this.filter = filter;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)QueryBySchedule.class.getName(), (String)"QueryBySchedule");
        }
    }

    public void init(String sqlText, int scheduleID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)QueryBySchedule.class.getName(), (String)"init", (String)"sqlText, scheduleID");
        }
        this.accessor.selectStmt = this.accessor.prepareStmt(sqlText);
        this.accessor.stmtPhase = 0;
        this.accessor.colIndex = 1;
        try {
            this.accessor.setInt(this.accessor.selectStmt, scheduleID);
            this.accessor.stmtPhase = 3;
            this.accessor.resultSet = this.accessor.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)QueryBySchedule.class.getName(), (String)"init", (Throwable)e);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)QueryBySchedule.class.getName(), (String)"init");
        }
    }

    public boolean fetch(NameList element) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)QueryBySchedule.class.getName(), (String)"fetch", (String)"element");
        }
        boolean traceResult = this.fetch(element, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)QueryBySchedule.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean fetch(NameList element, boolean thirdID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)QueryBySchedule.class.getName(), (String)"fetch", (String)"element, thirdID");
        }
        boolean going = false;
        try {
            do {
                if (!(going = this.accessor.nextResult())) {
                    this.accessor.closeResultSet();
                    this.accessor.closeSelect();
                    break;
                }
                this.accessor.stmtPhase = 1;
                this.accessor.colIndex = 1;
                element.nlID2 = this.accessor.getInt(this.accessor.resultSet);
                element.nlID = this.accessor.getInt(this.accessor.resultSet);
                if (thirdID) {
                    element.nlID3 = this.accessor.getInt(this.accessor.resultSet);
                }
                element.nlState = this.accessor.getBoolean(this.accessor.resultSet) ? (byte)1 : 0;
            } while (this.filter != null && !this.filter.accept(element));
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)QueryBySchedule.class.getName(), (String)"fetch", (Throwable)e);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(e);
        }
        boolean traceResult = going;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)QueryBySchedule.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }
}

