/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Rename;
import org.eclipse.aperi.common.TimestampedNameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class Renamer
extends RepositoryAccessor {
    private String idColumnName;
    private String objectType;
    private StringBuffer buf;

    public Renamer(Connection dbc, String pTableName, String pIDColumnName, String pObjectType) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Renamer.class.getName(), (String)"Renamer", (String)"dbc, pTableName, pIDColumnName, pObjectType");
        }
        this.tableName = pTableName;
        this.idColumnName = pIDColumnName;
        this.objectType = pObjectType;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Renamer.class.getName(), (String)"Renamer");
        }
    }

    private String buildCombinedName(String creator, String name) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Renamer.class.getName(), (String)"buildCombinedName", (String)"creator, name");
        }
        this.buf.setLength(0);
        this.buf.append(creator);
        this.buf.append('.');
        this.buf.append(name);
        String traceResult = this.buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Renamer.class.getName(), (String)"buildCombinedName", (Object)traceResult);
        }
        return traceResult;
    }

    public TimestampedNameList rename(Rename obj, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Renamer.class.getName(), (String)"rename", (String)"obj, commit");
        }
        long now = 0L;
        try {
            now = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Renamer.class.getName(), (String)"rename", (Throwable)e);
            }
            return null;
        }
        this.buf = new StringBuffer(160);
        this.buf.append("UPDATE ");
        this.buf.append(this.tableName);
        this.buf.append(" SET name = ?, last_modified = ");
        this.buf.append(Long.toString(now));
        this.buf.append(", last_mod_user = '");
        this.buf.append(obj.rnModifyingUser);
        this.buf.append("' WHERE ");
        this.buf.append(this.idColumnName);
        this.buf.append(" = ");
        this.buf.append(Integer.toString(obj.rnID));
        this.updateStmt = this.prepareStmt(this.buf.toString());
        int rowsAffected = 0;
        try {
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setString(this.updateStmt, obj.rnNewName);
            rowsAffected = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)Renamer.class.getName(), (String)"rename", (Throwable)e);
            }
            if (!SQLUtil.isDuplicateKeyViolation(e)) {
                this.sqlError(e);
            }
            String s = this.buildCombinedName(obj.rnCreator, obj.rnNewName);
            Object[] args = new Object[]{this.objectType, s};
            s = MessageLog.getMessage((String)"SRV0096E", (Object[])args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Renamer.class.getName(), (String)"rename");
            }
            throw new GeneralException(s);
        }
        this.closeUpdate();
        if (rowsAffected == 0) {
            block15: {
                try {
                    this.dbc.rollback();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception((String)Renamer.class.getName(), (String)"rename", (Throwable)ignored);
                }
            }
            String s = this.buildCombinedName(obj.rnCreator, obj.rnOldName);
            Object[] args = new Object[]{this.objectType, s};
            s = MessageLog.getMessage((String)"SRV0095E", (Object[])args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Renamer.class.getName(), (String)"rename");
            }
            throw new GeneralException(s);
        }
        if (commit) {
            this.commit();
        }
        TimestampedNameList result = new TimestampedNameList();
        result.nlName = this.buildCombinedName(obj.rnCreator, obj.rnNewName);
        result.nlID = obj.rnID;
        result.tnlTimestamp = now;
        TimestampedNameList traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Renamer.class.getName(), (String)"rename", (Object)traceResult);
        }
        return traceResult;
    }
}

