/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingGroupMemberList {
    Connection connection = null;

    public ReportingGroupMemberList(Connection con) {
        this.connection = con;
    }

    public NameList getMatchedResources(GuiListReq glr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportingGroupMemberList.class.getName(), (String)"getMatchedResources", (String)"glr");
        }
        NameList requestList = (NameList)glr.qualifierObject;
        Hashtable<Integer, NameList> resultHT = new Hashtable<Integer, NameList>();
        if (requestList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ReportingGroupMemberList.class.getName(), (String)"getMatchedResources");
            }
            throw new GeneralException("glr.qualifierObject is null");
        }
        boolean isTbspGroup = this.checkGroupType(requestList);
        NameList resultNL = null;
        NameList temp = requestList;
        do {
            if (temp.nlInfo == 1 || temp.nlInfo == 3) {
                if (!isTbspGroup) {
                    resultNL = temp;
                }
            } else if (temp.nlInfo == 95 || temp.nlInfo == 96) {
                TGroup2Mask accessor = new TGroup2Mask(this.connection);
                resultNL = accessor.getMatchingResources(temp.nlInfo, temp.nlName);
            } else if (temp.nlInfo == 0 || temp.nlInfo == 89 || temp.nlInfo == 2 || temp.nlInfo == 90) {
                TGroup2Res tg2r = new TGroup2Res(this.connection);
                resultNL = tg2r.getMemberList(temp.nlID, temp.nlInfo);
            } else {
                resultNL = null;
            }
            if (resultNL == null) continue;
            NameList tempNL = resultNL;
            do {
                resultHT.put(new Integer(tempNL.nlID), tempNL);
            } while ((tempNL = tempNL.nlNext) != null);
        } while ((temp = temp.nlNext) != null);
        NameList head = null;
        NameList element = null;
        ArrayList<NameList> nameArrayList = null;
        if (!resultHT.isEmpty()) {
            nameArrayList = new ArrayList<NameList>();
            Enumeration keys = resultHT.keys();
            while (keys.hasMoreElements()) {
                element = (NameList)resultHT.get(keys.nextElement());
                nameArrayList.add(element);
            }
            Object[] nameListArray = nameArrayList.toArray();
            Arrays.sort(nameListArray);
            for (int i = 0; i < nameListArray.length; ++i) {
                element = new NameList();
                element = (NameList)nameListArray[i];
                element.nlNext = head;
                head = element;
            }
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportingGroupMemberList.class.getName(), (String)"getMatchedResources", traceResult);
        }
        return traceResult;
    }

    private boolean checkGroupType(NameList requestList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ReportingGroupMemberList.class.getName(), (String)"checkGroupType", (String)"requestList");
        }
        boolean isTbspGroup = false;
        NameList tempList = requestList;
        String dbRoot = MessageLog.getMessageNoID((String)"DBG0518L");
        while (tempList != null) {
            if (dbRoot.compareTo(tempList.nlName) == 0) {
                isTbspGroup = true;
                tempList = null;
                continue;
            }
            tempList = tempList.nlNext;
        }
        boolean traceResult = isTbspGroup;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ReportingGroupMemberList.class.getName(), (String)"checkGroupType", (boolean)traceResult);
        }
        return traceResult;
    }
}

