/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class RepositoryAccessor {
    protected PreparedStatement selectStmt;
    protected PreparedStatement deleteStmt;
    protected PreparedStatement insertStmt;
    protected PreparedStatement updateStmt;
    protected Statement staticStmt;
    protected Connection dbc;
    protected ResultSet resultSet;
    protected String tableName;
    protected boolean inCleanUp;
    protected int stmtType;
    protected int stmtPhase;
    protected int colIndex;
    protected Timestamp timestamp = new Timestamp(0L);
    protected boolean logSQLErrors = true;
    private Statement commitStmt;
    private String selectSQL;
    private String deleteSQL;
    private String insertSQL;
    private String updateSQL;
    protected static final int SELECT_STMT = 0;
    protected static final int INSERT_STMT = 1;
    protected static final int UPDATE_STMT = 2;
    protected static final int DELETE_STMT = 3;
    protected static final int SET_PHASE = 0;
    protected static final int GET_PHASE = 1;
    protected static final int FETCH_PHASE = 2;
    protected static final int EXECUTE_PHASE = 3;
    protected static final int COMMIT_PHASE = 4;
    protected static final String[] STMT_TYPE = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE"};
    protected static final String[] PHASE_TYPE = new String[]{"SET", "GET", "FETCH", "EXECUTE", "COMMIT"};

    protected RepositoryAccessor(Connection dbc) {
        this.dbc = dbc;
    }

    protected Statement createStatement() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"createStatement", (String)"");
        }
        try {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"createStatement");
            }
            return this.dbc.createStatement();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"createStatement", (Throwable)e);
            }
            this.cleanup();
            throw SQLUtil.getGeneralException("SRV0155E", e, null);
        }
    }

    protected PreparedStatement prepareStmt(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"prepareStmt", (String)"sqlText");
        }
        this.setSQLText(sqlText);
        try {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"prepareStmt");
            }
            return this.dbc.prepareStatement(sqlText);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"prepareStmt", (Throwable)e);
            }
            Object[] args = new Object[]{sqlText.substring(0, 6), this.tableName};
            this.cleanup();
            throw SQLUtil.getGeneralException("SRV0078E", e, args);
        }
    }

    protected void setSQLText(String sqlText) {
        switch (sqlText.charAt(0)) {
            case 'S': 
            case 's': {
                this.selectSQL = sqlText;
                this.stmtType = 0;
                break;
            }
            case 'I': 
            case 'i': {
                this.insertSQL = sqlText;
                this.stmtType = 1;
                break;
            }
            case 'U': 
            case 'u': {
                this.updateSQL = sqlText;
                this.stmtType = 2;
                break;
            }
            case 'D': 
            case 'd': {
                this.deleteSQL = sqlText;
                this.stmtType = 3;
            }
        }
    }

    public void execQueryByID(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"execQueryByID", (String)"id");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"execQueryByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"execQueryByID");
        }
    }

    protected int executeUpdate(PreparedStatement stmt) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"executeUpdate", (String)"stmt");
        }
        this.stmtPhase = 3;
        int traceResult = stmt.executeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"executeUpdate", (int)traceResult);
        }
        return traceResult;
    }

    protected boolean nextResult() throws GeneralException {
        return this.nextResult(this.resultSet);
    }

    protected boolean nextResult(ResultSet result) throws GeneralException {
        try {
            return result.next();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"nextResult", (Throwable)e);
            }
            this.stmtType = 0;
            this.stmtPhase = 2;
            this.sqlError(e);
            return false;
        }
    }

    protected void setPhase() {
        this.stmtPhase = 0;
        this.colIndex = 1;
    }

    protected void getPhase() {
        this.stmtPhase = 1;
        this.colIndex = 1;
    }

    protected void setBoolean(PreparedStatement stmt, boolean value) throws SQLException {
        if (SQLUtil.isCloudscape()) {
            SQLUtil.setBoolean(stmt, this.colIndex++, value);
        } else {
            stmt.setBoolean(this.colIndex++, value);
        }
    }

    protected void setByte(PreparedStatement stmt, byte value) throws SQLException {
        if (SQLUtil.isSybase()) {
            short i = value;
            String s = String.valueOf(i);
            stmt.setString(this.colIndex++, s);
            return;
        }
        stmt.setByte(this.colIndex++, value);
    }

    protected void setBytes(PreparedStatement stmt, byte[] value) throws SQLException {
        stmt.setBytes(this.colIndex++, value);
    }

    protected void setShort(PreparedStatement stmt, short value) throws SQLException {
        stmt.setShort(this.colIndex++, value);
    }

    protected void setInt(PreparedStatement stmt, int value) throws SQLException {
        stmt.setInt(this.colIndex++, value);
    }

    protected void setLong(PreparedStatement stmt, long value) throws SQLException {
        stmt.setLong(this.colIndex++, value);
    }

    protected void setDouble(PreparedStatement stmt, double value) throws SQLException {
        stmt.setDouble(this.colIndex++, value);
    }

    private static long discardMillis(long value) {
        long remainder = value % 1000L;
        return value - remainder;
    }

    protected void setTimestamp(PreparedStatement stmt, long value) throws SQLException {
        this.timestamp.setTime(RepositoryAccessor.discardMillis(value));
        stmt.setTimestamp(this.colIndex++, this.timestamp);
    }

    protected void setTimestamp(PreparedStatement stmt, long value, Timestamp ts) throws SQLException {
        ts.setTime(RepositoryAccessor.discardMillis(value));
        stmt.setTimestamp(this.colIndex++, ts);
    }

    protected void setString(PreparedStatement stmt, String value) throws SQLException {
        if (value == null || value.length() == 0) {
            value = " ";
        }
        stmt.setString(this.colIndex++, value);
    }

    protected boolean getBoolean(ResultSet rs) throws SQLException {
        return SQLUtil.getBoolean(rs, this.colIndex++);
    }

    protected byte getByte(ResultSet rs) throws SQLException {
        if (SQLUtil.isSybase()) {
            String s = this.getString(rs);
            return (byte)Integer.parseInt(s);
        }
        return rs.getByte(this.colIndex++);
    }

    protected byte[] getBytes(ResultSet rs) throws SQLException {
        return rs.getBytes(this.colIndex++);
    }

    protected short getShort(ResultSet rs) throws SQLException {
        return rs.getShort(this.colIndex++);
    }

    protected int getInt(ResultSet rs) throws SQLException {
        return rs.getInt(this.colIndex++);
    }

    protected long getLong(ResultSet rs) throws SQLException {
        return rs.getLong(this.colIndex++);
    }

    protected double getDouble(ResultSet rs) throws SQLException {
        return rs.getDouble(this.colIndex++);
    }

    protected long getTimestamp(ResultSet rs) throws SQLException {
        Timestamp ts;
        return (ts = rs.getTimestamp(this.colIndex++)) == null ? 0L : ts.getTime();
    }

    protected String getString(ResultSet rs) throws SQLException {
        return rs.getString(this.colIndex++);
    }

    protected String getTypeString(ResultSet rs) {
        String str = FabricGuiUtil.getString((String)"FabricDetails_Unknown");
        try {
            switch (this.getInt(rs)) {
                case 0: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_switch");
                    break;
                }
                case 1: {
                    str = FabricGuiUtil.getPortTypeString((int)this.getInt(rs));
                    break;
                }
                case 2: {
                    str = FabricGuiUtil.getNodeTypeString((int)this.getInt(rs));
                    break;
                }
                case 3: {
                    str = FabricGuiUtil.getPeTypeString((int)this.getInt(rs));
                    break;
                }
                case 4: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_Blade");
                    break;
                }
                case 5: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_tape");
                    break;
                }
                case 6: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_MediaChangers");
                    break;
                }
                case 7: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_HBA");
                    break;
                }
                case 8: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_host");
                    break;
                }
                case 9: {
                    this.getInt(rs);
                    str = FabricGuiUtil.getString((String)"FabricDetails_StorageSubsystem");
                }
            }
            return str;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"getTypeString", (Throwable)e);
            }
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet() throws GeneralException {
        if (this.resultSet != null) {
            try {
                this.closeResultSet(this.resultSet);
            }
            finally {
                this.resultSet = null;
            }
        }
    }

    public void closeResultSet(ResultSet rs) throws GeneralException {
        block4: {
            try {
                rs.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"closeResultSet", (Throwable)e);
                }
                if (this.inCleanUp) break block4;
                Object[] args = new Object[]{this.tableName};
                this.cleanup();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"closeResultSet");
                }
                throw SQLUtil.getGeneralException("SRV0079E", e, args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSelect() throws GeneralException {
        this.selectSQL = null;
        if (this.selectStmt != null) {
            try {
                this.closeStmt(this.selectStmt, STMT_TYPE[0]);
            }
            finally {
                this.selectStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDelete() throws GeneralException {
        this.deleteSQL = null;
        if (this.deleteStmt != null) {
            try {
                this.closeStmt(this.deleteStmt, STMT_TYPE[3]);
            }
            finally {
                this.deleteStmt = null;
                this.closeCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUpdate() throws GeneralException {
        this.updateSQL = null;
        if (this.updateStmt != null) {
            try {
                this.closeStmt(this.updateStmt, STMT_TYPE[2]);
            }
            finally {
                this.updateStmt = null;
                this.closeCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInsert() throws GeneralException {
        this.insertSQL = null;
        if (this.insertStmt != null) {
            try {
                this.closeStmt(this.insertStmt, STMT_TYPE[1]);
            }
            finally {
                this.insertStmt = null;
                this.closeCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStaticStmt() throws GeneralException {
        if (this.staticStmt != null) {
            try {
                this.closeStmt(this.staticStmt, STMT_TYPE[0]);
            }
            finally {
                this.staticStmt = null;
                this.closeCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCommit() throws GeneralException {
        if (this.commitStmt != null) {
            try {
                this.closeStmt(this.commitStmt, PHASE_TYPE[4]);
            }
            finally {
                this.commitStmt = null;
            }
        }
    }

    protected void closeStmt(Statement stmt, String stmtType) throws GeneralException {
        block4: {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"closeStmt", (Throwable)e);
                }
                if (this.inCleanUp) break block4;
                Object[] args = new Object[]{this.tableName, stmtType};
                this.cleanup();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"closeStmt");
                }
                throw SQLUtil.getGeneralException("SRV0080E", e, args);
            }
        }
    }

    public void commit() throws GeneralException {
        try {
            this.dbc.commit();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"commit");
            }
            return;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"commit", (Throwable)e);
            }
            this.stmtPhase = 4;
            this.sqlError(e);
            return;
        }
    }

    public void cleanup() {
        block5: {
            block4: {
                this.inCleanUp = true;
                try {
                    this.dbc.rollback();
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block4;
                    TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"cleanup", (Throwable)e);
                }
            }
            try {
                this.closeSelect();
                this.closeUpdate();
                this.closeDelete();
                this.closeInsert();
                this.closeStaticStmt();
            }
            catch (GeneralException e) {
                if (!TraceLogger.enableTrace) break block5;
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"cleanup", (Throwable)e);
            }
        }
        this.inCleanUp = false;
    }

    protected void sqlError(SQLException e) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"sqlError", (String)"e");
        }
        if (this.logSQLErrors) {
            PrintWriter out = MessageLog.getThreadLog();
            String sqlText = null;
            switch (this.stmtType) {
                case 0: {
                    sqlText = this.selectSQL;
                    break;
                }
                case 1: {
                    sqlText = this.insertSQL;
                    break;
                }
                case 2: {
                    sqlText = this.updateSQL;
                    break;
                }
                case 3: {
                    sqlText = this.deleteSQL;
                }
            }
            if (sqlText != null) {
                StringBuffer buffer = new StringBuffer(sqlText.length() + 10);
                for (int i = 0; i < sqlText.length(); ++i) {
                    buffer.append(sqlText.charAt(i));
                    if (i <= 0 || i % 78 != 0) continue;
                    buffer.append("\\\n");
                }
                MessageLog.logMessage((String)"STS0146E", (Object)STMT_TYPE[this.stmtType], (Object)buffer.toString());
            }
            e.printStackTrace(out);
        }
        this.cleanup();
        Object[] args = new Object[]{this.tableName, STMT_TYPE[this.stmtType], PHASE_TYPE[this.stmtPhase]};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"sqlError");
        }
        throw SQLUtil.getGeneralException("SRV0081E", e, args);
    }

    protected void selectError(SQLException e) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"selectError", (String)"e");
        }
        this.cleanup();
        Object[] args = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"selectError");
        }
        throw SQLUtil.getGeneralException("SRV0082E", e, args);
    }

    protected void insertError(SQLException e) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"insertError", (String)"e");
        }
        this.cleanup();
        Object[] args = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"insertError");
        }
        throw SQLUtil.getGeneralException("SRV0083E", e, args);
    }

    protected void updateError(SQLException e) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"updateError", (String)"e");
        }
        this.cleanup();
        Object[] args = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"updateError");
        }
        throw SQLUtil.getGeneralException("SRV0084E", e, args);
    }

    protected void deleteError(SQLException e) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RepositoryAccessor.class.getName(), (String)"deleteError", (String)"e");
        }
        this.cleanup();
        Object[] args = new Object[]{this.tableName};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RepositoryAccessor.class.getName(), (String)"deleteError");
        }
        throw SQLUtil.getGeneralException("SRV0085E", e, args);
    }

    public static RepositoryAccessor newAccessor(String className, Connection dbc) {
        try {
            Class<?> clazz = Class.forName(className);
            Class[] argdef = new Class[]{Connection.class};
            Constructor<?> constr = clazz.getConstructor(argdef);
            Object[] args = new Object[]{dbc};
            return (RepositoryAccessor)constr.newInstance(args);
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RepositoryAccessor.class.getName(), (String)"newAccessor", (Throwable)e);
            }
            e.printStackTrace();
            MessageLog.logException((String)"STS0161E", (Exception)e, (Object)className);
            return null;
        }
    }
}

