/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SQLUtil {
    public static final int RESOURCE_ID = 1;
    public static final int RUN_NUMBER_ID = 2;
    public static final int SCHEDULE_ID = 3;
    public static final int JOB_ID = 4;
    public static final int CALENDAR_ID = 5;
    public static final int ALERT_LOG_ID = 6;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE = 4;
    public static final int NOOP = 8;
    public static final int ERROR = 16;
    public static final int ROW_NOT_FOUND = 100;
    public static final String SQLSTATE_ROW_NOT_FOUND = "2000";
    public static final byte UNKNOWN = 0;
    public static final byte ORACLE = 1;
    public static final byte MSSQL = 2;
    public static final byte INTERBASE = 3;
    public static final byte SYBASE = 4;
    public static final byte DB2_UDB = 5;
    public static final byte CLOUDSCAPE = 6;
    public static final byte DERBY = 7;
    public static byte repositoryType;
    public static boolean inetDriver;
    public static boolean sortOrderNotASCII;
    private static final int MAX_ORACLE_IN = 999;
    private static String mssqlSortOrderQuery;
    private static final String UPDATE_IDENTIFIER_SQL = "update t_identifier set identifier = identifier + ? where id_type = ?";
    private static final String SELECT_IDENTIFIER_SQL = "select identifier from t_identifier where id_type = ?";
    private static final int[] BINARY_SORT_ORDERS;
    private static Class[] SH_INT_PARAM;
    private static Object[] SH_ZERO_ARG;
    private static Object[] SH_ONE_ARG;

    public static void logSQLException(String msgID, SQLException e, Object[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"logSQLException", (String)"msgID, e, args");
        }
        String msgString = SQLUtil.getSQLExceptionMsg(msgID, e, args);
        MessageLog.getThreadLog().println(msgString);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"logSQLException");
        }
    }

    public static String getSQLExceptionMsg(String msgID, SQLException e, Object[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"getSQLExceptionMsg", (String)"msgID, e, args");
        }
        StringBuffer result = new StringBuffer(320);
        result.append(MessageLog.getMessage((String)msgID, (Object[])args));
        result.append('\n');
        result.append("                         ");
        SQLUtil.appendSQLException(e, result);
        String traceResult = result.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getSQLExceptionMsg", (Object)traceResult);
        }
        return traceResult;
    }

    public static void appendInClause(StringBuffer buffer, String colName, int[] idArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendInClause", (String)"buffer, colName, idArray");
        }
        SQLUtil.appendInClause(buffer, colName, idArray, true, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendInClause");
        }
    }

    public static void appendInClause(StringBuffer buffer, String colName, int[] idArray, boolean isInList, boolean appendAnd) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendInClause", (String)"buffer, colName, idArray, isInList, appendAnd");
        }
        SQLUtil.appendInClause(buffer, colName, idArray, isInList, appendAnd, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendInClause");
        }
    }

    public static void appendInClause(StringBuffer buffer, String colName, int[] idArray, boolean isInList, boolean appendAnd, boolean quoteIt) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendInClause", (String)"buffer, colName, idArray, isInList, appendAnd, quoteIt");
        }
        if (idArray != null && idArray.length > 0) {
            if (appendAnd) {
                buffer.append(" and");
            }
            buffer.append(' ');
            if (!isInList) {
                buffer.append("not ");
            }
            buffer.append('(');
            if (idArray.length < 999 || !SQLUtil.isOracle()) {
                SQLUtil.appendPiece(buffer, colName, idArray, 0, idArray.length, quoteIt);
            } else {
                int start = 0;
                while (start < idArray.length) {
                    int end;
                    if (start > 0) {
                        buffer.append(" or ");
                    }
                    if ((end = start + 999) > idArray.length) {
                        end = idArray.length;
                    }
                    SQLUtil.appendPiece(buffer, colName, idArray, start, end, quoteIt);
                    start = end;
                }
            }
            buffer.append(')');
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendInClause");
        }
    }

    private static void appendPiece(StringBuffer buffer, String colName, int[] idArray, int start, int end, boolean quoteIt) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendPiece", (String)"buffer, colName, idArray, start, end, quoteIt");
        }
        buffer.append(colName);
        buffer.append(" in (");
        int i = end;
        while (i > start) {
            --i;
            if (quoteIt) {
                buffer.append("'");
            }
            buffer.append(idArray[i]);
            if (quoteIt) {
                buffer.append("'");
            }
            buffer.append(',');
        }
        buffer.setLength(buffer.length() - 1);
        buffer.append(')');
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendPiece");
        }
    }

    public static void appendInClause(StringBuffer buf, HasID element) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendInClause", (String)"buf, element");
        }
        buf.append(" in ");
        int c = 40;
        while (element != null) {
            buf.append((char)c);
            buf.append(element.getID());
            c = 44;
            element = (HasID)element.getNext();
        }
        buf.append(')');
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendInClause");
        }
    }

    public static boolean getBoolean(ResultSet rs, int colIndex) throws SQLException {
        return rs.getByte(colIndex) % 2 == 1;
    }

    public static void setBoolean(PreparedStatement pStmt, int colIndex, boolean value) throws SQLException {
        SQLUtil.setByte(pStmt, colIndex, value ? (byte)1 : 0);
    }

    public static boolean isNullString(String s) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"isNullString", (String)"s");
        }
        boolean bl = traceResult = s == null || s.length() == 0 || s.length() == 1 && s.charAt(0) == ' ';
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"isNullString", (boolean)traceResult);
        }
        return traceResult;
    }

    public static void setByte(PreparedStatement prep, int i, byte value) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"setByte", (String)"prep, i, value");
        }
        if (repositoryType == 4) {
            short si = value;
            String s = String.valueOf(si);
            prep.setString(i, s);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setByte");
            }
            return;
        }
        prep.setByte(i, value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setByte");
        }
    }

    public static byte getByte(ResultSet rs, int i) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"getByte", (String)"rs, i");
        }
        if (repositoryType == 4) {
            String s = rs.getString(i);
            byte traceResult = (byte)Integer.parseInt(s);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getByte", (byte)traceResult);
            }
            return traceResult;
        }
        byte traceResult = rs.getByte(i);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getByte", (byte)traceResult);
        }
        return traceResult;
    }

    public static void setBytes(PreparedStatement prep, int i, byte[] value) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"setBytes", (String)"prep, i, value");
        }
        if (repositoryType == 4) {
            byte[] byteme = new byte[value.length + 1];
            System.arraycopy(value, 0, byteme, 0, value.length);
            byteme[value.length] = 1;
            prep.setBytes(i, byteme);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setBytes");
            }
            return;
        }
        prep.setBytes(i, value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setBytes");
        }
    }

    public static byte[] getBytes(ResultSet rs, int i) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"getBytes", (String)"rs, i");
        }
        byte[] b1 = rs.getBytes(i);
        if (repositoryType == 4 && b1.length > 1 && b1[b1.length - 1] == 1) {
            byte[] b2 = new byte[b1.length - 1];
            System.arraycopy(b1, 0, b2, 0, b1.length - 1);
            byte[] traceResult = b2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getBytes", (Object)traceResult);
            }
            return traceResult;
        }
        byte[] traceResult = b1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getBytes", (Object)traceResult);
        }
        return traceResult;
    }

    public static boolean isDuplicateKeyViolation(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.length() == 5 && sqlState.charAt(0) == '2' && sqlState.charAt(1) == '3';
    }

    public static boolean isRowNotFound(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.equals(SQLSTATE_ROW_NOT_FOUND);
    }

    public static boolean isDeadlock(SQLException e) {
        int errorCode = e.getErrorCode();
        String sqlState = e.getSQLState();
        return repositoryType == 2 && errorCode == 1205 || repositoryType == 7 && sqlState != null && sqlState.equals("40001") || repositoryType == 5 && errorCode == -911 || repositoryType == 1 && errorCode == 60;
    }

    public static String generateAliasedDelete(String tableName, String alias) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"generateAliasedDelete", (String)"tableName, alias");
        }
        StringBuffer buf = new StringBuffer(80);
        buf.append("DELETE ");
        if (repositoryType == 2 || repositoryType == 4) {
            buf.append(tableName);
            buf.append(" FROM ");
            buf.append(tableName);
            buf.append(" AS ");
        } else {
            buf.append("FROM ");
            buf.append(tableName);
            buf.append(' ');
        }
        buf.append(alias);
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"generateAliasedDelete", (Object)traceResult);
        }
        return traceResult;
    }

    public static byte[] makeCaseBitmask(String s) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"makeCaseBitmask", (String)"s");
        }
        int length = s.length();
        byte[] result = new byte[length + 7 >> 3];
        int bix = -1;
        int mask = 0;
        for (int i = 0; i < length; ++i) {
            if ((i & 7) != 0) {
                mask = (byte)(mask << 1);
            } else {
                mask = 1;
                ++bix;
            }
            if (!Character.isUpperCase(s.charAt(i))) continue;
            int n = bix;
            result[n] = (byte)(result[n] | mask);
        }
        byte[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"makeCaseBitmask", (Object)traceResult);
        }
        return traceResult;
    }

    public static void errorCleanup(Connection dbConnection, Statement stmt) {
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)SQLUtil.class.getName(), (String)"errorCleanup", (String)"dbConnection, stmt");
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (dbConnection != null) {
                    dbConnection.rollback();
                }
            }
            catch (SQLException x) {
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exception((String)SQLUtil.class.getName(), (String)"errorCleanup", (Throwable)x);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"errorCleanup");
        }
    }

    public static short closeResources(ResultSet rs) {
        short result = 0;
        if (rs != null) {
            try {
                rs.getStatement().close();
                rs.close();
            }
            catch (SQLException sqle) {
                result = 1;
            }
        }
        return result;
    }

    public static int getIdentifier(int idType, int idCount, Connection dbConnection) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"getIdentifier", (String)"idType, idCount, dbConnection");
        }
        Statement select = null;
        PreparedStatement update = null;
        int deadlockRetries = 3;
        while (true) {
            try {
                if (update == null) {
                    update = dbConnection.prepareStatement(UPDATE_IDENTIFIER_SQL);
                }
                update.setInt(1, idCount);
                update.setInt(2, idType);
                int rowCount = update.executeUpdate();
                if (rowCount <= 0) {
                    MessageLog.logMessage((String)"GEN0102E", (Object)new Integer(idType));
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getIdentifier");
                    }
                    throw new SQLException();
                }
                if (select == null) {
                    select = dbConnection.prepareStatement(SELECT_IDENTIFIER_SQL);
                }
                select.setInt(1, idType);
                ResultSet rs = select.executeQuery();
                rs.next();
                int identifier = rs.getInt(1);
                dbConnection.commit();
                select.close();
                update.close();
                int traceResult = identifier - idCount;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getIdentifier", (int)traceResult);
                }
                return traceResult;
            }
            catch (SQLException e) {
                block18: {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)SQLUtil.class.getName(), (String)"getIdentifier", (Throwable)e);
                    }
                    if (SQLUtil.isDeadlock(e) && --deadlockRetries >= 0) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                            break block18;
                        }
                        continue;
                    }
                }
                try {
                    if (select != null) {
                        select.close();
                    }
                    if (update != null) {
                        update.close();
                    }
                }
                catch (SQLException x) {
                    // empty catch block
                }
                SQLUtil.logSQLException("GEN0103E", e, new Object[]{new Integer(idType)});
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getIdentifier");
                }
                throw e;
            }
            break;
        }
    }

    public static void parseSortOrderRow(String row) throws IOException {
        int tokenType;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"parseSortOrderRow", (String)"row");
        }
        StringReader reader = new StringReader(row);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 60);
        tokenizer.wordChars(62, Integer.MAX_VALUE);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(false);
        tokenizer.slashStarComments(false);
        tokenizer.slashSlashComments(false);
        tokenizer.lowerCaseMode(false);
        boolean inValue = false;
        String key = null;
        boolean found = false;
        while (!found && (tokenType = tokenizer.nextToken()) != -1) {
            if (tokenType != -3) {
                if (key == null) continue;
                inValue = true;
                continue;
            }
            if (!inValue) {
                key = tokenizer.sval;
                continue;
            }
            if (key.equals("sort_order_num")) {
                found = true;
                continue;
            }
            key = null;
            inValue = false;
        }
        if (found) {
            int value;
            block10: {
                value = -1;
                try {
                    value = Integer.parseInt(tokenizer.sval);
                }
                catch (NumberFormatException ignored) {
                    if (!TraceLogger.enableTrace) break block10;
                    TraceLogger.exception((String)SQLUtil.class.getName(), (String)"parseSortOrderRow", (Throwable)ignored);
                }
            }
            int index = Arrays.binarySearch(BINARY_SORT_ORDERS, value);
            if (index >= 0) {
                sortOrderNotASCII = false;
            }
        }
        ((Reader)reader).close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"parseSortOrderRow");
        }
    }

    public static void handleMSSQL(Connection dbc) {
        Statement statement;
        block26: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)SQLUtil.class.getName(), (String)"handleMSSQL", (String)"dbc");
            }
            sortOrderNotASCII = true;
            statement = null;
            try {
                statement = dbc.createStatement();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)e);
                }
                MessageLog.logException((String)"SRV0131E", (Exception)e);
            }
            if (statement == null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)SQLUtil.class.getName(), (String)"handleMSSQL");
                }
                return;
            }
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery(mssqlSortOrderQuery);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)e);
                }
                MessageLog.logException((String)"SRV0132E", (Exception)e);
            }
            if (resultSet != null) {
                boolean succeeded = false;
                boolean rowExists = false;
                try {
                    rowExists = resultSet.next();
                    succeeded = true;
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)e);
                    }
                    MessageLog.logException((String)"SRV0135E", (Exception)e);
                }
                if (!rowExists) {
                    if (succeeded) {
                        MessageLog.logMessage((String)"SRV0134E");
                    }
                } else {
                    String row = null;
                    try {
                        row = resultSet.getString(1);
                    }
                    catch (SQLException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)e);
                        }
                        MessageLog.logException((String)"SRV0136E", (Exception)e);
                    }
                    if (row != null) {
                        try {
                            SQLUtil.parseSortOrderRow(row);
                        }
                        catch (IOException impossible) {
                            if (!TraceLogger.enableTrace) break block26;
                            TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)impossible);
                        }
                    }
                }
            }
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SQLUtil.class.getName(), (String)"handleMSSQL", (Throwable)e);
            }
            MessageLog.logException((String)"SRV0133E", (Exception)e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"handleMSSQL");
        }
    }

    public static void setRepositoryType(String jdbcDriver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"setRepositoryType", (String)"jdbcDriver");
        }
        if (jdbcDriver.startsWith("oracle")) {
            repositoryType = 1;
        } else if (jdbcDriver.startsWith("com.inet.") || jdbcDriver.startsWith("com.microsoft.") || jdbcDriver.startsWith("com.ddtek.")) {
            repositoryType = (byte)2;
        } else if (jdbcDriver.startsWith("org.apache.derby")) {
            repositoryType = (byte)7;
        } else if (jdbcDriver.startsWith("interbase")) {
            repositoryType = (byte)3;
        } else if (jdbcDriver.startsWith("com.sybase.")) {
            repositoryType = (byte)4;
        } else if (jdbcDriver.startsWith("com.ibm.db2.jcc.DB2Driver") || jdbcDriver.startsWith("COM.ibm")) {
            repositoryType = (byte)5;
        } else if (jdbcDriver.startsWith("com.ibm.db2j")) {
            repositoryType = (byte)6;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setRepositoryType");
        }
    }

    public static boolean isMSSQL() {
        return repositoryType == 2;
    }

    public static boolean isINET(String jdbcDriver) {
        inetDriver = jdbcDriver.startsWith("com.inet.");
        return inetDriver;
    }

    public static boolean isInterBase() {
        return repositoryType == 3;
    }

    public static boolean isOracle() {
        return repositoryType == 1;
    }

    public static boolean isSybase() {
        return repositoryType == 4;
    }

    public static boolean isUDB() {
        return repositoryType == 5;
    }

    public static boolean isCloudscape() {
        return repositoryType == 6;
    }

    public static boolean isDerby() {
        return repositoryType == 7;
    }

    public static boolean mightBeCaseInsensitive() {
        return repositoryType == 2 || repositoryType == 4;
    }

    private static void appendSQLException(SQLException e, StringBuffer result) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"appendSQLException", (String)"e, result");
        }
        while (e != null) {
            String sqlState = e.getSQLState();
            if (sqlState == null) {
                sqlState = "";
            }
            result.append("SQLSTATE: ");
            result.append(sqlState);
            result.append(", Vendor error code: ");
            result.append(e.getErrorCode());
            result.append('\n');
            String eMsg = e.getMessage();
            if (eMsg != null) {
                result.append("                         ");
                result.append(eMsg);
                result.append('\n');
            }
            e = e.getNextException();
        }
        if (result.charAt(result.length() - 1) == '\n') {
            result.setLength(result.length() - 1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"appendSQLException");
        }
    }

    public static GeneralException getGeneralException(String msgID, SQLException e, Object[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SQLUtil.class.getName(), (String)"getGeneralException", (String)"msgID, e, args");
        }
        StringBuffer buffer = new StringBuffer(320);
        SQLUtil.appendSQLException(e, buffer);
        GeneralException traceResult = new GeneralException(msgID, args, buffer.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"getGeneralException", (Object)((Object)traceResult));
        }
        return traceResult;
    }

    public static void setHoldability(Connection dbc, boolean hold) {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)SQLUtil.class.getName(), (String)"setHoldability", (String)"dbc, hold");
            }
            Object[] arg = null;
            if (SQLUtil.isCloudscape()) {
                arg = hold ? SH_ONE_ARG : SH_ZERO_ARG;
                try {
                    Method sh = dbc.getClass().getMethod("setHoldability", SH_INT_PARAM);
                    sh.invoke((Object)dbc, arg);
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)SQLUtil.class.getName(), (String)"setHoldability", (Throwable)e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SQLUtil.class.getName(), (String)"setHoldability");
        }
    }

    public static Timestamp getTimestamp(Connection con) throws SQLException {
        return CurrentTime.getTimestamp();
    }

    static {
        inetDriver = false;
        sortOrderNotASCII = false;
        mssqlSortOrderQuery = "select attribute_value from master.dbo.spt_server_info where attribute_id = 18";
        BINARY_SORT_ORDERS = new int[]{30, 40, 50, 80, 104, 112, 128, 136, 144, 152, 192, 194, 196, 204};
        SH_INT_PARAM = new Class[]{Integer.TYPE};
        SH_ZERO_ARG = new Object[]{new Integer(0)};
        SH_ONE_ARG = new Object[]{new Integer(1)};
    }
}

