/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptDiskAssetHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT_START = "select disk_id, statistic_time, ";
    private static final String SELECT_PRIMARY_DEFECTS = "primary_defects";
    private static final String SELECT_GROWN_DEFECTS = "grown_defects";
    private static final String SELECT_UNALLOCATED = "free_space";
    private static final String SELECT_RECOVERED_ERR = "recovrd_rd_errs + recovrd_wrt_errs + recovrd_vfy_errs";
    private static final String SELECT_UNRECOVERED_ERR = "unrecovrd_rd_errs + unrecovrd_wrt_errs + unrecovrd_vfy_errs";
    private static final String SELECT_TABLE = " from t_stat_disk_hist";

    public RptDiskAssetHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskAssetHist.class.getName(), (String)"RptDiskAssetHist", (String)"dbc");
        }
        this.tableName = "t_stat_disk_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskAssetHist.class.getName(), (String)"RptDiskAssetHist");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskAssetHist.class.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        boolean isSpace = false;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT_START);
        if (grr.reportSubtype == -39) {
            buffer.append(SELECT_UNALLOCATED);
            isSpace = true;
        } else if (grr.reportSubtype == -24) {
            buffer.append(SELECT_GROWN_DEFECTS);
        } else if (grr.reportSubtype == -23) {
            buffer.append(SELECT_PRIMARY_DEFECTS);
        } else if (grr.reportSubtype == -25) {
            buffer.append(SELECT_RECOVERED_ERR);
        } else {
            buffer.append(SELECT_UNRECOVERED_ERR);
        }
        buffer.append(SELECT_TABLE);
        buffer.append(" where statistic_type in ('");
        buffer.append(grr.histType);
        if (grr.histType == 0) {
            buffer.append("','3') and");
        } else {
            buffer.append("') and");
        }
        if (grr.startTime > 0L) {
            buffer.append(" statistic_time between ? and ? and");
        }
        if (grr.reportSubtype == -24) {
            buffer.append(" grown_defects > -1 and");
        }
        SQLUtil.appendInClause(buffer, "disk_id", grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.getPhase();
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                if (isSpace) {
                    sh.shTotalSize = this.getLong(this.resultSet);
                    if (sh.shTotalSize < 0L) {
                        sh.shTotalSize = 0L;
                    }
                } else {
                    sh.shFileCount = this.getLong(this.resultSet);
                    if (sh.shFileCount < 0L) {
                        sh.shFileCount = 0L;
                    }
                }
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskAssetHist.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskAssetHist.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }
}

