/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.guireq.fabric.reports.RespFabricAssets;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptFabricAssets
extends StorageRepositoryAccessor
implements GuiDataProvider {
    GuiReportReq grr;
    int rowCount;

    public RptFabricAssets(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFabricAssets.class.getName(), (String)"RptFabricAssets", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFabricAssets.class.getName(), (String)"RptFabricAssets");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        StringBuffer buf = new StringBuffer(2000);
        this.tableName = grr.reportType == 102 ? "T_RES_SWITCH" : "T_RES_FABRIC";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFabricAssets.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.rowsToReturn < 1) {
            grr.rowsToReturn = Integer.MAX_VALUE;
        }
        RespFabricAssets head = new RespFabricAssets();
        RespFabricAssets curr = null;
        RespFabricAssets last = head;
        int totalRows = 0;
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, head);
        }
        try {
            switch (grr.reportSubtype) {
                case 101: {
                    buf.append("select ");
                    buf.append(FabricDbAccess.SAN_ASSETS_ALL);
                    buf.append(" order by FABRIC_ID, TYPE");
                    break;
                }
                case 102: {
                    buf.append("select ");
                    buf.append("       case            when (Fabric.DISPLAY_NAME is not null) then Fabric.DISPLAY_NAME            when (Fabric.NAME is not null) then RTRIM(Fabric.NAME)            when (Fabric.SAN_WWN is not null) then RTRIM(Fabric.SAN_WWN)            else Fabric.FABRIC_WWN   end , 0 , 0  as TYPE,  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end , SWITCH.IP_ADDRESS, VENDOR.VENDOR_NAME, MODEL.MODEL_NAME, SWITCH.VERSION, SWITCH.SERIAL_NUMBER, SWITCH.SWITCH_ID, SWITCH.MANAGEMENT_ID, SWITCH.MGMT_URL_ADDR, SWITCH.DOMAIN, SWITCH.CONTACT, SWITCH.SWITCH_WWN, SWITCH.LOCATION, SWITCH.PARENT_SWITCH_WWN from T_RES_SWITCH as SWITCH left outer join T_RES_FABRIC2SWITCH as F2S on (SWITCH.SWITCH_WWN = F2S.SWITCH_WWN) left outer join T_RES_FABRIC as FABRIC on (F2S.FABRIC_WWN = FABRIC.FABRIC_WWN), T_RES_VENDOR as VENDOR, T_RES_MODEL as MODEL where SWITCH.VENDOR_ID = VENDOR.VENDOR_ID and SWITCH.MODEL_ID = MODEL.MODEL_ID and ((F2S.DETECTABLE = 1 and Fabric.Detectable = 1) or (F2S.DETECTABLE = 0 and SWITCH.Detectable = 0))");
                    buf.append(" order by FABRIC_ID, TYPE");
                    break;
                }
                case 103: {
                    buf.append("select ");
                    buf.append(FabricDbAccess.SAN_ASSETS_CONNECTED_DEV);
                    buf.append(" order by FABRIC_ID, TYPE");
                    break;
                }
                default: {
                    Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                    String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)RptFabricAssets.class.getName(), (String)"getReportData");
                    }
                    throw new GeneralException(errmsg);
                }
            }
            this.selectStmt = this.prepareStmt(buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                if (curr == null) {
                    curr = new RespFabricAssets();
                }
                this.colIndex = 1;
                if (this.rowCount >= grr.rowsToReturn) {
                    break;
                }
                if (grr.reportSubtype == 101) {
                    curr.FabricID = this.getString(this.resultSet);
                    curr.Type = this.getTypeString(this.resultSet);
                    curr.Label = this.getString(this.resultSet);
                    curr.Status = this.getInt(this.resultSet);
                } else if (grr.reportSubtype == 102) {
                    curr.FabricID = this.getString(this.resultSet);
                    curr.Type = this.getTypeString(this.resultSet);
                    curr.Label = this.getString(this.resultSet);
                    curr.IP_Address = this.getString(this.resultSet);
                    curr.Vendor = this.getString(this.resultSet);
                    curr.Model = this.getString(this.resultSet);
                    curr.Version = this.getString(this.resultSet);
                    curr.SerialNumber = this.getString(this.resultSet);
                    curr.ObjectID = this.getInt(this.resultSet);
                    curr.ManagementID = this.getString(this.resultSet);
                    curr.ManagementAddress = this.getString(this.resultSet);
                    curr.Domain = this.getString(this.resultSet);
                    curr.Contact = this.getString(this.resultSet);
                    curr.WWN = this.getString(this.resultSet);
                    curr.Location = this.getString(this.resultSet);
                    curr.PhysicalSwitchWWN = this.getString(this.resultSet);
                } else {
                    curr.FabricID = this.getString(this.resultSet);
                    curr.Type = this.getTypeString(this.resultSet);
                    curr.Label = this.getString(this.resultSet);
                    curr.WWN = this.getString(this.resultSet);
                    curr.Status = this.getInt(this.resultSet);
                }
                if (filter != null) {
                    RespFabricAssets clone = (RespFabricAssets)curr.clone();
                    rowSelected = filter.isSelected(clone);
                }
                if (!rowSelected) continue;
                last.next = curr;
                last = curr;
                curr = null;
                ++totalRows;
                ++this.rowCount;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptFabricAssets.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
        }
        RespFabricAssets[] traceResult = RptFabricAssets.packItUp(head.next, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFabricAssets.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    public static RespFabricAssets[] packItUp(RespFabricAssets head, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFabricAssets.class.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespFabricAssets[] result = new RespFabricAssets[totalRows];
        totalRows = 0;
        while (head != null) {
            RespFabricAssets next = head.next;
            head.next = null;
            result[totalRows] = head;
            ++totalRows;
            head = next;
        }
        RespFabricAssets[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFabricAssets.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }
}

