/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptPing
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private static final int REPLACE = 0;
    private static final int DISCARD = 1;
    private static final int KEEP = 2;
    private int groupID = Integer.MIN_VALUE;
    private PingReport resultList;
    private int totalRows;
    private GuiReportReq grr;
    private Timestamp tsNull = new Timestamp(0L);
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT_CLAUSE = "select p.monitor_start, p.monitor_end, p.transmitted, p.received, p.damaged, p.min_transit_time, p.max_transit_time, p.avg_transit_time, p.statistic_type, p.computer_id";
    private static final String SELECT_DISTINCT_CLAUSE = "select distinct p.monitor_start, p.monitor_end, p.transmitted, p.received, p.damaged, p.min_transit_time, p.max_transit_time, p.avg_transit_time, p.statistic_type, p.computer_id";
    private static final String FROM_CLAUSE = " from t_stat_ping_hist p";
    private static final String COMP_GROUP_JOIN = " p.computer_id = c.computer_id and c.computer_id = gr.resource_id and g.group_id    = gr.group_id";
    private static final String DOMAIN_JOIN = " p.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String SELECT_HIST_GRAPH = "select computer_id, monitor_end, statistic_type, transmitted, received, avg_transit_time from t_stat_ping_hist";
    private static final String COMPUTER_COL = "computer_id";

    public RptPing(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"RptPing", (String)"dbc");
        }
        this.tableName = "t_stat_ping_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"RptPing");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.histSubtype > 0) {
            Serializable traceResult = this.getHistoryGraphData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptPing.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        PingReport currentRow = new PingReport();
        PingReport lastRow = null;
        this.totalRows = 0;
        int computerID = 0;
        String sqlText = this.buildReportQuery();
        try {
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectStmt, 86400000L, this.tsNull);
            if (grr.startTime > 0L) {
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.fetch(currentRow)) {
                if (computerID != currentRow.pngComputerID || grr.reportSubtype == 13) {
                    if (lastRow == null) {
                        lastRow = new PingReport();
                    } else {
                        this.aggregate(lastRow);
                    }
                    computerID = currentRow.pngComputerID;
                    PingReport tmp = currentRow;
                    currentRow = lastRow;
                    lastRow = tmp;
                    continue;
                }
                int status = this.analyzeRow(currentRow, lastRow);
                switch (status) {
                    case 2: {
                        this.aggregate(lastRow);
                    }
                    case 0: {
                        PingReport tmp = currentRow;
                        currentRow = lastRow;
                        lastRow = tmp;
                    }
                }
            }
            if (lastRow != null) {
                this.aggregate(lastRow);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptPing.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (grr.columnFilters != null) {
            this.applyFilter(new ReportFilter(grr, currentRow));
        }
        if (grr.isBatchReport && (grr.reportSubtype == 12 || grr.reportSubtype == 28)) {
            this.getComputerNames(this.resultList);
        }
        PingReport[] traceResult = this.packItUp((PingHist)this.resultList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private String buildReportQuery() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"buildReportQuery", (String)"");
        }
        StringBuffer buffer = new StringBuffer(1024);
        switch (this.grr.reportSubtype) {
            case 12: 
            case 28: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(FROM_CLAUSE);
                this.appendWhereClause(buffer, null, "p.computer_id");
                this.appendOrderByClause(buffer, null);
                break;
            }
            case 13: 
            case 82: {
                buffer.append(SELECT_DISTINCT_CLAUSE);
                buffer.append(", g.group_id, g.creator, g.name");
                buffer.append(FROM_CLAUSE);
                buffer.append(", t_stat_computer c, t_group g, t_view_group2res gr ");
                this.appendWhereClause(buffer, COMP_GROUP_JOIN, "g.group_id");
                if (this.grr.reportSubtype == 13) {
                    buffer.append(" and g.group_type <> 99");
                } else {
                    buffer.append(" and g.group_type = 99");
                }
                this.appendOrderByClause(buffer, "g.group_id");
                break;
            }
            case 14: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(", d.domain_id, d.name");
                buffer.append(FROM_CLAUSE);
                buffer.append(", t_stat_computer c, t_res_domain d");
                this.appendWhereClause(buffer, DOMAIN_JOIN, "d.domain_id");
                this.appendOrderByClause(buffer, "d.domain_id");
                break;
            }
            default: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(FROM_CLAUSE);
                this.appendWhereClause(buffer, null, null);
                this.appendOrderByClause(buffer, null);
            }
        }
        String traceResult = buffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"buildReportQuery", (Object)traceResult);
        }
        return traceResult;
    }

    private void appendWhereClause(StringBuffer buffer, String joinCondition, String inColumn) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"appendWhereClause", (String)"buffer, joinCondition, inColumn");
        }
        buffer.append(" where p.monitor_start > ?");
        if (this.grr.startTime > 0L) {
            buffer.append(" and p.monitor_start >= ? and p.monitor_end <= ? ");
        }
        if (joinCondition != null) {
            buffer.append(" and ");
            buffer.append(joinCondition);
        }
        SQLUtil.appendInClause(buffer, inColumn, this.grr.selectedResources, this.grr.isResourceInList, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"appendWhereClause");
        }
    }

    private void appendOrderByClause(StringBuffer buffer, String colName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"appendOrderByClause", (String)"buffer, colName");
        }
        buffer.append(" order by ");
        if (colName != null) {
            buffer.append(colName);
            buffer.append(',');
        }
        buffer.append(" p.computer_id, monitor_start, monitor_end");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"appendOrderByClause");
        }
    }

    private boolean fetch(PingReport pr) throws SQLException {
        boolean haveRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"fetch", (String)"pr");
        }
        if (haveRow = this.resultSet.next()) {
            this.colIndex = 1;
            pr.pngMonitorStart = this.getTimestamp(this.resultSet);
            pr.pngMonitorEnd = this.getTimestamp(this.resultSet);
            pr.pngTransmitted = this.getInt(this.resultSet);
            pr.pngReceived = this.getInt(this.resultSet);
            pr.pngDamaged = this.getInt(this.resultSet);
            pr.pngMinTransitTime = this.getInt(this.resultSet);
            pr.pngMaxTransitTime = this.getInt(this.resultSet);
            pr.pngAvgTransitTime = this.getLong(this.resultSet);
            pr.pngStatisticType = this.getByte(this.resultSet);
            pr.pngComputerID = this.getInt(this.resultSet);
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                pr.prID = pr.pngComputerID;
            } else if (this.grr.reportSubtype != 15) {
                pr.prID = this.getInt(this.resultSet);
                pr.prName1 = this.getString(this.resultSet);
                if (this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                    pr.setPrName2(this.getString(this.resultSet));
                }
            }
        }
        boolean traceResult = haveRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }

    private void aggregate(PingReport row) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"aggregate", (String)"row");
        }
        if (this.groupID != row.prID) {
            PingReport group = (PingReport)row.clone();
            group.pngNext = this.resultList;
            this.resultList = group;
            ++this.totalRows;
            if (this.grr.reportSubtype == 28) {
                if (group.pngStatisticType >= 3 && group.pngReceived > 0) {
                    group.pngAvgTransitTime /= (long)group.pngReceived;
                }
            } else {
                this.groupID = row.prID;
                if (group.pngStatisticType < 3) {
                    group.pngAvgTransitTime *= (long)group.pngReceived;
                }
            }
        } else {
            if (this.resultList.pngMonitorStart > row.pngMonitorStart) {
                this.resultList.pngMonitorStart = row.pngMonitorStart;
            }
            if (this.resultList.pngMonitorEnd < row.pngMonitorEnd) {
                this.resultList.pngMonitorEnd = row.pngMonitorEnd;
            }
            this.resultList.pngTransmitted += row.pngTransmitted;
            this.resultList.pngReceived += row.pngReceived;
            this.resultList.pngDamaged += row.pngDamaged;
            if (this.resultList.pngMinTransitTime > row.pngMinTransitTime) {
                this.resultList.pngMinTransitTime = row.pngMinTransitTime;
            }
            if (this.resultList.pngMaxTransitTime < row.pngMaxTransitTime) {
                this.resultList.pngMaxTransitTime = row.pngMaxTransitTime;
            }
            if (row.pngStatisticType < 3) {
                row.pngAvgTransitTime *= (long)row.pngReceived;
            }
            this.resultList.pngAvgTransitTime += row.pngAvgTransitTime;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"aggregate");
        }
    }

    private int analyzeRow(PingReport currentRow, PingReport lastRow) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"analyzeRow", (String)"currentRow, lastRow");
        }
        if (this.grr.reportSubtype == 28) {
            int traceResult = 2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptPing.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (currentRow.pngMonitorStart >= lastRow.pngMonitorEnd) {
            int traceResult = 2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptPing.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (currentRow.pngMonitorStart == lastRow.pngMonitorStart) {
            int traceResult = 1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptPing.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (currentRow.pngMonitorEnd <= lastRow.pngMonitorEnd && currentRow.pngMonitorStart <= this.grr.startTime) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptPing.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"analyzeRow", (int)traceResult);
        }
        return traceResult;
    }

    private void applyFilter(ReportFilter filter) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"applyFilter", (String)"filter");
        }
        PingReport candidateList = this.resultList;
        PingReport lastSelected = null;
        this.resultList = null;
        this.totalRows = 0;
        while (candidateList != null) {
            PingReport candidate = candidateList;
            candidateList = (PingReport)candidate.pngNext;
            candidate.pngNext = null;
            PingReport clone = (PingReport)candidate.clone();
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                this.getComputerNames(clone);
            }
            if (!filter.isSelected(clone)) continue;
            if (this.resultList == null) {
                this.resultList = candidate;
            } else {
                lastSelected.pngNext = candidate;
            }
            lastSelected = candidate;
            ++this.totalRows;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"applyFilter");
        }
    }

    private void getComputerNames(PingReport node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            node.prName1 = agentManager.getAgentName(node.prID);
            node = (PingReport)node.pngNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"getComputerNames");
        }
    }

    private PingReport[] packItUp(PingHist head) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"packItUp", (String)"head");
        }
        PingReport[] result = new PingReport[this.totalRows];
        this.totalRows = 0;
        while (head != null) {
            PingHist next = head.pngNext;
            head.pngNext = null;
            result[this.totalRows] = (PingReport)head;
            ++this.totalRows;
            head = next;
        }
        PingReport[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }

    public Serializable getHistoryGraphData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPing.class.getName(), (String)"getHistoryGraphData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT_HIST_GRAPH);
        buffer.append(" where statistic_type in ('");
        buffer.append(grr.histType);
        buffer.append('\'');
        if (grr.histType != 0) {
            buffer.append(",'");
            buffer.append(grr.histType + 2);
            buffer.append('\'');
        }
        buffer.append(") and");
        if (grr.startTime > 0L) {
            buffer.append(" monitor_end between ? and ? and");
        }
        SQLUtil.appendInClause(buffer, COMPUTER_COL, grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                byte statType = this.getByte(this.resultSet);
                int transmitted = this.getInt(this.resultSet);
                int received = this.getInt(this.resultSet);
                long transitTime = this.getLong(this.resultSet);
                if (grr.histSubtype == 7) {
                    if (received == 0) continue;
                    sh.shFileCount = statType == 3 || statType == 4 ? (long)((int)(transitTime / (long)received)) : (long)((int)transitTime);
                } else {
                    sh.shFileCount = (int)((double)received / (double)transmitted * 100.0);
                }
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptPing.class.getName(), (String)"getHistoryGraphData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPing.class.getName(), (String)"getHistoryGraphData", (Object)traceResult);
        }
        return traceResult;
    }
}

