/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.guireq.fabric.reports.RespPortConnections;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptPortConnections
extends StorageRepositoryAccessor
implements GuiDataProvider {
    GuiReportReq grr;
    int rowCount;

    public RptPortConnections(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPortConnections.class.getName(), (String)"RptPortConnections", (String)"dbc");
        }
        this.tableName = "T_RES_PORT";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPortConnections.class.getName(), (String)"RptPortConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        StringBuffer buf = new StringBuffer(2000);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPortConnections.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.rowsToReturn < 1) {
            grr.rowsToReturn = Integer.MAX_VALUE;
        }
        RespPortConnections head = new RespPortConnections();
        RespPortConnections curr = null;
        RespPortConnections last = head;
        int totalRows = 0;
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, head);
        }
        try {
            if (grr.reportSubtype != 104) {
                Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptPortConnections.class.getName(), (String)"getReportData");
                }
                throw new GeneralException(errmsg);
            }
            buf.append("select ");
            buf.append(FabricDbAccess.PORT_CONNECTIONS);
            this.selectStmt = this.prepareStmt(buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                if (curr == null) {
                    curr = new RespPortConnections();
                }
                this.colIndex = 1;
                if (this.rowCount >= grr.rowsToReturn) break;
                if (grr.reportSubtype == 104) {
                    curr.FabricID = this.getString(this.resultSet);
                    curr.SwitchID = this.getString(this.resultSet);
                    curr.Switch_Port = this.getString(this.resultSet);
                    curr.Switch_Port_State = this.getInt(this.resultSet);
                    curr.Connection_State = this.getInt(this.resultSet);
                    curr.Connected_Port = this.getString(this.resultSet);
                    curr.Connected_Port_State = this.getInt(this.resultSet);
                    curr.Device = this.getTypeString(this.resultSet);
                    curr.Device_State = this.getInt(this.resultSet);
                }
                if (filter != null) {
                    RespPortConnections clone = (RespPortConnections)curr.clone();
                    rowSelected = filter.isSelected(clone);
                }
                if (!rowSelected) continue;
                last.next = curr;
                last = curr;
                curr = null;
                ++totalRows;
                ++this.rowCount;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptPortConnections.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
        }
        RespPortConnections[] traceResult = RptPortConnections.packItUp(head.next, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPortConnections.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    public static RespPortConnections[] packItUp(RespPortConnections head, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptPortConnections.class.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespPortConnections[] result = new RespPortConnections[totalRows];
        totalRows = 0;
        while (head != null) {
            RespPortConnections next = head.next;
            head.next = null;
            result[totalRows] = head;
            ++totalRows;
            head = next;
        }
        RespPortConnections[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptPortConnections.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }
}

