/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptUpTime
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsNull = new Timestamp(0L);
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final int REPLACE = 0;
    private static final int DISCARD = 1;
    private static final int KEEP = 2;
    int groupID = Integer.MIN_VALUE;
    UpTimeReport resultList;
    private int totalRows;
    GuiReportReq grr;
    private static final String SELECT_CLAUSE = "select h.monitor_start, h.monitor_end, h.down_time, h.power_cycles, h.statistic_type, h.computer_id";
    private static final String SELECT_DISTINCT_CLAUSE = "select distinct h.monitor_start, h.monitor_end, h.down_time, h.power_cycles, h.statistic_type, h.computer_id";
    private static final String FROM_CLAUSE = " from t_stat_comp_hist h";
    private static final String COMP_GROUP_JOIN = " h.computer_id = gr.resource_id and gr.group_id = g.group_id";
    private static final String DOMAIN_JOIN = " h.computer_id = c.computer_id and c.domain_id = d.domain_id";
    private static final String SELECT_HIST_GRAPH = "select computer_id, monitor_end, statistic_type, down_time, monitor_start from t_stat_comp_hist";
    private static final String COMPUTER_COL = "computer_id";
    private static final int MILLIS_PER_SECOND = 1000;

    public RptUpTime(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"RptUpTime", (String)"dbc");
        }
        this.tableName = "t_stat_comp_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"RptUpTime");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.histSubtype > 0) {
            Serializable traceResult = this.getHistoryGraphData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptUpTime.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        UpTimeReport currentRow = new UpTimeReport();
        UpTimeReport lastRow = null;
        this.totalRows = 0;
        int computerID = -1;
        String sqlText = this.buildReportQuery();
        try {
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectStmt, 86400000L, this.tsNull);
            if (grr.startTime > 0L) {
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.fetch(currentRow)) {
                if (computerID != currentRow.chComputerID) {
                    if (lastRow == null) {
                        lastRow = new UpTimeReport();
                    } else {
                        this.aggregate(lastRow);
                    }
                    computerID = currentRow.chComputerID;
                    UpTimeReport tmp = currentRow;
                    currentRow = lastRow;
                    lastRow = tmp;
                    continue;
                }
                int status = this.analyzeRow(currentRow, lastRow);
                switch (status) {
                    case 2: {
                        this.aggregate(lastRow);
                    }
                    case 0: {
                        UpTimeReport tmp = currentRow;
                        currentRow = lastRow;
                        lastRow = tmp;
                    }
                }
            }
            if (lastRow != null) {
                this.aggregate(lastRow);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptUpTime.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (grr.columnFilters != null) {
            this.applyFilter(new ReportFilter(grr, currentRow));
        }
        if (grr.isBatchReport && (grr.reportSubtype == 12 || grr.reportSubtype == 28)) {
            this.getComputerNames(this.resultList);
        }
        UpTimeReport[] traceResult = this.packItUp((CompHist)this.resultList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private String buildReportQuery() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"buildReportQuery", (String)"");
        }
        StringBuffer buffer = new StringBuffer(1024);
        switch (this.grr.reportSubtype) {
            case 12: 
            case 28: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(FROM_CLAUSE);
                this.appendWhereClause(buffer, null, "h.computer_id", true);
                this.appendOrderByClause(buffer, null);
                break;
            }
            case 13: 
            case 82: {
                buffer.append(SELECT_DISTINCT_CLAUSE);
                buffer.append(", g.group_id, g.creator, g.name");
                buffer.append(FROM_CLAUSE);
                buffer.append(", t_group g, t_view_group2res gr ");
                this.appendWhereClause(buffer, COMP_GROUP_JOIN, "g.group_id", false);
                if (this.grr.reportSubtype == 13) {
                    buffer.append(" and g.group_type <> 99");
                } else {
                    buffer.append(" and g.group_type = 99");
                }
                Group2ResSqlUtil.appendG2RWhere(buffer, this.grr.selectedResources, this.grr.isResourceInList, true, this.grr.reportSubtype, "gr");
                this.appendOrderByClause(buffer, "g.group_id");
                break;
            }
            case 14: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(", d.domain_id, d.name");
                buffer.append(FROM_CLAUSE);
                buffer.append(", t_stat_computer c, t_res_domain d");
                this.appendWhereClause(buffer, DOMAIN_JOIN, "d.domain_id", true);
                this.appendOrderByClause(buffer, "d.domain_id");
                break;
            }
            default: {
                buffer.append(SELECT_CLAUSE);
                buffer.append(FROM_CLAUSE);
                this.appendWhereClause(buffer, null, null, true);
                this.appendOrderByClause(buffer, null);
            }
        }
        String traceResult = buffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"buildReportQuery", (Object)traceResult);
        }
        return traceResult;
    }

    private void appendWhereClause(StringBuffer buffer, String joinCondition, String inColumn, boolean useInClause) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"appendWhereClause", (String)"buffer, joinCondition, inColumn, useInClause");
        }
        buffer.append(" where h.monitor_start > ?");
        if (this.grr.startTime > 0L) {
            buffer.append(" and h.monitor_start >= ? and h.monitor_end <= ? ");
        }
        if (joinCondition != null) {
            buffer.append(" and ");
            buffer.append(joinCondition);
        }
        if (useInClause) {
            SQLUtil.appendInClause(buffer, inColumn, this.grr.selectedResources, this.grr.isResourceInList, true);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"appendWhereClause");
        }
    }

    private void appendOrderByClause(StringBuffer buffer, String colName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"appendOrderByClause", (String)"buffer, colName");
        }
        buffer.append(" order by ");
        if (colName != null) {
            buffer.append(colName);
            buffer.append(',');
        }
        buffer.append(" h.computer_id, monitor_start, monitor_end");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"appendOrderByClause");
        }
    }

    private boolean fetch(UpTimeReport cr) throws SQLException {
        boolean haveRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"fetch", (String)"cr");
        }
        if (haveRow = this.resultSet.next()) {
            this.colIndex = 1;
            cr.chMonitorStart = this.getTimestamp(this.resultSet);
            cr.chMonitorEnd = this.getTimestamp(this.resultSet);
            cr.chDownTime = this.getInt(this.resultSet);
            cr.chPowerCycles = this.getInt(this.resultSet);
            cr.chStatisticType = this.getByte(this.resultSet);
            cr.chComputerID = this.getInt(this.resultSet);
            long monitorDuration = cr.chMonitorEnd - cr.chMonitorStart;
            cr.crUpTime = (monitorDuration /= 1000L) - (long)cr.chDownTime;
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                cr.crID = cr.chComputerID;
            } else if (this.grr.reportSubtype != 15) {
                cr.crID = this.getInt(this.resultSet);
                cr.crName1 = this.getString(this.resultSet);
                if (this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                    cr.setCrName2(this.getString(this.resultSet));
                }
            }
        }
        boolean traceResult = haveRow;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"fetch", (boolean)traceResult);
        }
        return traceResult;
    }

    private int analyzeRow(UpTimeReport currentRow, UpTimeReport lastRow) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"analyzeRow", (String)"currentRow, lastRow");
        }
        if (this.grr.reportSubtype == 28) {
            int traceResult = 2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (currentRow.chMonitorStart >= lastRow.chMonitorEnd) {
            int traceResult = 2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (this.grr.reportSubtype == 13 && this.groupID != currentRow.crID) {
            int traceResult = 2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        if (currentRow.chMonitorStart == lastRow.chMonitorStart) {
            if (currentRow.chStatisticType == lastRow.chStatisticType) {
                int traceResult = 0;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
                }
                return traceResult;
            }
        } else if (currentRow.chMonitorEnd <= lastRow.chMonitorEnd && currentRow.chMonitorStart <= this.grr.startTime) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"analyzeRow", (int)traceResult);
        }
        return traceResult;
    }

    private void aggregate(UpTimeReport row) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"aggregate", (String)"row");
        }
        if (this.groupID != row.crID) {
            UpTimeReport group = (UpTimeReport)row.clone();
            group.chNext = this.resultList;
            this.resultList = group;
            ++this.totalRows;
            if (this.grr.reportSubtype != 28) {
                this.groupID = row.crID;
            }
        } else {
            if (this.resultList.chMonitorStart > row.chMonitorStart) {
                this.resultList.chMonitorStart = row.chMonitorStart;
            }
            if (this.resultList.chMonitorEnd < row.chMonitorEnd) {
                this.resultList.chMonitorEnd = row.chMonitorEnd;
            }
            this.resultList.chDownTime += row.chDownTime;
            this.resultList.crUpTime += row.crUpTime;
            this.resultList.chPowerCycles += row.chPowerCycles;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"aggregate");
        }
    }

    private void applyFilter(ReportFilter filter) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"applyFilter", (String)"filter");
        }
        UpTimeReport candidateList = this.resultList;
        UpTimeReport lastSelected = null;
        this.resultList = null;
        this.totalRows = 0;
        while (candidateList != null) {
            UpTimeReport candidate = candidateList;
            candidateList = (UpTimeReport)candidate.chNext;
            candidate.chNext = null;
            UpTimeReport clone = (UpTimeReport)candidate.clone();
            if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 28) {
                this.getComputerNames(clone);
            }
            if (!filter.isSelected(clone)) continue;
            if (this.resultList == null) {
                this.resultList = candidate;
            } else {
                lastSelected.chNext = candidate;
            }
            lastSelected = candidate;
            ++this.totalRows;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"applyFilter");
        }
    }

    private void getComputerNames(UpTimeReport node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            node.crName1 = agentManager.getAgentName(node.crID);
            node = (UpTimeReport)node.chNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"getComputerNames");
        }
    }

    private UpTimeReport[] packItUp(CompHist head) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"packItUp", (String)"head");
        }
        UpTimeReport[] result = new UpTimeReport[this.totalRows];
        this.totalRows = 0;
        while (head != null) {
            CompHist next = head.chNext;
            head.chNext = null;
            result[this.totalRows] = (UpTimeReport)head;
            ++this.totalRows;
            head = next;
        }
        UpTimeReport[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }

    public Serializable getHistoryGraphData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptUpTime.class.getName(), (String)"getHistoryGraphData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT_HIST_GRAPH);
        buffer.append(" where statistic_type in ('");
        buffer.append(grr.histType);
        buffer.append('\'');
        if (grr.histType != 0) {
            buffer.append(",'");
            buffer.append(grr.histType + 2);
            buffer.append('\'');
        }
        buffer.append(") and");
        if (grr.startTime > 0L) {
            buffer.append(" monitor_end between ? and ? and");
        }
        SQLUtil.appendInClause(buffer, COMPUTER_COL, grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                byte statType = this.getByte(this.resultSet);
                int downTimeSecs = this.getInt(this.resultSet);
                long startTime = this.getTimestamp(this.resultSet);
                int upTimeSecs = (int)((sh.shStatisticTime - startTime) / 1000L);
                sh.shFileCount = (int)((double)upTimeSecs / (double)(upTimeSecs + downTimeSecs) * 100.0);
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptUpTime.class.getName(), (String)"getHistoryGraphData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptUpTime.class.getName(), (String)"getHistoryGraphData", (Object)traceResult);
        }
        return traceResult;
    }
}

