/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report.filter;

import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.logging.TraceLogger;

public abstract class FilterEvaluator {
    public FilterEvaluator nextEvaluator;
    protected ColumnFilterValue valueList;
    protected ColumnFilter filter;
    protected boolean applyNot;
    protected CustomReportDataAdjuster adjuster;

    protected FilterEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) {
        this.filter = filter;
        this.adjuster = adjuster;
        this.valueList = filter.getValueList();
        this.applyNot = filter.clfCondition == 2 || filter.clfCondition == 8 || filter.clfCondition == 3 || filter.clfCondition == 5 || filter.clfCondition == 10 || filter.clfCondition == 12;
    }

    public boolean isSelected(int row) {
        Object reportValue;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilterEvaluator.class.getName(), (String)"isSelected", (String)"row");
        }
        if ((reportValue = this.adjuster.getCellData(row, (int)this.filter.clfColumnID)) == null) {
            reportValue = " ";
        }
        boolean result = false;
        ColumnFilterValue filterValue = this.valueList;
        while (filterValue != null && !(result = this.isMatch(reportValue, filterValue.fvValue))) {
            filterValue = filterValue.fvNext;
        }
        boolean traceResult = this.applyNot ^ result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilterEvaluator.class.getName(), (String)"isSelected", (boolean)traceResult);
        }
        return traceResult;
    }

    public abstract boolean isMatch(Object var1, Object var2);
}

