/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;

public class TAlertEmail
extends RepositoryAccessor {
    public static final String ID_COLUMN_NAME = "alert_id";
    private static final String SELECT_BY_ID = "select alert_id, subject, text, recipients, quota_violator from t_alert_email where alert_id = ?";
    private static final String INSERT = "insert into t_alert_email (alert_id, subject, text, recipients, quota_violator) values (?,?,?,?,?)";

    public TAlertEmail(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertEmail.class.getName(), (String)"TAlertEmail", (String)"dbc");
        }
        this.tableName = "t_alert_email";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertEmail.class.getName(), (String)"TAlertEmail");
        }
    }

    public void prepSelectByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
    }

    public void getAlertEmail(AlertDefinition alert) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertEmail.class.getName(), (String)"getAlertEmail", (String)"alert");
        }
        alert.aldEmailDef = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, alert.aldAlertID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                AlertEmail alertEmail = new AlertEmail();
                this.stmtPhase = 1;
                this.colIndex = 1;
                alertEmail.aleAlertID = this.getInt(this.resultSet);
                alertEmail.aleSubject = this.getString(this.resultSet);
                alertEmail.aleText = this.getString(this.resultSet);
                alertEmail.aleRecipients = this.getString(this.resultSet);
                alertEmail.aleQuotaViolator = this.getByte(this.resultSet);
                alert.aldEmailDef = alertEmail;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertEmail.class.getName(), (String)"getAlertEmail", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (alert.aldEmailDef == null) {
            alert.aldEmail = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertEmail.class.getName(), (String)"getAlertEmail");
        }
    }

    public void insert(AlertEmail email) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertEmail.class.getName(), (String)"insert", (String)"email");
        }
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.insertStmt, email.aleAlertID);
            this.setString(this.insertStmt, email.aleSubject);
            this.setString(this.insertStmt, email.aleText);
            this.setString(this.insertStmt, email.aleRecipients);
            this.setByte(this.insertStmt, email.aleQuotaViolator);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertEmail.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertEmail.class.getName(), (String)"insert");
        }
    }

    public void deleteByID(int alertID, String type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertEmail.class.getName(), (String)"deleteByID", (String)"alertID, type");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, null, type);
        proxy.deleteByID(alertID, ID_COLUMN_NAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertEmail.class.getName(), (String)"deleteByID");
        }
    }
}

