/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.SmtpSettings;
import org.eclipse.aperi.server.guireq.SnmpDestination;
import org.eclipse.aperi.xmsg.MessageLog;

public class TConfigSettings
extends RepositoryAccessor {
    private static final String EMAIL_FILENAME = "configuration" + File.separator + "SmtpSettings.ser";
    private static final String SELECT = "select snmp_server, snmp_port, snmp_community, snmp2_server, snmp2_port, snmp2_community, tec_server, tec_port, retain_copies, retain_days, dellog_after_days, smtp_server, smtp_port, smtp_reply_to, smtp_return, smtp_dflt_domain from t_config_settings";
    private static final String INSERT = "insert into t_config_settings (snmp_server, snmp_port, snmp_community, snmp2_server, snmp2_port, snmp2_community, tec_server, tec_port, dellog_after_days, smtp_server, smtp_port, smtp_reply_to, smtp_return, smtp_dflt_domain, retain_copies, retain_days) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_NETWORK = "update t_config_settings set snmp_server = ?, snmp_port = ?, snmp_community = ?, snmp2_server = ?, snmp2_port = ?, snmp2_community = ?, tec_server = ?, tec_port = ?, dellog_after_days = ?";
    private static final String UPDATE_RETENTION = "update t_config_settings set retain_copies = ?, retain_days = ?";

    public TConfigSettings(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"TConfigSettings", (String)"dbc");
        }
        this.tableName = "t_config_settings";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"TConfigSettings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigSettings getConfigSettings(boolean throwException) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"getConfigSettings", (String)"throwException");
        }
        ConfigSettings settings = null;
        this.selectStmt = this.prepareStmt(SELECT);
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                settings = new ConfigSettings();
                this.stmtPhase = 1;
                this.colIndex = 1;
                for (int i = 0; i < settings.csSnmp.length; ++i) {
                    this.getSnmpSettings(settings.csSnmp[i]);
                }
                settings.csTecServer = this.getString(this.resultSet);
                settings.csTecPort = this.getInt(this.resultSet);
                settings.csRetainCopies = this.getInt(this.resultSet);
                settings.csRetainDays = this.getInt(this.resultSet);
                settings.csDellogDays = this.getInt(this.resultSet);
                SmtpSettings email = TConfigSettings.getSmtpSettings();
                if (email != null) {
                    settings.csSmtp = email;
                    continue;
                }
                settings.csSmtp.ssServer = this.getString(this.resultSet);
                settings.csSmtp.ssPort = this.getInt(this.resultSet);
                settings.csSmtp.ssReplyTo = this.getString(this.resultSet);
                settings.csSmtp.ssReturn = this.getString(this.resultSet);
                settings.csSmtp.ssDfltDomain = this.getString(this.resultSet);
            }
            if (settings == null && throwException) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getConfigSettings");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0087E", null));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"getConfigSettings", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
        }
        ConfigSettings traceResult = settings;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getConfigSettings", (Object)traceResult);
        }
        return traceResult;
    }

    private void getSnmpSettings(SnmpDestination snmp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"getSnmpSettings", (String)"snmp");
        }
        snmp.csSnmpServer = this.getString(this.resultSet);
        snmp.csSnmpPort = this.getInt(this.resultSet);
        snmp.csSnmpCommunity = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getSnmpSettings");
        }
    }

    public ConfigSettings getConfigSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"getConfigSettings", (String)"");
        }
        ConfigSettings traceResult = this.getConfigSettings(true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getConfigSettings", (Object)traceResult);
        }
        return traceResult;
    }

    private void setNetwork(PreparedStatement stmt, ConfigSettings settings) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"setNetwork", (String)"stmt, settings");
        }
        for (int i = 0; i < settings.csSnmp.length; ++i) {
            SnmpDestination snmp = settings.csSnmp[i];
            this.setString(stmt, snmp.csSnmpServer);
            this.setInt(stmt, snmp.csSnmpPort);
            this.setString(stmt, snmp.csSnmpCommunity);
        }
        this.setString(stmt, settings.csTecServer);
        this.setInt(stmt, settings.csTecPort);
        TConfigSettings.saveSmtpSettings(settings.csSmtp);
        this.setInt(stmt, settings.csDellogDays);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"setNetwork");
        }
    }

    private void setRetention(PreparedStatement stmt, ConfigSettings settings) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"setRetention", (String)"stmt, settings");
        }
        this.setInt(stmt, settings.csRetainCopies);
        this.setInt(stmt, settings.csRetainDays);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"setRetention");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ConfigSettings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"insert", (String)"settings");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setNetwork(this.insertStmt, settings);
            this.setString(this.insertStmt, settings.csSmtp.ssServer);
            this.setInt(this.insertStmt, settings.csSmtp.ssPort);
            this.setString(this.insertStmt, settings.csSmtp.ssReplyTo);
            this.setString(this.insertStmt, settings.csSmtp.ssReturn);
            this.setString(this.insertStmt, settings.csSmtp.ssDfltDomain);
            this.setRetention(this.insertStmt, settings);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        finally {
            this.closeInsert();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateNetwork(ConfigSettings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"updateNetwork", (String)"settings");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(UPDATE_NETWORK);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setNetwork(this.updateStmt, settings);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"updateNetwork", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            this.closeUpdate();
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"updateNetwork", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRetention(ConfigSettings settings) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"updateRetention", (String)"settings");
        }
        int result = 0;
        this.updateStmt = this.prepareStmt(UPDATE_RETENTION);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setRetention(this.updateStmt, settings);
            result = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"updateRetention", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        finally {
            this.closeUpdate();
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"updateRetention", (int)traceResult);
        }
        return traceResult;
    }

    public static synchronized SmtpSettings getSmtpSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"getSmtpSettings", (String)"");
        }
        FileInputStream fStream = null;
        ObjectInputStream oStream = null;
        SmtpSettings smtp = null;
        Exception exception = null;
        File emailFile = new File(EMAIL_FILENAME);
        if (emailFile.canRead()) {
            try {
                fStream = new FileInputStream(emailFile);
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
            if (fStream != null) {
                try {
                    oStream = new ObjectInputStream(fStream);
                }
                catch (IOException e) {
                    exception = e;
                    MessageLog.logException((String)"STS0205E", (Exception)e, (Object)EMAIL_FILENAME);
                    try {
                        fStream.close();
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                }
                if (oStream != null) {
                    try {
                        smtp = (SmtpSettings)oStream.readObject();
                    }
                    catch (EOFException e) {
                        exception = e;
                    }
                    catch (ClassNotFoundException e) {
                        exception = e;
                        MessageLog.logMessage((String)"STS0205E", (Object)EMAIL_FILENAME);
                        MessageLog.logException((String)"STS0049W", (Exception)e, (Object)EMAIL_FILENAME);
                    }
                    catch (IOException e) {
                        exception = e;
                        MessageLog.logException((String)"STS0205E", (Exception)e, (Object)EMAIL_FILENAME);
                    }
                    catch (ClassCastException e) {
                        exception = e;
                        MessageLog.logMessage((String)"STS0205E", (Object)EMAIL_FILENAME);
                        MessageLog.logException((String)"STS0050W", (Exception)e, (Object)EMAIL_FILENAME);
                    }
                    try {
                        oStream.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (exception != null) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"getSmtpSettings", (Throwable)exception);
                        TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getSmtpSettings");
                    }
                    Object[] args = new Object[]{EMAIL_FILENAME};
                    throw new GeneralException("STS0205E", args);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"getSmtpSettings", smtp);
        }
        return smtp;
    }

    public static synchronized void saveSmtpSettings(SmtpSettings smtp) throws GeneralException {
        boolean written;
        IOException exception;
        block16: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TConfigSettings.class.getName(), (String)"saveSmtpSettings", (String)"smtp");
            }
            FileOutputStream fStream = null;
            ObjectOutputStream oStream = null;
            exception = null;
            written = false;
            try {
                fStream = new FileOutputStream(EMAIL_FILENAME);
            }
            catch (IOException e) {
                exception = e;
                MessageLog.logException((String)"STS0206E", (Exception)e, (Object)EMAIL_FILENAME);
            }
            if (fStream != null) {
                try {
                    oStream = new ObjectOutputStream(fStream);
                    oStream.writeObject(smtp);
                    written = true;
                }
                catch (IOException e) {
                    exception = e;
                    MessageLog.logException((String)"STS0206E", (Exception)e, (Object)EMAIL_FILENAME);
                }
                if (oStream != null) {
                    try {
                        oStream.close();
                    }
                    catch (IOException e) {
                        exception = e;
                        if (written) {
                            MessageLog.logException((String)"STS0206E", (Exception)e, (Object)EMAIL_FILENAME);
                            written = false;
                        }
                        break block16;
                    }
                }
                try {
                    fStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (exception != null && TraceLogger.enableTrace) {
            TraceLogger.exception((String)TConfigSettings.class.getName(), (String)"saveSmtpSettings", (Throwable)exception);
        }
        if (!written) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"saveSmtpSettings");
            }
            Object[] args = new Object[]{EMAIL_FILENAME};
            throw new GeneralException("STS0206E", args);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TConfigSettings.class.getName(), (String)"saveSmtpSettings");
        }
    }
}

