/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TStatComputer;

public class TFoundFilesystem
extends StorageRepositoryAccessor {
    public static final String TABLE_NAME = "t_found_filesystem";
    public static final String ID_COLUMN = "filesystem_id";
    private static final String SELECT_BY_COMPUTER_AND_SCANNER = "select filesystem_id, mount_point from t_found_filesystem where computer_id = ? and scanning_comp_id = ?";
    private static final String SELECT_BY_MOUNT_POINT = "select filesystem_id, scanning_comp_id from t_found_filesystem where computer_id = ? and mount_point = ?";
    private static final String SELECT_MISSING = "select f.filesystem_id, s.scan_time, s.removed_time from t_found_filesystem f, t_res_share s where f.filesystem_id = s.resource_id and s.computer_id = ? and f.computer_id = ? and s.scan_time <> ? and s.resource_type = 68";
    private static final String SELECT_SCANNING_COMPID = "select distinct scanning_comp_id from t_found_filesystem where computer_id = ? and scanning_comp_id > 0";
    private static final String SELECT_NAS_FILESYSTEMS = "select f.computer_id, f.filesystem_id, f.mount_point, f.scanning_comp_id, d.domain_id from t_found_filesystem f, t_res_domain d, t_res_share s where f.filesystem_id = s.resource_id and s.resource_type = 68 and s.computer_id = d.domain_id union all select computer_id, filesystem_id, mount_point, scanning_comp_id, -1 from t_found_filesystem where filesystem_id not in (select resource_id from t_res_share, t_res_domain where computer_id = domain_id and resource_type = 68) order by 1";
    private static final String SELECT_FAKE_FILESYSTEMS = "select filesystem_id, mount_point, scanning_comp_id from t_found_filesystem where computer_id = ? and scanning_comp_id > 0 and non_root = '1'";
    private static final String UPDATE_SCANNING_AGENT = "update t_found_filesystem set scanning_comp_id = ? where filesystem_id = ?";
    private static final String INSERT = "insert into t_found_filesystem (filesystem_id, computer_id, scanning_comp_id, mount_point, non_root) values (?,?,0,?,?)";

    public TFoundFilesystem(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"TFoundFilesystem", (String)"dbc");
        }
        this.tableName = TABLE_NAME;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"TFoundFilesystem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIDs(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getIDs", (String)"computer");
        }
        RepositoryAccessor fsAccessor = null;
        int newFsCount = 0;
        boolean anyNew = false;
        try {
            this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
            LogicalDisk lDisk = computer.cmpLogicalDisk;
            while (lDisk != null) {
                Filesystem fs = lDisk.ldFilesystem;
                if (fs != null && fs.fsID <= 0) {
                    this.setPhase();
                    this.setInt(this.selectStmt, computer.cmpID);
                    this.setString(this.selectStmt, fs.fsMountPoint);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    this.getPhase();
                    if (this.nextResult()) {
                        fs.fsID = this.getInt(this.resultSet);
                    } else {
                        fs.fsNewFilesystem = true;
                        anyNew = true;
                        fs.fsComputerID = computer.cmpID;
                        if (fsAccessor == null) {
                            fsAccessor = new TResFS(this.dbc);
                            ((TResFS)fsAccessor).prepSelectByMountPoint();
                        }
                        ((TResFS)fsAccessor).getByMountPoint(fs);
                    }
                    if (fs.fsID <= 0) {
                        ++newFsCount;
                    }
                    this.closeResultSet();
                }
                lDisk = lDisk.ldNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getIDs", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            if (fsAccessor != null) {
                fsAccessor.cleanup();
            }
            this.cleanup();
        }
        if (newFsCount > 0) {
            this.allocIDs(computer, newFsCount);
        }
        boolean traceResult = anyNew;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getIDs", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIDsForProbe(Computer computer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getIDsForProbe", (String)"computer");
        }
        int newFsCount = 0;
        boolean updateScheduler = false;
        try {
            this.selectStmt = this.prepareStmt(SELECT_BY_MOUNT_POINT);
            LogicalDisk lDisk = computer.cmpLogicalDisk;
            while (lDisk != null) {
                Filesystem fs = lDisk.ldFilesystem;
                if (fs != null && fs.fsID <= 0) {
                    this.setPhase();
                    this.setInt(this.selectStmt, computer.cmpID);
                    this.setString(this.selectStmt, fs.fsMountPoint);
                    this.stmtPhase = 3;
                    this.resultSet = this.selectStmt.executeQuery();
                    this.getPhase();
                    if (this.nextResult()) {
                        fs.fsID = this.getInt(this.resultSet);
                        fs.fsScanningCompID = this.getInt(this.resultSet);
                        if (fs.fsScanningCompID > 0) {
                            updateScheduler = true;
                        }
                    } else {
                        ++newFsCount;
                    }
                    this.closeResultSet();
                }
                lDisk = lDisk.ldNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getIDsForProbe", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.cleanup();
        }
        if (newFsCount > 0) {
            this.allocIDs(computer, newFsCount);
        }
        boolean traceResult = updateScheduler;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getIDsForProbe", (boolean)traceResult);
        }
        return traceResult;
    }

    private void allocIDs(Computer computer, int newFsCount) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"allocIDs", (String)"computer, newFsCount");
        }
        int identifier = TFoundFilesystem.getIdentifier(1, newFsCount, this.dbc);
        LogicalDisk lDisk = computer.cmpLogicalDisk;
        while (lDisk != null) {
            Filesystem fs = lDisk.ldFilesystem;
            if (fs != null && fs.fsID <= 0) {
                fs.fsID = identifier++;
            }
            lDisk = lDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"allocIDs");
        }
    }

    public Share getMissingFilesystems(int shareID, int filerCompID, long discoveryTime) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getMissingFilesystems", (String)"shareID, filerCompID, discoveryTime");
        }
        Share shareList = null;
        this.selectStmt = this.prepareStmt(SELECT_MISSING);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, shareID);
            this.setInt(this.selectStmt, filerCompID);
            this.setTimestamp(this.selectStmt, discoveryTime);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                Share share = new Share();
                share.shComputerID = shareID;
                share.shResourceID = this.getInt(this.resultSet);
                share.shResourceType = (short)68;
                share.shScanTime = this.getTimestamp(this.resultSet);
                share.shRemovedTime = this.getTimestamp(this.resultSet);
                share.shNext = shareList;
                shareList = share;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getMissingFilesystems", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Share traceResult = shareList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getMissingFilesystems", traceResult);
        }
        return traceResult;
    }

    public void prepGetScanningAgent() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_SCANNING_COMPID);
    }

    public boolean getScanningAgent(MutableInteger resultID) throws GeneralException {
        boolean status;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getScanningAgent", (String)"resultID");
        }
        if (status = this.nextResult()) {
            try {
                this.getPhase();
                resultID.value = this.getInt(this.resultSet);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getScanningAgent", (Throwable)e);
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
        } else {
            this.closeResultSet();
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getScanningAgent", (boolean)traceResult);
        }
        return traceResult;
    }

    public LinkedInteger getAllScanningAgents(int filerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getAllScanningAgents", (String)"filerID");
        }
        LinkedInteger head = null;
        this.execQueryByID(filerID);
        while (this.nextResult()) {
            try {
                LinkedInteger li = new LinkedInteger();
                this.getPhase();
                li.value = this.getInt(this.resultSet);
                li.next = head;
                head = li;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getAllScanningAgents", (Throwable)e);
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
        }
        this.closeResultSet();
        LinkedInteger traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getAllScanningAgents", traceResult);
        }
        return traceResult;
    }

    public void getFilerProbeFS(NasFiler filerList, int agentID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getFilerProbeFS", (String)"filerList, agentID");
        }
        this.selectStmt = this.prepareStmt(SELECT_BY_COMPUTER_AND_SCANNER);
        try {
            NasFiler filer = filerList;
            while (filer != null) {
                if (!Constants.supportsFullProbe((short)filer.nfOSType)) {
                    this.setPhase();
                    this.setInt(this.selectStmt, filer.nfComputerID);
                    this.setInt(this.selectStmt, agentID);
                    this.resultSet = this.selectStmt.executeQuery();
                    while (this.nextResult()) {
                        Filesystem fs = new Filesystem();
                        this.getPhase();
                        fs.fsID = this.getInt(this.resultSet);
                        fs.fsMountPoint = this.getString(this.resultSet);
                        fs.fsNext = filer.nfFilesystems;
                        filer.nfFilesystems = fs;
                    }
                    this.closeResultSet();
                }
                filer = filer.nfNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getFilerProbeFS", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getFilerProbeFS");
        }
    }

    public void getFakeFilesystems(NasFiler filer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getFakeFilesystems", (String)"filer");
        }
        this.selectStmt = this.prepareStmt(SELECT_FAKE_FILESYSTEMS);
        try {
            while (filer != null) {
                if (!Constants.supportsFullProbe((short)filer.nfOSType) || filer.nfOSType == 8) {
                    filer = filer.nfNext;
                    continue;
                }
                this.setPhase();
                this.setInt(this.selectStmt, filer.nfComputerID);
                this.resultSet = this.selectStmt.executeQuery();
                while (this.nextResult()) {
                    Filesystem fs = new Filesystem();
                    this.getPhase();
                    fs.fsID = this.getInt(this.resultSet);
                    fs.fsMountPoint = this.getString(this.resultSet);
                    fs.fsScanningCompID = this.getInt(this.resultSet);
                    fs.fsType = (short)16;
                    fs.fsNext = filer.nfFilesystems;
                    filer.nfFilesystems = fs;
                }
                this.closeResultSet();
                filer = filer.nfNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getFakeFilesystems", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getFakeFilesystems");
        }
    }

    public NasFilesystem[] getNasFilesystems() throws GeneralException {
        NasFilesystem node;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"getNasFilesystems", (String)"");
        }
        NasFilesystem head = null;
        NasFilesystem prev = null;
        boolean include = true;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(SELECT_NAS_FILESYSTEMS);
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                int computerID = this.getInt(this.resultSet);
                if (!include) continue;
                node = new NasFilesystem();
                node.nflComputerID = computerID;
                node.nflFsID = this.getInt(this.resultSet);
                node.nflFsName = this.getString(this.resultSet);
                node.nflAgentID = this.getInt(this.resultSet);
                int domainID = this.getInt(this.resultSet);
                node.nflSeenFromWindows = domainID > 0;
                if (prev != null) {
                    prev.nflNext = node;
                } else {
                    head = node;
                }
                prev = node;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"getNasFilesystems", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList computer = new TStatComputer(this.dbc).selectComputersAndDomains();
        while (computer != null) {
            node = head;
            while (node != null) {
                if (node.nflComputerID == computer.nlID) {
                    node.nflDomainName = computer.nlName;
                }
                node = node.nflNext;
            }
            computer = computer.nlNext;
        }
        NasFilesystem[] traceResult = (NasFilesystem[])Packer.pack(head);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"getNasFilesystems", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepUpdateScanAgent() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_SCANNING_AGENT);
    }

    public void updateScanningAgent(NasFilesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"updateScanningAgent", (String)"fsList");
        }
        try {
            NasFilesystem nfs = fsList;
            while (nfs != null) {
                this.setPhase();
                this.setInt(this.updateStmt, nfs.nflAgentID);
                this.setInt(this.updateStmt, nfs.nflFsID);
                this.executeUpdate(this.updateStmt);
                nfs = nfs.nflNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"updateScanningAgent", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"updateScanningAgent");
        }
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insert(Computer computer, Filesystem filesystem) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundFilesystem.class.getName(), (String)"insert", (String)"computer, filesystem");
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, filesystem.fsID);
            this.setInt(this.insertStmt, computer.cmpID);
            this.setString(this.insertStmt, filesystem.fsMountPoint);
            this.setBoolean(this.insertStmt, filesystem.fsType == 16);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundFilesystem.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundFilesystem.class.getName(), (String)"insert");
        }
    }
}

