/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Like;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class TGroup2Mask
extends RepositoryAccessor {
    private static final String INSERT = "insert into t_group2mask ( group_id, masktype, mask ) values (?, ?, ?)";
    private static final String DELETE = "delete from t_group2mask where group_id = ? and mask = ?";
    private static final String SELECT_MASKS_BY_GID = "select group_id, masktype, mask from t_group2mask where group_id = ? ";
    private static final String DELETE_MASKS_BY_GID = "delete from t_group2mask where group_id = ? ";
    private static final String SELECT_MASKS_BY_GROUP_TYPE = "select g2m.group_id, masktype, mask from t_group2mask g2m, t_group g where g2m.group_id = g.group_id and g.group_type = ?";
    private static final String COMPUTERSELECT = " select res.HOST_NAME, res.COMPUTER_ID from t_res_host res, t_stat_computer stat where res.computer_id = stat.computer_id and HOST_NAME like ? ";
    private static final String FSSELECT = "select MOUNT_POINT, FILESYSTEM_ID, COMPUTER_ID from t_res_filesystem where MOUNT_POINT like ?";

    public TGroup2Mask(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"TGroup2Mask", (String)"dbc");
        }
        this.tableName = "t_group2mask";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"TGroup2Mask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInsertDelete(int groupID, NameList toAddList, NameList toRemoveList, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete", (String)"groupID, toAddList, toRemoveList, commit");
        }
        try {
            NameList tempList;
            if (toRemoveList != null) {
                this.deleteStmt = this.prepareStmt(DELETE);
                this.setPhase();
                tempList = toRemoveList;
                do {
                    this.colIndex = 1;
                    this.setInt(this.deleteStmt, groupID);
                    this.setString(this.deleteStmt, tempList.nlName);
                    this.executeUpdate(this.deleteStmt);
                    this.deleteStmt.clearParameters();
                } while ((tempList = tempList.nlNext) != null);
            }
            if (toAddList != null) {
                this.insertStmt = this.prepareStmt(INSERT);
                this.setPhase();
                tempList = toAddList;
                do {
                    this.colIndex = 1;
                    this.setInt(this.insertStmt, groupID);
                    this.setShort(this.insertStmt, tempList.nlInfo);
                    this.setString(this.insertStmt, tempList.nlName);
                    this.executeUpdate(this.insertStmt);
                    this.insertStmt.clearParameters();
                } while ((tempList = tempList.nlNext) != null);
            }
            if (commit) {
                this.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete", (Throwable)e);
            }
            this.sqlError(e);
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete", (Throwable)ge);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete");
            }
            throw ge;
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete", (Throwable)e);
            }
            e.printStackTrace();
        }
        finally {
            try {
                if (this.deleteStmt != null) {
                    this.deleteStmt.close();
                }
                if (this.insertStmt != null) {
                    this.insertStmt.close();
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete", (Throwable)e);
                }
                this.sqlError(e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"handleInsertDelete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMasksByGID(int groupID, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"deleteMasksByGID", (String)"groupID, commit");
        }
        this.deleteStmt = this.prepareStmt(DELETE_MASKS_BY_GID);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, groupID);
            this.executeUpdate(this.deleteStmt);
            if (commit) {
                this.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"deleteMasksByGID", (Throwable)e);
            }
            this.sqlError(e);
        }
        finally {
            try {
                if (this.deleteStmt != null) {
                    this.deleteStmt.close();
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"deleteMasksByGID", (Throwable)e);
                }
                this.sqlError(e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"deleteMasksByGID");
        }
    }

    public NameList retrieveMasksByGID(int groupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"retrieveMasksByGID", (String)"groupID");
        }
        this.selectStmt = this.prepareStmt(SELECT_MASKS_BY_GID);
        NameList traceResult = this.retrieveMasks(groupID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"retrieveMasksByGID", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList retrieveMasksByGroupType(int grpType, String resourceName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"retrieveMasksByGroupType", (String)"grpType, resourceName");
        }
        NameList matchingList = null;
        Like like = new Like('*', '?', true);
        this.selectStmt = this.prepareStmt(SELECT_MASKS_BY_GROUP_TYPE);
        NameList maskList = this.retrieveMasks(grpType);
        while (maskList != null) {
            if (like.isLike(resourceName, maskList.nlName)) {
                NameList element = new NameList();
                element.nlID = maskList.nlID;
                element.nlName = maskList.nlName;
                element.nlNext = matchingList;
                matchingList = element;
            }
            maskList = maskList.nlNext;
        }
        NameList traceResult = matchingList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"retrieveMasksByGroupType", traceResult);
        }
        return traceResult;
    }

    private NameList retrieveMasks(int delimiter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"retrieveMasks", (String)"delimiter");
        }
        NameList head = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, delimiter);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                NameList element = new NameList();
                element.nlID = this.getInt(this.resultSet);
                element.nlInfo = this.getShort(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                element.nlNext = head;
                head = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"retrieveMasks", (Throwable)e);
            }
            this.stmtType = 0;
            this.cleanup();
            this.sqlError(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"retrieveMasks");
            }
            throw new GeneralException(e.getMessage());
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"retrieveMasks", traceResult);
        }
        return traceResult;
    }

    public NameList getResourcesForList(NameList maskList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"getResourcesForList", (String)"maskList");
        }
        NameList returnList = null;
        try {
            NameList currentList = maskList;
            while (currentList != null) {
                NameList resultList;
                NameList tempList = resultList = this.getMatchingResources(currentList.nlInfo, currentList.nlName);
                NameList localList = null;
                while (tempList != null) {
                    localList = new NameList();
                    localList.nlInfo = tempList.nlInfo;
                    localList.nlName = tempList.nlName;
                    localList.nlID = tempList.nlID;
                    localList.nlNext = returnList;
                    returnList = localList;
                    tempList = tempList.nlNext;
                }
                currentList = currentList.nlNext;
            }
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"getResourcesForList", (Throwable)ge);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"getResourcesForList");
            }
            throw ge;
        }
        NameList traceResult = returnList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"getResourcesForList", traceResult);
        }
        return traceResult;
    }

    public NameList getMatchingResources(short nlInfo, String nlName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"getMatchingResources", (String)"nlInfo, nlName");
        }
        try {
            if (nlInfo == 95) {
                this.selectStmt = this.prepareStmt(COMPUTERSELECT);
            } else if (nlInfo == 96) {
                this.selectStmt = this.prepareStmt(FSSELECT);
            }
        }
        catch (GeneralException ge) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"getMatchingResources", (Throwable)ge);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"getMatchingResources");
            }
            throw ge;
        }
        String mask = TGroup2Mask.replaceString(nlName, "*", "%");
        mask = TGroup2Mask.replaceString(mask, "?", "_");
        NameList head = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setString(this.selectStmt, mask);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList element = new NameList();
                this.colIndex = 1;
                element.nlName = this.getString(this.resultSet);
                element.nlID = this.getInt(this.resultSet);
                element.nlInfo = nlInfo;
                element.nlNext = head;
                head = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Mask.class.getName(), (String)"getMatchingResources", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"getMatchingResources");
            }
            throw new GeneralException(e.getMessage());
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"getMatchingResources", traceResult);
        }
        return traceResult;
    }

    private static String replaceString(String origString, String from, String to) {
        int index1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Mask.class.getName(), (String)"replaceString", (String)"origString, from, to");
        }
        if ((index1 = from.indexOf(to)) != -1) {
            String traceResult = origString;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"replaceString", (Object)traceResult);
            }
            return traceResult;
        }
        index1 = 0;
        int index2 = origString.indexOf(from);
        if (index2 == -1) {
            String traceResult = origString;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"replaceString", (Object)traceResult);
            }
            return traceResult;
        }
        String tempString = new String();
        String newString = new String();
        do {
            tempString = origString.substring(index1, index2);
            tempString = tempString + to;
            newString = newString + tempString;
            index1 = index2 + from.length();
            if (index1 >= origString.length()) {
                index2 = -1;
                tempString = null;
                continue;
            }
            index2 = origString.indexOf(from, index1);
            if (index2 != -1) continue;
            tempString = origString.substring(index1);
        } while (index2 != -1);
        if (tempString != null) {
            newString = newString + tempString;
        }
        String traceResult = newString;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Mask.class.getName(), (String)"replaceString", (Object)traceResult);
        }
        return traceResult;
    }
}

