/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResStorExtent;
import org.eclipse.aperi.repository.table.TResVolGroup;

public class TResChunk
extends StorageRepositoryAccessor {
    private static String SELECT = "select a.disk_id, a.collection_id, a.logical_disk_id, a.seqno,";
    private static String INSERT;
    private static final String BY_COLLECTION = " where a.collection_id = ? order by a.disk_id desc, a.offset desc";
    private static final String BY_LOCATION = ", t_res_chunk b where a.collection_id = b.collection_id and b.disk_id = ? and b.offset = ? order by a.seqno desc";
    private static final String BY_DISKID = " where a.disk_id = ? order by a.offset desc";
    private static final String DELETE_BY_LOCATION = "delete from t_res_chunk where disk_id = ? and offset >= ? and offset < ?";
    private static final String DELETE_BY_LOGICAL_DISK = "delete from t_res_chunk where logical_disk_id = ?";
    private long chunkSize = 0L;
    private short seqNo = 0;
    TResLogicalDisk ldAccessor = new TResLogicalDisk(this.dbc);
    TResVolGroup vgAccessor = new TResVolGroup(this.dbc);
    TResComputer cmpAccessor = new TResComputer(this.dbc);
    TResChunkCollection ccAccessor = new TResChunkCollection(this.dbc);
    TResDiskArray ssAccessor = new TResDiskArray(this.dbc);
    TResDevAccess daAccessor = new TResDevAccess(this.dbc);
    TResStorExtent seAccessor = new TResStorExtent(this.dbc);
    TResDevice devAccessor = new TResDevice(this.dbc);
    boolean autoCommit = false;
    int numLuns = 0;

    public TResChunk(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"TResChunk", (String)"dbc");
        }
        this.tableName = "t_res_chunk";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"TResChunk");
        }
    }

    public void prepSelectByCollection() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT + BY_COLLECTION);
    }

    public Chunk getChunksByCollection(ChunkCollection collection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"getChunksByCollection", (String)"collection");
        }
        Chunk chkList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, collection.ccID);
            chkList = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"getChunksByCollection", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Chunk traceResult = chkList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"getChunksByCollection", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepSelectByLocation() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT + BY_LOCATION);
    }

    public Chunk getChunksByLocation(Chunk baseChk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"getChunksByLocation", (String)"baseChk");
        }
        Chunk chkList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, baseChk.chkDiskID);
            this.setLong(this.selectStmt, baseChk.chkOffset);
            chkList = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"getChunksByLocation", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Chunk traceResult = chkList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"getChunksByLocation", traceResult);
        }
        return traceResult;
    }

    public void prepSelectByDiskID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT + BY_DISKID);
    }

    public Chunk getChunksByDiskID(int diskID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"getChunksByDiskID", (String)"diskID");
        }
        Chunk chkList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, diskID);
            chkList = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"getChunksByDiskID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Chunk traceResult = chkList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"getChunksByDiskID", (Object)traceResult);
        }
        return traceResult;
    }

    private Chunk fetchChunks() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"fetchChunks", (String)"");
        }
        Chunk chkList = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        while (this.nextResult()) {
            Chunk chk = new Chunk();
            this.colIndex = 1;
            chk.chkDiskID = this.getInt(this.resultSet);
            chk.chkCollectionID = this.getInt(this.resultSet);
            chk.chkLogicalDiskID = this.getInt(this.resultSet);
            chk.chkSeqno = this.getShort(this.resultSet);
            chk.chkPartition = this.getShort(this.resultSet);
            chk.chkUnitSize = this.getInt(this.resultSet);
            chk.chkSize = this.getLong(this.resultSet);
            chk.chkOffset = this.getLong(this.resultSet);
            chk.chkHasDB = this.getBoolean(this.resultSet);
            chk.chkNextInCollection = chkList;
            chkList = chk;
        }
        this.closeResultSet();
        Chunk traceResult = chkList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"fetchChunks", traceResult);
        }
        return traceResult;
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOCATION);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"closeSave");
        }
    }

    public void saveChunks(Chunk chkList, boolean deleteBeforeInsert, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"saveChunks", (String)"chkList");
        }
        try {
            Chunk chk = chkList;
            while (chk != null) {
                if (deleteBeforeInsert) {
                    this.deleteChunk(chk);
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)3, (String)TResChunk.class.getName(), (String)"saveChunks", (String)(" Inserting chunk: " + chk + "\n"));
                }
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, chk.chkDiskID);
                this.setInt(this.insertStmt, chk.chkCollectionID);
                this.setInt(this.insertStmt, chk.chkLogicalDiskID);
                this.setShort(this.insertStmt, chk.chkSeqno);
                this.setShort(this.insertStmt, chk.chkPartition);
                this.setLong(this.insertStmt, chk.chkOffset);
                this.setLong(this.insertStmt, chk.chkSize);
                this.setInt(this.insertStmt, chk.chkUnitSize);
                this.setBoolean(this.insertStmt, chk.chkHasDB);
                this.executeUpdate(this.insertStmt);
                chk = chk.chkNextInCollection;
            }
            if (commit) {
                this.dbc.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"saveChunks", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"saveChunks");
        }
    }

    private void deleteChunk(Chunk chk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"deleteChunk", (String)"chk");
        }
        try {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage((int)3, (String)TResChunk.class.getName(), (String)"deleteChunk", (String)(" Deleting chunk: " + chk));
            }
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, chk.chkDiskID);
            this.setLong(this.deleteStmt, chk.chkOffset);
            this.setLong(this.deleteStmt, chk.chkOffset + chk.chkSize);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"deleteChunk", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"deleteChunk");
        }
    }

    public void prepDeleteByLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"prepDeleteByLogicalDisk", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOGICAL_DISK);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"prepDeleteByLogicalDisk");
        }
    }

    public void ssPopulateChunkInfo(int[] ss_ids) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"ssPopulateChunkInfo", (String)"ss_ids");
        }
        ResultSet rsPools = null;
        short ssType = -1;
        for (int i = 0; i < ss_ids.length; ++i) {
            ssType = this.cmpAccessor.getStorageSubsystemType(ss_ids[i]);
            rsPools = this.vgAccessor.getStoragePools(ss_ids[i]);
            this.buildSSChunkInfo(rsPools, ssType, ss_ids[i]);
            this.numLuns = 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"ssPopulateChunkInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSSChunkInfo(ResultSet rsPools, short ssType, int ss_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)"rsPool, ssType");
        }
        try {
            this.autoCommit = this.dbc.getAutoCommit();
            this.dbc.setAutoCommit(true);
            this.ccAccessor.prepInsert();
            this.ccAccessor.prepDeleteByLogicalDisk();
            this.prepSave();
            this.prepDeleteByLogicalDisk();
            this.ldAccessor.setSSLogicalDiskType(ss_id, (byte)1);
            while (rsPools.next()) {
                short[] raidArray;
                int pool_id = rsPools.getInt(1);
                int numDisks = 0;
                Hashtable disk_ids = new Hashtable();
                ResultSet rsDisks = this.daAccessor.getPoolDisks(ss_id, pool_id);
                int i = 0;
                while (rsDisks.next()) {
                    DiskID diskID = new DiskID();
                    diskID.diskId = rsDisks.getInt(1);
                    this.devAccessor.setSpare(diskID.diskId, true);
                    diskID.isSpare = false;
                    disk_ids.put(new Integer(i), diskID);
                    ++numDisks;
                    ++i;
                }
                SQLUtil.closeResources(rsDisks);
                ResultSet rsLuns = this.ldAccessor.getLUNs(pool_id);
                long offset = 0L;
                int logical_disk_id = -1;
                long capacity = 0L;
                this.seqNo = 0;
                short width = 0;
                boolean isDS = false;
                if (ssType == 27 || ssType == 25) {
                    isDS = true;
                }
                if (!isDS) {
                    width = this.getWidth(ssType, pool_id, numDisks);
                }
                short raidLevel = 11;
                String raids = rsPools.getString(3);
                if (raids != null && (raidArray = this.getRaid(raids)).length != 0) {
                    raidLevel = raidArray[0];
                }
                while (rsLuns.next()) {
                    this.dbc.setAutoCommit(true);
                    ++this.numLuns;
                    logical_disk_id = rsLuns.getInt(1);
                    capacity = rsLuns.getLong(3);
                    ChunkCollection cc = null;
                    if (isDS) {
                        cc = this.buildDSChunkCollections(logical_disk_id, pool_id, capacity, numDisks, raidLevel, disk_ids, offset, ssType);
                    } else if (ssType == 12 || ssType == 15) {
                        cc = this.buildChunkCollections(logical_disk_id, capacity, numDisks, width, raidLevel, disk_ids, offset, ssType);
                    } else {
                        if (numDisks == 0) {
                            disk_ids = this.buildFakeDisk(ss_id, pool_id, ssType);
                            numDisks = 1;
                        }
                        cc = this.buildGenericChunkCollections(logical_disk_id, capacity, numDisks, width, raidLevel, disk_ids, offset, ssType);
                    }
                    LogicalDisk ld = new LogicalDisk();
                    ld.ldID = logical_disk_id;
                    this.dbc.setAutoCommit(false);
                    this.ccAccessor.deleteByLogicalDisk(ld);
                    this.deleteByLogicalDisk(ld);
                    ld = null;
                    this.ccAccessor.insertCollections(cc);
                    ChunkCollection ccList = cc;
                    while (ccList != null) {
                        this.saveChunks(ccList.ccChunkList, false, false);
                        ccList = ccList.ccNext;
                    }
                    if (ssType == 15) {
                        this.seqNo = (short)(this.seqNo + numDisks);
                    }
                    offset += this.chunkSize;
                    this.dbc.commit();
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)(" Processed LUN # " + this.numLuns));
                }
                SQLUtil.closeResources(rsLuns);
            }
            SQLUtil.closeResources(rsPools);
            this.dbc.commit();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        finally {
            try {
                this.dbc.setAutoCommit(this.autoCommit);
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            this.ccAccessor.closeInsert();
            this.ccAccessor.closeDelete();
            this.closeSave();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResChunk.class.getName(), (String)"buildSSChunkInfo");
            }
        }
    }

    public void svcPopulateChunkInfo(int[] svc_ids) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"svcPopulateChunkInfo", (String)"svc_ids");
        }
        ResultSet rsPools = null;
        for (int i = 0; i < svc_ids.length; ++i) {
            rsPools = this.vgAccessor.getStoragePools(svc_ids[i]);
            this.buildSVCChunkInfo(rsPools);
            this.numLuns = 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResChunk.class.getName(), (String)"svcPopulateChunkInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSVCChunkInfo(ResultSet rsPools) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResChunk.class.getName(), (String)"buildSVCChunkInfo", (String)"rsPools");
        }
        try {
            this.ccAccessor.prepInsert();
            this.ccAccessor.prepDeleteByLogicalDisk();
            this.prepSave();
            this.prepDeleteByLogicalDisk();
            while (rsPools.next()) {
                int pool_id = rsPools.getInt(1);
                int extent_size = rsPools.getInt(2);
                ResultSet rsLUNs = this.ldAccessor.getLUNs(pool_id);
                Chunk prevChunk = null;
                Hashtable<Integer, Long> diskOffsets = new Hashtable<Integer, Long>();
                while (rsLUNs.next()) {
                    ++this.numLuns;
                    int chkSeqno = 0;
                    long offset = 0L;
                    prevChunk = null;
                    int logical_disk_id = rsLUNs.getInt(1);
                    short vdisk_type = rsLUNs.getShort(2);
                    this.ldAccessor.setLogicalDiskType(logical_disk_id, this.ldAccessor.getSVCLogicalDiskType(vdisk_type));
                    ChunkCollection cc = new ChunkCollection();
                    cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                    cc.ccSeqno = 0;
                    cc.ccStripingSize = -1;
                    cc.ccLogicalDiskID = logical_disk_id;
                    cc.ccType = this.getSVCChunkCollectionType(vdisk_type);
                    ResultSet mDisks = this.ldAccessor.getSVCMDisksForVDisk(logical_disk_id);
                    while (mDisks.next()) {
                        int disk_id = mDisks.getInt(1);
                        int numExtents = mDisks.getInt(2);
                        Long offsetObj = (Long)diskOffsets.get(new Integer(disk_id));
                        offset = offsetObj == null ? 0L : offsetObj;
                        for (int i = 0; i < numExtents; ++i) {
                            Chunk chk = new Chunk();
                            chk.chkSize = extent_size;
                            chk.chkPartition = (short)-1;
                            chk.chkHasDB = false;
                            int n = chkSeqno;
                            chkSeqno = (short)(chkSeqno + 1);
                            chk.chkSeqno = (short)n;
                            chk.chkUnitSize = extent_size;
                            chk.chkCollection = cc;
                            chk.chkCollectionID = cc.ccID;
                            chk.chkLogicalDiskID = logical_disk_id;
                            chk.chkDiskID = disk_id;
                            chk.chkOffset = offset;
                            offset += chk.chkSize;
                            if (prevChunk == null) {
                                cc.ccChunkList = chk;
                            } else {
                                prevChunk.chkNextInCollection = chk;
                            }
                            prevChunk = chk;
                            ++cc.ccChunkCount;
                        }
                        diskOffsets.put(new Integer(disk_id), new Long(offset));
                    }
                    SQLUtil.closeResources(mDisks);
                    LogicalDisk ld = new LogicalDisk();
                    ld.ldID = logical_disk_id;
                    this.ccAccessor.deleteByLogicalDisk(ld);
                    this.deleteByLogicalDisk(ld);
                    this.ccAccessor.insertCollections(cc);
                    this.saveChunks(cc.ccChunkList, false, false);
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)(" Processed VDisk # " + this.numLuns));
                }
                SQLUtil.closeResources(rsLUNs);
            }
            SQLUtil.closeResources(rsPools);
            this.dbc.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"buildSVCChunkInfo", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        finally {
            this.ccAccessor.closeInsert();
            this.ccAccessor.closeDelete();
            this.closeSave();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResChunk.class.getName(), (String)"buildSVCChunkInfo");
            }
        }
    }

    public byte getSVCChunkCollectionType(short vdisk_type) {
        int ccType = 0;
        if (vdisk_type == 0) {
            ccType = 0;
        } else if (vdisk_type == 1) {
            ccType = 1;
        } else if (vdisk_type == 2) {
            ccType = 0;
        } else if (vdisk_type == 3) {
            ccType = 5;
        }
        return (byte)ccType;
    }

    private ChunkCollection buildChunkCollections(int logical_disk_id, long capacity, int numDisks, short width, short raidLevel, Hashtable disk_ids, long offset, short ssType) throws GeneralException {
        int chunks = 0;
        int dataDisks = 0;
        float copiesOfData = 0.0f;
        ChunkCollection cc = new ChunkCollection();
        TResLogicalDisk ldAccessor = new TResLogicalDisk(this.dbc);
        if (ssType == 12) {
            if (width > 5) {
                dataDisks = chunks = width + 1;
                cc = new ChunkCollection();
                cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                cc.ccSeqno = 1;
                cc.ccStripingSize = 0x100000;
                cc.ccType = (byte)2;
                cc.ccLogicalDiskID = logical_disk_id;
            } else if (width > 1) {
                chunks = width;
                dataDisks = chunks * 2;
                cc = new ChunkCollection();
                int id = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                cc.ccID = id++;
                cc.ccSeqno = 1;
                cc.ccStripingSize = 0x100000;
                cc.ccType = 1;
                cc.ccLogicalDiskID = logical_disk_id;
                cc.ccNext = new ChunkCollection();
                cc.ccNext.ccID = id;
                cc.ccNext.ccSeqno = (short)2;
                cc.ccNext.ccStripingSize = 0x100000;
                cc.ccNext.ccType = (byte)5;
                cc.ccNext.ccLogicalDiskID = logical_disk_id;
            } else {
                dataDisks = chunks = 1;
                ldAccessor.setLogicalDiskType(logical_disk_id, (byte)0);
                cc = new ChunkCollection();
                cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                cc.ccSeqno = 1;
                cc.ccStripingSize = 0x100000;
                cc.ccType = 0;
                cc.ccLogicalDiskID = logical_disk_id;
            }
        }
        if (ssType == 15) {
            dataDisks = chunks = numDisks;
            if (raidLevel == 3) {
                cc.ccStripingSize = -1;
                cc.ccType = (byte)2;
                cc.ccLogicalDiskID = logical_disk_id;
                cc = new ChunkCollection();
                cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                cc.ccSeqno = 1;
                cc.ccStripingSize = -1;
                cc.ccType = 1;
                cc.ccLogicalDiskID = logical_disk_id;
                copiesOfData = 1.0f;
            } else if (raidLevel == 4) {
                cc = new ChunkCollection();
                cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                cc.ccSeqno = 1;
                cc.ccStripingSize = -1;
                cc.ccType = (byte)5;
                cc.ccLogicalDiskID = logical_disk_id;
                copiesOfData = 2.0f;
            } else if (raidLevel == 6 || raidLevel == 0) {
                cc = new ChunkCollection();
                cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                cc.ccSeqno = 1;
                cc.ccStripingSize = -1;
                cc.ccLogicalDiskID = logical_disk_id;
                cc.ccType = raidLevel == 6 ? (byte)6 : (byte)2;
                Integer num = new Integer(numDisks);
                Integer actual_num = new Integer(numDisks - 1);
                if (actual_num == 0) {
                    actual_num = new Integer(1);
                }
                copiesOfData = num.floatValue() / actual_num.floatValue();
            } else {
                ldAccessor.setLogicalDiskType(logical_disk_id, (byte)8);
                int numOfColls = numDisks / 2;
                cc = new ChunkCollection();
                int id = TResLogicalDisk.getIdentifier(1, numOfColls, this.dbc);
                cc.ccID = id++;
                cc.ccSeqno = 1;
                cc.ccStripingSize = -1;
                cc.ccType = (byte)5;
                cc.ccLogicalDiskID = logical_disk_id;
                ChunkCollection tmpCol = cc;
                for (int j = 1; j < numOfColls; ++j) {
                    ChunkCollection cc1 = new ChunkCollection();
                    cc.ccID = id++;
                    cc1.ccSeqno = (short)(j + 1);
                    cc1.ccStripingSize = -1;
                    cc1.ccType = (byte)5;
                    cc1.ccLogicalDiskID = logical_disk_id;
                    cc.ccNext = cc1;
                    cc = cc1;
                }
                cc = tmpCol;
                copiesOfData = 2.0f;
            }
        }
        this.chunkSize = this.getChunkSize(width, copiesOfData, numDisks, capacity, ssType);
        int diskNbr = 0;
        ChunkCollection ccList = cc;
        while (ccList != null) {
            if (ssType == 12) {
                this.seqNo = 0;
            }
            Chunk prevChunk = null;
            for (int i = 0; i < chunks; ++i) {
                Chunk chk = new Chunk();
                chk.chkSize = this.chunkSize;
                chk.chkOffset = offset;
                chk.chkPartition = (short)-1;
                this.seqNo = (short)(this.seqNo + 1);
                chk.chkSeqno = chk.chkSeqno;
                chk.chkUnitSize = 512;
                chk.chkCollection = ccList;
                chk.chkCollectionID = ccList.ccID;
                chk.chkLogicalDiskID = logical_disk_id;
                if (prevChunk == null) {
                    ccList.ccChunkList = chk;
                } else {
                    prevChunk.chkNextInCollection = chk;
                }
                prevChunk = chk;
                if (diskNbr >= numDisks) continue;
                int n = diskNbr;
                diskNbr = (short)(diskNbr + 1);
                chk.chkDiskID = ((DiskID)disk_ids.get((Object)new Integer((int)n))).diskId;
            }
            ccList = ccList.ccNext;
        }
        if (dataDisks < numDisks) {
            for (int i = 0; i < numDisks - dataDisks; ++i) {
                int n = diskNbr;
                diskNbr = (short)(diskNbr + 1);
                DiskID diskID = (DiskID)disk_ids.get(new Integer(n));
                if (diskID == null) continue;
                if (!diskID.isSpare) {
                    this.devAccessor.setSpare(diskID.diskId, false);
                }
                diskID.isSpare = true;
            }
        }
        return cc;
    }

    private short getWidth(short ssType, int pool_id, int numDisks) throws GeneralException {
        int width = 0;
        int raid = 0;
        ResultSet rs = null;
        try {
            if (ssType == 12) {
                rs = this.vgAccessor.getStoragePoolDiskGroupWidthRaid(pool_id);
                if (rs.next()) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)("ResultSet state: " + rs.getCursorName() + "  fetch size: " + rs.getFetchSize()));
                    }
                    width = rs.getShort(1);
                    raid = rs.getShort(2);
                }
                SQLUtil.closeResources(rs);
                if (width == 0) {
                    width = raid == 5 ? 7 : (raid == 10 ? 4 : 1);
                }
            } else {
                width = ssType == 14 ? 1 : (numDisks == 0 ? 1 : (short)numDisks);
            }
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResChunk.class.getName(), (String)"getWidth", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        return (short)width;
    }

    private long getChunkSize(short width, float copiesOfData, int numDisks, long capacity, short ssType) {
        long size = 0L;
        if (ssType == 12) {
            size = capacity / (long)width;
        } else if (ssType == 15) {
            size = new Float((float)capacity * copiesOfData / (float)numDisks).longValue();
        }
        return size;
    }

    private ChunkCollection buildGenericChunkCollections(int logical_disk_id, long capacity, int numDisks, short width, short raid, Hashtable disk_ids, long offset, short ssType) throws GeneralException {
        int chunks = numDisks;
        ChunkCollection cc = new ChunkCollection();
        if (raid == 3) {
            cc = new ChunkCollection();
            cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            cc.ccSeqno = 1;
            cc.ccStripingSize = -1;
            cc.ccType = 1;
            cc.ccLogicalDiskID = logical_disk_id;
        } else if (raid == 4) {
            cc = new ChunkCollection();
            cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            cc.ccSeqno = 1;
            cc.ccStripingSize = -1;
            cc.ccType = (byte)5;
            cc.ccLogicalDiskID = logical_disk_id;
        } else if (raid == 0 || raid == 6) {
            cc = new ChunkCollection();
            cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            cc.ccSeqno = 1;
            cc.ccStripingSize = -1;
            cc.ccType = raid == 6 ? (byte)6 : (byte)2;
            cc.ccLogicalDiskID = logical_disk_id;
        } else if (raid == 1 || raid == 10 || raid == 9) {
            int numOfColls = numDisks / 2;
            if (raid == 10 || raid == 9) {
                --numOfColls;
            }
            cc = new ChunkCollection();
            int id = TResLogicalDisk.getIdentifier(1, numOfColls, this.dbc);
            cc.ccID = id++;
            cc.ccSeqno = 1;
            cc.ccStripingSize = -1;
            cc.ccType = (byte)5;
            cc.ccLogicalDiskID = logical_disk_id;
            ChunkCollection tmpCol = cc;
            for (int j = 1; j < numOfColls; ++j) {
                ChunkCollection cc1 = new ChunkCollection();
                cc1.ccID = id++;
                cc1.ccSeqno = (short)(j + 1);
                cc1.ccStripingSize = -1;
                cc1.ccType = (byte)5;
                cc1.ccLogicalDiskID = logical_disk_id;
                cc.ccNext = cc1;
                cc = cc1;
            }
            cc = tmpCol;
        } else {
            chunks = width;
            cc = new ChunkCollection();
            cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            cc.ccSeqno = 1;
            cc.ccStripingSize = 0x100000;
            cc.ccType = 0;
            cc.ccLogicalDiskID = logical_disk_id;
        }
        int diskNbr = 0;
        this.chunkSize = capacity / (long)width;
        ChunkCollection ccList = cc;
        while (ccList != null) {
            int chkSeqno = 0;
            Chunk prevChunk = null;
            for (int i = 0; i < chunks; ++i) {
                Chunk chk = new Chunk();
                if (width < 1) {
                    width = 1;
                }
                chk.chkSize = capacity / (long)width;
                chk.chkOffset = offset;
                chk.chkPartition = (short)-1;
                int n = chkSeqno;
                chkSeqno = (short)(chkSeqno + 1);
                chk.chkSeqno = (short)n;
                chk.chkUnitSize = 512;
                chk.chkCollection = ccList;
                chk.chkCollectionID = ccList.ccID;
                chk.chkLogicalDiskID = logical_disk_id;
                if (prevChunk == null) {
                    ccList.ccChunkList = chk;
                } else {
                    prevChunk.chkNextInCollection = chk;
                }
                prevChunk = chk;
                if (diskNbr >= numDisks) continue;
                int n2 = diskNbr;
                diskNbr = (short)(diskNbr + 1);
                chk.chkDiskID = ((DiskID)disk_ids.get((Object)new Integer((int)n2))).diskId;
            }
            ccList = ccList.ccNext;
        }
        if (chunks < numDisks) {
            for (int i = 0; i < numDisks - chunks; ++i) {
                int n = diskNbr;
                diskNbr = (short)(diskNbr + 1);
                DiskID diskID = (DiskID)disk_ids.get(new Integer(n));
                if (diskID == null) continue;
                if (!diskID.isSpare) {
                    this.devAccessor.setSpare(diskID.diskId, false);
                }
                diskID.isSpare = true;
            }
        }
        return cc;
    }

    private ChunkCollection buildDSChunkCollections(int logical_disk_id, int pool_id, long capacity, int numDisks, short raid, Hashtable disk_ids, long offset, short ssType) throws GeneralException {
        int width = 0;
        int chunks = 0;
        int dataDisks = 0;
        ChunkCollection cc = null;
        ChunkCollection prevCC = null;
        ChunkCollection ccList = null;
        short config = 0;
        short rWidth = 0;
        short arrayNum = 0;
        short diskCount = 0;
        try {
            int numRanks = 0;
            Hashtable<Integer, Short> rankWidth = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> rankConfig = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> rankArrayNumber = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> rankDiskCount = new Hashtable<Integer, Short>();
            ResultSet rsRanks = this.seAccessor.getLUNRankInfo(logical_disk_id);
            int i = 0;
            while (rsRanks.next()) {
                rankWidth.put(new Integer(i), new Short(rsRanks.getShort(1)));
                rankConfig.put(new Integer(i), new Short(rsRanks.getShort(2)));
                int rankid = rsRanks.getInt(3);
                short arrays = this.seAccessor.getNumOfArraySites(rankid);
                short disks = this.seAccessor.getNumOfDisks(rankid);
                rankArrayNumber.put(new Integer(i), new Short(arrays));
                rankDiskCount.put(new Integer(i), new Short(disks));
                ++numRanks;
                ++i;
            }
            SQLUtil.closeResources(rsRanks);
            for (int r1 = 0; r1 < numRanks; ++r1) {
                config = (Short)rankConfig.get(new Integer(r1));
                rWidth = (Short)rankWidth.get(new Integer(r1));
                arrayNum = (Short)rankArrayNumber.get(new Integer(r1));
                if (config == 5) {
                    width = (short)(width + rWidth);
                    width = (short)(width + arrayNum);
                    continue;
                }
                width = config == 10 ? (int)((short)(width + (short)(rWidth / 2))) : (config == 15 || config == 51 ? (int)((short)(width + (short)(rWidth + arrayNum * 2) / 2)) : (int)((short)(width + 1)));
            }
            if (width == 0) {
                width = ssType == 25 ? (raid == 0 ? 7 : (raid == 1 || raid == 9 || raid == 10 ? 4 : 1)) : (ssType == 27 ? (raid == 0 ? 3 : (raid == 1 || raid == 9 || raid == 10 ? 2 : 1)) : 1);
            }
            this.chunkSize = capacity / (long)width;
            int chunkIndex = 0;
            int spDiskNbr = 0;
            for (int r2 = 0; r2 < numRanks; ++r2) {
                int id;
                config = (Short)rankConfig.get(new Integer(r2));
                rWidth = (Short)rankWidth.get(new Integer(r2));
                arrayNum = (Short)rankArrayNumber.get(new Integer(r2));
                diskCount = (Short)rankDiskCount.get(new Integer(r2));
                if (config == 5) {
                    dataDisks = chunks = rWidth + arrayNum;
                    cc = new ChunkCollection();
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccSeqno = (short)chunkIndex;
                    cc.ccStripingSize = 0x100000;
                    cc.ccType = (byte)2;
                    cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                    cc.ccLogicalDiskID = logical_disk_id;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)("RAID 5 chunk collection created for logical_disk_id = " + logical_disk_id));
                    }
                } else if (config == 10) {
                    chunks = rWidth / 2;
                    dataDisks = chunks * 2;
                    cc = new ChunkCollection();
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccSeqno = (short)chunkIndex;
                    cc.ccStripingSize = 0x100000;
                    cc.ccType = 1;
                    id = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                    cc.ccID = id++;
                    cc.ccLogicalDiskID = logical_disk_id;
                    cc.ccNext = new ChunkCollection();
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccNext.ccSeqno = (short)chunkIndex;
                    cc.ccNext.ccStripingSize = 0x100000;
                    cc.ccNext.ccType = (byte)5;
                    cc.ccNext.ccID = id;
                    cc.ccNext.ccLogicalDiskID = logical_disk_id;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)("RAID 10 chunk collection created for logical_disk_id = " + logical_disk_id));
                    }
                } else if (config == 15 || config == 51) {
                    chunks = (rWidth + arrayNum * 2) / 2;
                    dataDisks = chunks * 2;
                    cc = new ChunkCollection();
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccSeqno = (short)chunkIndex;
                    cc.ccStripingSize = 0x100000;
                    cc.ccType = (byte)2;
                    id = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                    cc.ccID = id++;
                    cc.ccLogicalDiskID = logical_disk_id;
                    cc.ccNext = new ChunkCollection();
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccNext.ccSeqno = (short)chunkIndex;
                    cc.ccNext.ccStripingSize = 0x100000;
                    cc.ccNext.ccType = (byte)5;
                    cc.ccNext.ccID = id;
                    cc.ccNext.ccLogicalDiskID = logical_disk_id;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)("RAID 15 or 51 chunk collection created for logical_disk_id = " + logical_disk_id));
                    }
                } else {
                    dataDisks = chunks = 1;
                    this.ldAccessor.setLogicalDiskType(logical_disk_id, (byte)0);
                    cc = new ChunkCollection();
                    cc.ccID = -1;
                    chunkIndex = (short)(chunkIndex + 1);
                    cc.ccSeqno = (short)chunkIndex;
                    cc.ccStripingSize = 0x100000;
                    cc.ccType = 0;
                    cc.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                    cc.ccLogicalDiskID = logical_disk_id;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)2, (String)TResChunk.class.getName(), (String)"buildSSChunkInfo", (String)("JBOD chunk collection created for logical_disk_id = " + logical_disk_id));
                    }
                }
                short diskNbr = 0;
                ChunkCollection cColl = cc;
                while (cColl != null) {
                    int chkSeqno = 0;
                    Chunk prevChunk = null;
                    for (int i2 = 0; i2 < chunks; ++i2) {
                        Chunk chk = new Chunk();
                        chk.chkSize = capacity / (long)width;
                        chk.chkOffset = offset;
                        chk.chkPartition = (short)-1;
                        int n = chkSeqno;
                        chkSeqno = (short)(chkSeqno + 1);
                        chk.chkSeqno = (short)n;
                        chk.chkUnitSize = 512;
                        chk.chkCollection = cColl;
                        chk.chkLogicalDiskID = logical_disk_id;
                        chk.chkCollectionID = cColl.ccID;
                        if (prevChunk == null) {
                            cColl.ccChunkList = chk;
                        } else {
                            prevChunk.chkNextInCollection = chk;
                        }
                        prevChunk = chk;
                        if (diskNbr >= diskCount) continue;
                        int n2 = spDiskNbr;
                        spDiskNbr = (short)(spDiskNbr + 1);
                        DiskID id2 = (DiskID)disk_ids.get(new Integer(n2));
                        if (id2 != null) {
                            chk.chkDiskID = id2.diskId;
                        }
                        diskNbr = (short)(diskNbr + 1);
                    }
                    cColl = cColl.ccNext;
                }
                if (dataDisks < diskCount) {
                    for (int i3 = 0; i3 < diskCount - dataDisks; ++i3) {
                        int n = spDiskNbr;
                        spDiskNbr = (short)(spDiskNbr + 1);
                        DiskID diskID = (DiskID)disk_ids.get(new Integer(n));
                        if (diskID == null) continue;
                        if (!diskID.isSpare) {
                            this.devAccessor.setSpare(diskID.diskId, false);
                        }
                        diskID.isSpare = true;
                    }
                }
                if (prevCC == null) {
                    prevCC = cc;
                } else {
                    prevCC.ccNext = cc;
                }
                ccList = prevCC;
            }
        }
        catch (SQLException sqlEx) {
            this.sqlError(sqlEx);
        }
        return ccList;
    }

    public short[] getRaid(String raidLevels) {
        Pattern p = Pattern.compile(" ");
        String[] each_rl = p.split(raidLevels);
        short[] raid = new short[each_rl.length];
        for (int i = 0; i < each_rl.length; ++i) {
            raid[i] = 11;
            for (int j = 0; j < VolGroup.RAID_LEVELS.length; j = (int)((short)(j + 1))) {
                if (!VolGroup.RAID_LEVELS[j].equalsIgnoreCase(each_rl[i].trim())) continue;
                raid[i] = j;
            }
        }
        return raid;
    }

    public Hashtable buildFakeDisk(int ss_id, int pool_id, short ssType) throws GeneralException {
        Hashtable<Integer, DiskID> disks = new Hashtable<Integer, DiskID>();
        Disk disk = new Disk();
        disk.initUnknown();
        disk.devFlags = 1;
        disk.devType = 0;
        disk.devStorageSystemType = (short)14;
        disk.dskLogicalBlockSize = 512;
        disk.dskSectorSize = 512;
        String diskName = null;
        diskName = ssType == 18 ? "HP DISK" : (ssType == 14 ? "HDS Disk" : "Disk");
        this.cmpAccessor.prepGetSS();
        NasFiler filer = this.cmpAccessor.getSS(ss_id);
        disk.devSerialNumber = diskName + "-" + filer.nfName + "_" + pool_id;
        disk.devManufacturer = filer.nfManufacturer;
        disk.devName = diskName;
        this.devAccessor.saveDevices((Device)disk);
        int pvID = this.devAccessor.getPVID(disk.devSerialNumber);
        DiskID diskID = new DiskID();
        diskID.diskId = pvID;
        diskID.isSpare = false;
        disks.put(new Integer(0), diskID);
        return disks;
    }

    static {
        SELECT = SQLUtil.isSybase() || SQLUtil.isUDB() ? SELECT + "a.\"partition\", " : SELECT + "a.partition, ";
        SELECT = SELECT + "a.unit_size, a.chunk_size, a.offset, a.has_db from t_res_chunk a";
        INSERT = "insert into t_res_chunk (disk_id, collection_id, logical_disk_id, seqno,";
        INSERT = SQLUtil.isSybase() || SQLUtil.isUDB() ? INSERT + "\"partition\", " : INSERT + "partition, ";
        INSERT = INSERT + "offset, chunk_size, unit_size, has_db) values (?,?,?,?,?,?,?,?,?)";
    }

    private class DiskID {
        public int diskId;
        public boolean isSpare;

        private DiskID() {
        }
    }
}

