/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResDomain
extends StorageRepositoryAccessor
implements NameListQueryable {
    public static final String TABLE_NAME = "t_res_domain";
    public static final String TREE_COLUMN = "tree_id";
    private static final String SELECT_DOMAIN = "select d.domain_id, d.name, d.tree_id from t_res_domain d";
    private static final String BY_NAME = " where d.name = ?";
    private static final String BY_ID = " where d.domain_id = ?";
    private static final String BY_COMPUTER_ID = ", t_stat_computer c where c.computer_id = ? and c.domain_id = d.domain_id";
    private static final String INSERT = "insert into t_res_domain ( domain_id, name, tree_id) values (?,?,?)";

    public TResDomain(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"TResDomain", (String)"dbc");
        }
        this.tableName = TABLE_NAME;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"TResDomain");
        }
    }

    public boolean getIDs(Domain domainList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"getIDs", (String)"domainList");
        }
        boolean rowInserted = false;
        if (domainList == null) {
            boolean traceResult = rowInserted;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDomain.class.getName(), (String)"getIDs", (boolean)traceResult);
            }
            return traceResult;
        }
        Domain domain = null;
        int identifierCount = 0;
        try {
            this.selectStmt = this.prepareStmt("select d.domain_id, d.name, d.tree_id from t_res_domain d where d.name = ?");
            domain = domainList;
            while (domain != null) {
                if (!this.fetchByName(domain)) {
                    ++identifierCount;
                }
                domain = domain.domNext;
            }
            if (identifierCount > 0) {
                int identifier = TResDomain.getIdentifier(1, identifierCount, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT);
                domain = domainList;
                while (domain != null) {
                    if (domain.domID == -1) {
                        domain.domID = identifier++;
                        boolean insertStatus = this.insert(domain);
                        if (insertStatus) {
                            rowInserted = true;
                        } else if (!this.fetchByName(domain)) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exit((String)TResDomain.class.getName(), (String)"getIDs");
                            }
                            throw new SQLException();
                        }
                    }
                    domain = domain.domNext;
                }
                this.closeInsert();
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDomain.class.getName(), (String)"getIDs", (Throwable)e);
            }
            this.sqlError(e);
        }
        boolean traceResult = rowInserted;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"getIDs", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepFetchByComputerID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select d.domain_id, d.name, d.tree_id from t_res_domain d, t_stat_computer c where c.computer_id = ? and c.domain_id = d.domain_id");
    }

    public void prepFetchByID() throws GeneralException {
        this.selectStmt = this.prepareStmt("select d.domain_id, d.name, d.tree_id from t_res_domain d where d.domain_id = ?");
    }

    public void getName(Domain domain) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"getName", (String)"domain");
        }
        if (domain == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDomain.class.getName(), (String)"getName");
            }
            return;
        }
        this.prepFetchByID();
        this.fetchByID(domain, false);
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"getName");
        }
    }

    private boolean fetchByName(Domain domain) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"fetchByName", (String)"domain");
        }
        this.stmtType = 0;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(this.selectStmt, domain.domName);
        domain.domID = -1;
        boolean traceResult = this.fetchDomain(domain);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"fetchByName", (boolean)traceResult);
        }
        return traceResult;
    }

    public void fetchByID(Domain domain, boolean failFriendly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"fetchByID", (String)"domain, failFriendly");
        }
        boolean result = false;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, domain.domID);
            result = this.fetchDomain(domain);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDomain.class.getName(), (String)"fetchByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        if (!result) {
            domain.domName = failFriendly ? "? (" + domain.domID + ")" : null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"fetchByID");
        }
    }

    public void fetchByID(Domain domain) throws GeneralException {
        this.fetchByID(domain, true);
    }

    private boolean fetchDomain(Domain domain) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"fetchDomain", (String)"domain");
        }
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        boolean result = this.resultSet.next();
        if (result) {
            this.stmtPhase = 1;
            this.colIndex = 1;
            domain.domID = this.getInt(this.resultSet);
            domain.domName = this.getString(this.resultSet);
            domain.domTreeID = this.getInt(this.resultSet);
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"fetchDomain", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean insert(Domain domain) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"insert", (String)"domain");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, domain.domID);
        this.setString(this.insertStmt, domain.domName);
        this.setInt(this.insertStmt, domain.domTreeID);
        try {
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDomain.class.getName(), (String)"insert", (Throwable)e);
            }
            if (!SQLUtil.isDuplicateKeyViolation(e)) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResDomain.class.getName(), (String)"insert");
                }
                throw e;
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResDomain.class.getName(), (String)"insert", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"insert", (boolean)traceResult);
        }
        return traceResult;
    }

    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDomain.class.getName(), (String)"selectNames", (String)"requestData");
        }
        NameList head = null;
        NameList prev = null;
        this.selectStmt = this.prepareStmt("select d.domain_id, d.name, d.tree_id from t_res_domain d order by name");
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                NameList element = new NameList();
                this.colIndex = 1;
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                if (prev == null) {
                    head = element;
                } else {
                    prev.nlNext = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDomain.class.getName(), (String)"selectNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDomain.class.getName(), (String)"selectNames", traceResult);
        }
        return traceResult;
    }
}

