/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResExport
extends StorageRepositoryAccessor {
    private long currentTime = 0L;
    private static final String SELECT = "select export_id, computer_id, protocol, path, export_name, discovered_time from t_res_export ";
    private static final String BY_COMPUTER = "where computer_id = ?";
    private static final String BY_PROTOCOL = " and protocol = ?";
    private static final String ORDER_BY_NAME = " order by export_name desc";
    private static final String ORDER_BY_COMPUTER = "order by computer_id desc, export_name desc";
    private static final String INSERT = "insert into t_res_export ( export_id, computer_id, protocol, export_name, path, discovered_time) values (?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_export set protocol = ?, export_name = ? where export_id = ?";
    private static final String DELETE = "delete from t_res_export where export_id = ?";

    public TResExport(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"TResExport", (String)"dbc");
        }
        try {
            this.currentTime = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExport.class.getName(), (String)"TResExport", (Throwable)e);
            }
            return;
        }
        this.tableName = "t_res_export";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExport.class.getName(), (String)"TResExport");
        }
    }

    public Export selectByComputer(int computerID) throws GeneralException {
        return this.selectByComputer(computerID, (byte)-1);
    }

    public Export selectByComputer(int computerID, byte protocol) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"selectByComputer", (String)"computerID, protocol");
        }
        try {
            if (computerID == -2) {
                this.selectStmt = this.prepareStmt("select export_id, computer_id, protocol, path, export_name, discovered_time from t_res_export order by computer_id desc, export_name desc");
            } else {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append(SELECT);
                buffer.append(BY_COMPUTER);
                if (protocol >= 0) {
                    buffer.append(BY_PROTOCOL);
                }
                buffer.append(ORDER_BY_NAME);
                this.selectStmt = this.prepareStmt(buffer.toString());
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.setInt(this.selectStmt, computerID);
                if (protocol >= 0) {
                    this.setByte(this.selectStmt, protocol);
                }
            }
            Export exportList = this.getResultSet();
            this.closeSelect();
            Export traceResult = exportList;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResExport.class.getName(), (String)"selectByComputer", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExport.class.getName(), (String)"selectByComputer", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            Export traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResExport.class.getName(), (String)"selectByComputer", traceResult);
            }
            return traceResult;
        }
    }

    private Export getResultSet() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"getResultSet", (String)"");
        }
        Export exportList = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while (this.resultSet.next()) {
            Export export = new Export();
            this.stmtPhase = 1;
            this.colIndex = 1;
            export.xpExportID = this.getInt(this.resultSet);
            export.xpComputerID = this.getInt(this.resultSet);
            export.xpProtocol = this.getByte(this.resultSet);
            export.xpPath = this.getString(this.resultSet);
            export.xpExportName = this.getString(this.resultSet);
            export.xpDiscoveredTime = this.getTimestamp(this.resultSet);
            export.xpNext = exportList;
            exportList = export;
        }
        this.closeResultSet();
        Export traceResult = exportList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExport.class.getName(), (String)"getResultSet", traceResult);
        }
        return traceResult;
    }

    public void insert(Export exportList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"insert", (String)"exportList");
        }
        int identifier = 0;
        Export export = exportList;
        while (export != null) {
            ++identifier;
            export = export.xpNext;
        }
        identifier = TResExport.getIdentifier(1, identifier, this.dbc);
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            export = exportList;
            while (export != null) {
                this.stmtPhase = 0;
                export.xpExportID = identifier++;
                this.colIndex = 1;
                this.setInt(this.insertStmt, export.xpExportID);
                this.setInt(this.insertStmt, export.xpComputerID);
                this.setByte(this.insertStmt, export.xpProtocol);
                this.setString(this.insertStmt, export.xpExportName);
                this.setString(this.insertStmt, export.xpPath);
                this.setTimestamp(this.insertStmt, this.currentTime);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                export = export.xpNext;
            }
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExport.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExport.class.getName(), (String)"insert");
        }
    }

    public void update(Export exportList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"update", (String)"exportList");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            Export export = exportList;
            while (export != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setByte(this.updateStmt, export.xpProtocol);
                this.setString(this.updateStmt, export.xpExportName);
                this.setInt(this.updateStmt, export.xpExportID);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                export = export.xpNext;
            }
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExport.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExport.class.getName(), (String)"update");
        }
    }

    public void delete(Export exportList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResExport.class.getName(), (String)"delete", (String)"exportList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE);
            Export export = exportList;
            while (export != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, export.xpExportID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                export = export.xpNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResExport.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResExport.class.getName(), (String)"delete");
        }
    }
}

